/*
 * Decompiled with CFR 0.152.
 */
package com.twincoders.twinpush.sdk.communications.requests.forms;

import com.twincoders.twinpush.sdk.communications.TwinRequest;
import com.twincoders.twinpush.sdk.communications.requests.TwinPushRequest;
import com.twincoders.twinpush.sdk.notifications.PushNotification;
import java.util.Map;
import org.json.JSONObject;

public class ReportFormRequest
extends TwinPushRequest {
    private static final String BASE_URL = "https://forms.twinpush.com";
    private static final String REPORT_SEGMENT = "report";
    private static final String REPORTER_TOKEN = "reporter_token";
    private static final String NOTIFICATION_ID = "notification_id";
    private static final String TITLE = "title";
    private static final String MESSAGE = "message";
    private static final String DEVICE_ID = "device_id";
    private static final String ALIAS = "alias";
    private static final String FORM = "form";
    Listener listener;

    public ReportFormRequest(String deviceId, String alias, String appToken, String reporterToken, PushNotification notification, Map<String, Object> form, Listener listener) {
        super(appToken);
        this.listener = listener;
        this.httpMethod = TwinRequest.HttpMethod.POST;
        this.addSegmentParam(REPORT_SEGMENT);
        this.addParam(REPORTER_TOKEN, reporterToken);
        if (notification != null) {
            this.addParam(NOTIFICATION_ID, notification.getId());
            this.addParam(TITLE, notification.getTitle());
            this.addParam(MESSAGE, notification.getMessage());
        }
        this.addParam(DEVICE_ID, deviceId);
        this.addParam(ALIAS, alias);
        this.addParam(FORM, form);
    }

    @Override
    public String getBaseURL() {
        return BASE_URL;
    }

    @Override
    public void onResponseProcess(String response) {
        this.getListener().onSuccess();
    }

    @Override
    public Listener getListener() {
        return this.listener;
    }

    @Override
    protected void onResponseProcess(JSONObject response) {
    }

    @Override
    protected void onSuccess(JSONObject response) {
    }

    public static interface Listener
    extends TwinRequest.ErrorListener {
        public void onSuccess();
    }
}

