/*
 * Decompiled with CFR 0.152.
 */
package com.twincoders.twinpush.sdk.communications.requests;

import com.twincoders.twinpush.sdk.TwinPushSDK;
import com.twincoders.twinpush.sdk.communications.RESTJSONRequest;
import com.twincoders.twinpush.sdk.entities.InboxNotification;
import com.twincoders.twinpush.sdk.logging.Ln;
import com.twincoders.twinpush.sdk.notifications.PushNotification;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class TwinPushRequest
extends RESTJSONRequest {
    private static final String TWINPUSH_URL = "%s/api/v2";
    private static final String APPLICATIONS_SEGMENT = "apps";
    private static final String DEVICES_SEGMENT = "devices";
    private static final String NOTIFICATIONS_SEGMENT = "notifications";
    private static final int STATUS_CODE_INVALID_ELEMENT = 422;
    private static final int STATUS_CODE_FORBIDDEN = 403;
    private static final int STATUS_CODE_EMPTY = 404;
    private static final String ERRORS_KEY = "errors";
    private static final String ERROR_MESSAGE_KEY = "message";
    protected boolean sequential = false;
    private SimpleDateFormat dateFormat = null;

    public TwinPushRequest(String appId) {
        this(appId, null, null);
    }

    public TwinPushRequest(String appId, String deviceId) {
        this(appId, deviceId, null);
    }

    public TwinPushRequest(String appId, String deviceId, String notificationId) {
        if (appId != null) {
            this.addSegmentParam(APPLICATIONS_SEGMENT);
            this.addSegmentParam(appId);
        }
        if (deviceId != null) {
            this.addSegmentParam(DEVICES_SEGMENT);
            this.addSegmentParam(deviceId);
        }
        if (notificationId != null) {
            this.addSegmentParam(NOTIFICATIONS_SEGMENT);
            this.addSegmentParam(notificationId);
        }
    }

    @Override
    public String getBaseURL() {
        String host = TwinPushSDK.getInstance(this.getRequestLauncher().getContext()).getServerHost();
        return String.format(TWINPUSH_URL, host);
    }

    @Override
    public boolean isHttpResponseStatusValid(int httpResponseStatusCode) {
        return httpResponseStatusCode == 422 || httpResponseStatusCode == 403 || httpResponseStatusCode == 404;
    }

    @Override
    protected void onResponseProcess(JSONObject response) {
        try {
            if (response.isNull(ERRORS_KEY)) {
                this.onSuccess(response);
            } else {
                String errorMessage;
                JSONObject errorsJson = response.getJSONObject(ERRORS_KEY);
                Object errorMessageObj = errorsJson.get(ERROR_MESSAGE_KEY);
                if (errorMessageObj instanceof String) {
                    errorMessage = (String)errorMessageObj;
                } else {
                    JSONArray errorsMessages = errorsJson.getJSONArray(ERROR_MESSAGE_KEY);
                    StringBuilder builder = new StringBuilder();
                    for (int i = 0; i < errorsMessages.length(); ++i) {
                        if (i > 0) {
                            builder.append("\n");
                        }
                        builder.append(errorsMessages.getString(i));
                    }
                    errorMessage = builder.toString();
                }
                this.getListener().onError(new Exception(errorMessage));
            }
        }
        catch (JSONException e) {
            this.getListener().onError((Exception)((Object)e));
        }
    }

    private String getNullableString(JSONObject json, String name) throws JSONException {
        return json.has(name) && !json.isNull(name) ? json.getString(name) : null;
    }

    public boolean isSequential() {
        return this.sequential;
    }

    protected abstract void onSuccess(JSONObject var1);

    protected PushNotification parseNotification(JSONObject json) throws JSONException {
        PushNotification n = new PushNotification();
        n.setId(this.getNullableString(json, "id"));
        n.setTitle(this.getNullableString(json, "title"));
        n.setMessage(this.getNullableString(json, "alert"));
        n.setSound(this.getNullableString(json, "sound"));
        n.setRichURL(this.getNullableString(json, "tp_rich_url"));
        n.setCustomProperties(this.getCustomPropertiesMap(json.getJSONObject("custom_properties")));
        if (!json.isNull("tags")) {
            n.setTags(this.getTags(json.getJSONArray("tags")));
        }
        String dateString = this.getNullableString(json, json.has("last_sent_at") ? "last_sent_at" : "send_since");
        n.setDate(this.parseDate(dateString));
        return n;
    }

    private Map<String, String> getCustomPropertiesMap(JSONObject json) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        Iterator iter = json.keys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            try {
                if (json.isNull(key)) continue;
                String value = (String)json.get(key);
                propertiesMap.put(key, value);
            }
            catch (JSONException e) {
                Ln.e(e, (Object)"Could not find property %1$s on Custom properties JSON", new Object[0]);
            }
        }
        return propertiesMap;
    }

    private List<String> getTags(JSONArray json) {
        ArrayList<String> tags = new ArrayList<String>();
        try {
            for (int i = 0; i < json.length(); ++i) {
                String tag = json.getString(i);
                tags.add(tag);
            }
        }
        catch (JSONException e) {
            Ln.e(e, (Object)"Error while trying to obtain tags for notification", new Object[0]);
        }
        return tags;
    }

    protected InboxNotification parseInboxNotification(JSONObject json) throws JSONException {
        InboxNotification n = new InboxNotification();
        n.setId(this.getNullableString(json, "id"));
        n.setNotification(this.parseNotification(json.getJSONObject("notification")));
        n.setCreatedAt(this.parseDate(this.getNullableString(json, "created_at")));
        n.setOpenAt(this.parseDate(this.getNullableString(json, "open_at")));
        return n;
    }

    private Date parseDate(String dateString) {
        Date date = null;
        if (dateString != null) {
            if (this.dateFormat == null) {
                this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss 'UTC'", Locale.UK);
                this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            }
            try {
                date = this.dateFormat.parse(dateString);
            }
            catch (ParseException e) {
                Ln.e(e, (Object)"Error while trying to parse notification date", new Object[0]);
            }
        }
        return date;
    }

    private static class NotificationFields {
        static final String ID_KEY = "id";
        static final String TITLE_KEY = "title";
        static final String MESSAGE_KEY = "alert";
        static final String TAGS_KEY = "tags";
        static final String SOUND_KEY = "sound";
        static final String RICH_URL_KEY = "tp_rich_url";
        static final String CUSTOM_PROPERTIES_KEY = "custom_properties";
        static final String DATE = "last_sent_at";
        static final String DATE_ALT = "send_since";
        static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss 'UTC'";

        private NotificationFields() {
        }
    }

    private static class InboxItemFields {
        static final String ID = "id";
        static final String CREATED_AT = "created_at";
        static final String OPEN_AT = "open_at";
        static final String NOTIFICATION = "notification";

        private InboxItemFields() {
        }
    }
}

