/*
 * Decompiled with CFR 0.152.
 */
package com.twincoders.twinpush.sdk.communications;

import android.net.Uri;
import com.twincoders.twinpush.sdk.communications.DefaultRequest;
import com.twincoders.twinpush.sdk.communications.TwinRequest;
import com.twincoders.twinpush.sdk.communications.TwinRequestParam;
import com.twincoders.twinpush.sdk.logging.Ln;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class RESTRequest
extends DefaultRequest {
    List<String> segmentParams = new ArrayList<String>();
    protected String baseURL = null;
    protected String resourceName = null;
    protected String methodName = null;

    public RESTRequest() {
        this.httpMethod = TwinRequest.HttpMethod.GET;
    }

    public void addSegmentParam(String param) {
        this.segmentParams.add(param);
    }

    protected void serializeSegments(List<String> segments, Uri.Builder b) {
        for (String segment : segments) {
            b.appendPath(segment);
        }
    }

    protected void serializeParams(List<TwinRequestParam> params, Uri.Builder b) {
        if (this.httpMethod == TwinRequest.HttpMethod.GET) {
            for (TwinRequestParam param : params) {
                if (param.getParamType() == TwinRequestParam.ParamType.ARRAY) {
                    String paramName = param.getKey() + "[]";
                    for (String value : param.getArrayValue()) {
                        b.appendQueryParameter(paramName, value);
                    }
                    continue;
                }
                b.appendQueryParameter(param.getKey(), param.getValue().toString());
            }
        }
    }

    @Override
    public String getURL() {
        String url = "";
        if (this.getBaseURL() != null) {
            Uri.Builder b = Uri.parse((String)this.getBaseURL()).buildUpon();
            if (this.getResourceName() != null) {
                b.appendPath(this.getResourceName());
            }
            if (this.getMethodName() != null) {
                b.appendPath(this.getMethodName());
            }
            this.serializeSegments(this.segmentParams, b);
            this.serializeParams(this.getParams(), b);
            url = b.build().toString();
        }
        return url;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    protected JSONObject serializeBodyParams(List<TwinRequestParam> params) {
        JSONObject json = new JSONObject();
        for (TwinRequestParam param : params) {
            try {
                switch (param.getParamType()) {
                    case SIMPLE: {
                        if (param.getValue() == null) break;
                        if (param.getValue() instanceof Map) {
                            json.put(param.getKey(), (Object)new JSONObject((Map)param.getValue()));
                            break;
                        }
                        json.put(param.getKey(), param.getValue());
                        break;
                    }
                    case ARRAY: {
                        if (param.getArrayValue() == null) break;
                        JSONArray array = new JSONArray(param.getArrayValue());
                        json.put(param.getKey(), (Object)array);
                    }
                }
            }
            catch (JSONException e) {
                Ln.e(e, (Object)"Error while trying to serialize params", new Object[0]);
            }
        }
        return json;
    }

    @Override
    public String getBodyContent() {
        String body = this.serializeBodyParams(this.getParams()).toString();
        return body;
    }
}

