package com.twincoders.twinpush.sdk.util;

import android.annotation.SuppressLint;
import android.util.Base64;

import com.twincoders.twinpush.sdk.logging.Ln;

import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class StringEncrypter {

	Cipher ecipher;
	Cipher dcipher;

	@SuppressLint("TrulyRandom")
	public StringEncrypter(String password) {

		// 8-bytes Salt
		byte[] salt = {
				(byte)0xA9, (byte)0x9B, (byte)0xC8, (byte)0x32,
				(byte)0x56, (byte)0x34, (byte)0xE3, (byte)0x03
		};

		// Iteration count
		int iterationCount = 19;

		try {

			KeySpec keySpec = new PBEKeySpec(password.toCharArray(), salt, iterationCount);
			SecretKey key = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(keySpec);

			ecipher = Cipher.getInstance(key.getAlgorithm());
			dcipher = Cipher.getInstance(key.getAlgorithm());

			// Prepare the parameters to the cipthers
			AlgorithmParameterSpec paramSpec = new PBEParameterSpec(salt, iterationCount);

			ecipher.init(Cipher.ENCRYPT_MODE, key, paramSpec);
			dcipher.init(Cipher.DECRYPT_MODE, key, paramSpec);

		} catch (InvalidAlgorithmParameterException e) {
			Ln.e(e);
		} catch (InvalidKeySpecException e) {
			Ln.e(e);
		} catch (NoSuchPaddingException e) {
			Ln.e(e);
		} catch (NoSuchAlgorithmException e) {
			Ln.e(e);
		} catch (InvalidKeyException e) {
			Ln.e(e);
		}
	}
	
	/**
	 * Takes a single String as an argument and returns an Encrypted version
	 * of that String.
	 * @param str String to be encrypted
	 * @return <code>String</code> Encrypted version of the provided String
	 */
	public String encryptString(String str) {
		byte[] encryptedByteArray = encrypt(str);
		// Encode bytes to base64 to get a string
		return Base64.encodeToString(encryptedByteArray, Base64.DEFAULT);
	}
	
	/**
	 * Takes a encrypted String as an argument, decrypts and returns the
	 * decrypted String.
	 * @param str Encrypted String to be decrypted
	 * @return <code>String</code> Decrypted version of the provided String
	 */
	public String decryptString(String str) {
		byte[] encryptedByteArray = Base64.decode(str, Base64.DEFAULT);
		String decryptedText = decrypt(encryptedByteArray);
		return decryptedText;
	}

	private byte[] encrypt(String str) {
		try {
			// Encode the string into bytes using utf-8
			byte[] utf8 = str.getBytes("UTF8");

			// Encrypt
			byte[] enc = ecipher.doFinal(utf8);

			return enc;

		} catch (BadPaddingException e) {
			Ln.e(e);
		} catch (IllegalBlockSizeException e) {
			Ln.e(e);
		} catch (UnsupportedEncodingException e) {
			Ln.e(e);
		}
		return null;
	}

	private String decrypt(byte[] dec) {

		try {
			// Decrypt
			byte[] utf8 = dcipher.doFinal(dec);

			// Decode using utf-8
			return new String(utf8, "UTF8");

		} catch (BadPaddingException e) {
			Ln.e(e);
		} catch (IllegalBlockSizeException e) {
			Ln.e(e);
		} catch (UnsupportedEncodingException e) {
			Ln.e(e);
		}
		return null;
	}
}