/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.p2p.base.Constant;
import org.tron.p2p.discover.Node;
import org.tron.p2p.protos.Discover;
import org.tron.p2p.utils.ByteArray;

public class NetUtil {
    private static final Logger log = LoggerFactory.getLogger((String)"net");
    public static final Pattern PATTERN_IPv4 = Pattern.compile("^(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|[1-9])\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)$");
    public static final Pattern PATTERN_IPv6 = Pattern.compile("^\\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?\\s*$");

    public static boolean validIpV4(String ip) {
        if (StringUtils.isEmpty((CharSequence)ip)) {
            return false;
        }
        return PATTERN_IPv4.matcher(ip).find();
    }

    public static boolean validIpV6(String ip) {
        if (StringUtils.isEmpty((CharSequence)ip)) {
            return false;
        }
        return PATTERN_IPv6.matcher(ip).find();
    }

    public static boolean validNode(Node node) {
        if (node == null || node.getId() == null) {
            return false;
        }
        if (node.getId().length != 64) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)node.getHostV4()) && StringUtils.isEmpty((CharSequence)node.getHostV6())) {
            return false;
        }
        if (StringUtils.isNotEmpty((CharSequence)node.getHostV4()) && !NetUtil.validIpV4(node.getHostV4())) {
            return false;
        }
        return !StringUtils.isNotEmpty((CharSequence)node.getHostV6()) || NetUtil.validIpV6(node.getHostV6());
    }

    public static Node getNode(Discover.Endpoint endpoint) {
        return new Node(endpoint.getNodeId().toByteArray(), ByteArray.toStr(endpoint.getAddress().toByteArray()), ByteArray.toStr(endpoint.getAddressIpv6().toByteArray()), endpoint.getPort());
    }

    public static byte[] getNodeId() {
        Random gen = new Random();
        byte[] id = new byte[64];
        gen.nextBytes(id);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getExternalIp(String url) {
        BufferedReader in = null;
        String ip = null;
        try {
            URLConnection urlConnection = new URL(url).openConnection();
            in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
            ip = in.readLine();
            if (ip == null || ip.trim().isEmpty()) {
                throw new IOException("Invalid address: " + ip);
            }
            try {
                InetAddress.getByName(ip);
            }
            catch (Exception e) {
                throw new IOException("Invalid address: " + ip);
            }
            String string = ip;
            return string;
        }
        catch (Exception e) {
            log.warn("Fail to get {} by {}, cause:{}", new Object[]{Constant.ipV4Urls.contains(url) ? "ipv4" : "ipv6", url, e.getMessage()});
            String string = ip;
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String getOuterIPv6Address() {
        Enumeration<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            log.warn("GetOuterIPv6Address failed", (Throwable)e);
            return null;
        }
        while (networkInterfaces.hasMoreElements()) {
            Enumeration<InetAddress> inetAds = networkInterfaces.nextElement().getInetAddresses();
            while (inetAds.hasMoreElements()) {
                InetAddress inetAddress = inetAds.nextElement();
                if (!(inetAddress instanceof Inet6Address) || NetUtil.isReservedAddress(inetAddress)) continue;
                String ipAddress = inetAddress.getHostAddress();
                int index = ipAddress.indexOf(37);
                if (index > 0) {
                    ipAddress = ipAddress.substring(0, index);
                }
                return ipAddress;
            }
        }
        return null;
    }

    public static Set<String> getAllLocalAddress() {
        Enumeration<NetworkInterface> networkInterfaces;
        HashSet<String> localIpSet = new HashSet<String>();
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            log.warn("GetAllLocalAddress failed", (Throwable)e);
            return localIpSet;
        }
        while (networkInterfaces.hasMoreElements()) {
            Enumeration<InetAddress> inetAds = networkInterfaces.nextElement().getInetAddresses();
            while (inetAds.hasMoreElements()) {
                InetAddress inetAddress = inetAds.nextElement();
                String ipAddress = inetAddress.getHostAddress();
                int index = ipAddress.indexOf(37);
                if (index > 0) {
                    ipAddress = ipAddress.substring(0, index);
                }
                localIpSet.add(ipAddress);
            }
        }
        return localIpSet;
    }

    private static boolean isReservedAddress(InetAddress inetAddress) {
        return inetAddress.isAnyLocalAddress() || inetAddress.isLinkLocalAddress() || inetAddress.isLoopbackAddress() || inetAddress.isMulticastAddress();
    }

    public static String getExternalIpV4() {
        return NetUtil.getIp(Constant.ipV4Urls);
    }

    public static String getExternalIpV6() {
        String ipV6 = NetUtil.getIp(Constant.ipV6Urls);
        if (null == ipV6) {
            ipV6 = NetUtil.getOuterIPv6Address();
        }
        return ipV6;
    }

    public static InetSocketAddress parseInetSocketAddress(String para) {
        int index = para.trim().lastIndexOf(":");
        if (index > 0) {
            String host = para.substring(0, index);
            if (host.startsWith("[") && host.endsWith("]")) {
                host = host.substring(1, host.length() - 1);
            } else if (host.contains(":")) {
                throw new RuntimeException(String.format("Invalid inetSocketAddress: \"%s\", use ipv4:port or [ipv6]:port", para));
            }
            int port = Integer.parseInt(para.substring(index + 1));
            return new InetSocketAddress(host, port);
        }
        throw new RuntimeException(String.format("Invalid inetSocketAddress: \"%s\", use ipv4:port or [ipv6]:port", para));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getIp(List<String> multiSrcUrls) {
        ExecutorService executor = Executors.newCachedThreadPool();
        ExecutorCompletionService completionService = new ExecutorCompletionService(executor);
        ArrayList tasks = new ArrayList();
        multiSrcUrls.forEach(url -> tasks.add(() -> NetUtil.getExternalIp(url)));
        for (Callable task : tasks) {
            completionService.submit(task);
        }
        String result = null;
        try {
            Future future = completionService.take();
            result = (String)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
        }
        finally {
            executor.shutdownNow();
        }
        return result;
    }
}

