/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.dns.tree;

import com.google.protobuf.InvalidProtocolBufferException;
import java.math.BigInteger;
import java.net.UnknownHostException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.p2p.dns.DnsNode;
import org.tron.p2p.dns.tree.Algorithm;
import org.tron.p2p.dns.tree.BranchEntry;
import org.tron.p2p.dns.tree.Entry;
import org.tron.p2p.dns.tree.LinkEntry;
import org.tron.p2p.dns.tree.NodesEntry;
import org.tron.p2p.dns.tree.RootEntry;
import org.tron.p2p.exception.DnsException;
import org.tron.p2p.utils.ByteArray;

public class Tree {
    private static final Logger log = LoggerFactory.getLogger((String)"net");
    public static final int HashAbbrevSize = 27;
    public static final int MaxChildren = 13;
    private RootEntry rootEntry;
    private Map<String, Entry> entries;
    private String privateKey;
    private String base32PublicKey;

    public Tree() {
        this.init();
    }

    private void init() {
        this.entries = new ConcurrentHashMap<String, Entry>();
    }

    private Entry build(List<Entry> leafs) {
        if (leafs.size() == 1) {
            return leafs.get(0);
        }
        if (leafs.size() <= 13) {
            String[] children = new String[leafs.size()];
            for (int i = 0; i < leafs.size(); ++i) {
                String subDomain;
                children[i] = subDomain = Algorithm.encode32AndTruncate(leafs.get(i).toString());
                this.entries.put(subDomain, leafs.get(i));
            }
            return new BranchEntry(children);
        }
        ArrayList<Entry> subtrees = new ArrayList<Entry>();
        while (!leafs.isEmpty()) {
            int total = leafs.size();
            int n = Math.min(13, total);
            Entry branch = this.build(leafs.subList(0, n));
            leafs = leafs.subList(n, total);
            subtrees.add(branch);
            String subDomain = Algorithm.encode32AndTruncate(branch.toString());
            this.entries.put(subDomain, branch);
        }
        return this.build(subtrees);
    }

    public void makeTree(int seq, List<String> enrs, List<String> links, String privateKey) throws DnsException {
        ArrayList<Entry> nodesEntryList = new ArrayList<Entry>();
        for (String string : enrs) {
            nodesEntryList.add(NodesEntry.parseEntry(string));
        }
        ArrayList<Entry> linkEntryList = new ArrayList<Entry>();
        for (String link : links) {
            linkEntryList.add(LinkEntry.parseEntry(link));
        }
        this.init();
        Entry entry = this.build(nodesEntryList);
        String eRootStr = Algorithm.encode32AndTruncate(entry.toString());
        this.entries.put(eRootStr, entry);
        Entry lRoot = this.build(linkEntryList);
        String lRootStr = Algorithm.encode32AndTruncate(lRoot.toString());
        this.entries.put(lRootStr, lRoot);
        this.setRootEntry(new RootEntry(eRootStr, lRootStr, seq));
        if (StringUtils.isNotEmpty((CharSequence)privateKey)) {
            this.privateKey = privateKey;
            this.sign();
        }
    }

    public void sign() throws DnsException {
        boolean verified;
        if (StringUtils.isEmpty((CharSequence)this.privateKey)) {
            return;
        }
        byte[] sig = Algorithm.sigData(this.rootEntry.toString(), this.privateKey);
        this.rootEntry.setSignature(sig);
        BigInteger publicKeyInt = Algorithm.generateKeyPair(this.privateKey).getPublicKey();
        String unCompressPublicKey = ByteArray.toHexString(publicKeyInt.toByteArray());
        try {
            verified = Algorithm.verifySignature(unCompressPublicKey, this.rootEntry.toString(), this.rootEntry.getSignature());
        }
        catch (SignatureException e) {
            throw new DnsException(DnsException.TypeEnum.INVALID_SIGNATURE, (Throwable)e);
        }
        if (!verified) {
            throw new DnsException(DnsException.TypeEnum.INVALID_SIGNATURE, "");
        }
        String hexPub = Algorithm.compressPubKey(publicKeyInt);
        this.base32PublicKey = Algorithm.encode32(ByteArray.fromHexString(hexPub));
    }

    public static List<String> merge(List<DnsNode> nodes, int maxMergeSize) {
        Collections.sort(nodes);
        ArrayList<String> enrs = new ArrayList<String>();
        int networkA = -1;
        ArrayList<DnsNode> sub = new ArrayList<DnsNode>();
        for (DnsNode dnsNode : nodes) {
            if (networkA > -1 && dnsNode.getNetworkA() != networkA || sub.size() >= maxMergeSize) {
                enrs.add("nodes:" + DnsNode.compress(sub));
                sub.clear();
            }
            sub.add(dnsNode);
            networkA = dnsNode.getNetworkA();
        }
        if (!sub.isEmpty()) {
            enrs.add("nodes:" + DnsNode.compress(sub));
        }
        return enrs;
    }

    public Map<String, String> toTXT(String rootDomain) {
        HashMap<String, String> dnsRecords = new HashMap<String, String>();
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{rootDomain})) {
            dnsRecords.put(rootDomain, this.rootEntry.toFormat());
        } else {
            dnsRecords.put("@", this.rootEntry.toFormat());
        }
        for (Map.Entry<String, Entry> item : this.entries.entrySet()) {
            String hash = item.getKey();
            String newKey = StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{rootDomain}) ? hash + "." + rootDomain : hash;
            dnsRecords.put(newKey.toLowerCase(), item.getValue().toString());
        }
        return dnsRecords;
    }

    public int getSeq() {
        return this.rootEntry.getSeq();
    }

    public void setSeq(int seq) {
        this.rootEntry.setSeq(seq);
    }

    public List<String> getLinksEntry() {
        ArrayList<String> linkList = new ArrayList<String>();
        for (Entry entry : this.entries.values()) {
            if (!(entry instanceof LinkEntry)) continue;
            LinkEntry linkEntry = (LinkEntry)entry;
            linkList.add(linkEntry.toString());
        }
        return linkList;
    }

    public Map<String, Entry> getLinksMap() {
        HashMap<String, Entry> linksMap = new HashMap<String, Entry>();
        this.entries.entrySet().stream().filter(p -> p.getValue() instanceof LinkEntry).forEach(p -> {
            Entry cfr_ignored_0 = (Entry)linksMap.put((String)p.getKey(), (Entry)p.getValue());
        });
        return linksMap;
    }

    public List<String> getBranchesEntry() {
        ArrayList<String> branches = new ArrayList<String>();
        for (Entry entry : this.entries.values()) {
            if (!(entry instanceof BranchEntry)) continue;
            BranchEntry branchEntry = (BranchEntry)entry;
            branches.add(branchEntry.toString());
        }
        return branches;
    }

    public List<String> getNodesEntry() {
        ArrayList<String> nodesEntryList = new ArrayList<String>();
        for (Entry entry : this.entries.values()) {
            if (!(entry instanceof NodesEntry)) continue;
            NodesEntry nodesEntry = (NodesEntry)entry;
            nodesEntryList.add(nodesEntry.toString());
        }
        return nodesEntryList;
    }

    public Map<String, Entry> getNodesMap() {
        HashMap<String, Entry> nodesMap = new HashMap<String, Entry>();
        this.entries.entrySet().stream().filter(p -> p.getValue() instanceof NodesEntry).forEach(p -> {
            Entry cfr_ignored_0 = (Entry)nodesMap.put((String)p.getKey(), (Entry)p.getValue());
        });
        return nodesMap;
    }

    public void setEntries(Map<String, Entry> entries) {
        this.entries = entries;
    }

    public List<DnsNode> getDnsNodes() {
        List<String> nodesEntryList = this.getNodesEntry();
        ArrayList<DnsNode> nodes = new ArrayList<DnsNode>();
        for (String nodesEntry : nodesEntryList) {
            List<DnsNode> subNodes;
            String joinStr = nodesEntry.substring("nodes:".length());
            try {
                subNodes = DnsNode.decompress(joinStr);
            }
            catch (InvalidProtocolBufferException | UnknownHostException e) {
                log.error("", e);
                continue;
            }
            nodes.addAll(subNodes);
        }
        return nodes;
    }

    public RootEntry getRootEntry() {
        return this.rootEntry;
    }

    public void setRootEntry(RootEntry rootEntry) {
        this.rootEntry = rootEntry;
    }

    public Map<String, Entry> getEntries() {
        return this.entries;
    }

    public String getBase32PublicKey() {
        return this.base32PublicKey;
    }
}

