/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.dns.tree;

import com.google.protobuf.InvalidProtocolBufferException;
import java.net.UnknownHostException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.p2p.dns.DnsNode;
import org.tron.p2p.dns.tree.Entry;
import org.tron.p2p.exception.DnsException;

public class NodesEntry
implements Entry {
    private static final Logger log = LoggerFactory.getLogger((String)"net");
    private final String represent;
    private final List<DnsNode> nodes;

    public NodesEntry(String represent, List<DnsNode> nodes) {
        this.represent = represent;
        this.nodes = nodes;
    }

    public static NodesEntry parseEntry(String e) throws DnsException {
        List<DnsNode> nodeList;
        String content = e.substring("nodes:".length());
        try {
            nodeList = DnsNode.decompress(content.replace("\"", ""));
        }
        catch (InvalidProtocolBufferException | UnknownHostException ex) {
            throw new DnsException(DnsException.TypeEnum.INVALID_NODES, ex);
        }
        return new NodesEntry(e, nodeList);
    }

    public String toString() {
        return this.represent;
    }

    public List<DnsNode> getNodes() {
        return this.nodes;
    }
}

