/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.dns.sync;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkCache {
    private static final Logger log = LoggerFactory.getLogger((String)"net");
    Map<String, Set<String>> backrefs = new HashMap<String, Set<String>>();
    private boolean changed = false;

    public boolean isContainInOtherLink(String urlScheme) {
        return this.backrefs.containsKey(urlScheme) && !this.backrefs.get(urlScheme).isEmpty();
    }

    public void addLink(String parent, String children) {
        Set refs = this.backrefs.getOrDefault(children, new HashSet());
        if (!refs.contains(parent)) {
            this.changed = true;
        }
        refs.add(parent);
        this.backrefs.put(children, refs);
    }

    public void resetLinks(String from, Set<String> keep) {
        List<String> stk = new ArrayList<String>();
        stk.add(from);
        while (!stk.isEmpty()) {
            int size = stk.size();
            String item = (String)stk.get(size - 1);
            stk = stk.subList(0, size - 1);
            Iterator<Map.Entry<String, Set<String>>> it = this.backrefs.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Set<String>> entry = it.next();
                String r = entry.getKey();
                Set<String> refs = entry.getValue();
                if (keep != null && keep.contains(r) || !refs.contains(item)) continue;
                this.changed = true;
                refs.remove(item);
                if (!refs.isEmpty()) continue;
                it.remove();
                stk.add(r);
            }
        }
    }

    public Map<String, Set<String>> getBackrefs() {
        return this.backrefs;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }
}

