/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.dns.sync;

import java.net.UnknownHostException;
import java.security.SignatureException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.p2p.dns.DnsNode;
import org.tron.p2p.dns.sync.Client;
import org.tron.p2p.dns.sync.LinkCache;
import org.tron.p2p.dns.sync.SubtreeSync;
import org.tron.p2p.dns.tree.Entry;
import org.tron.p2p.dns.tree.LinkEntry;
import org.tron.p2p.dns.tree.NodesEntry;
import org.tron.p2p.dns.tree.RootEntry;
import org.tron.p2p.exception.DnsException;
import org.xbill.DNS.TextParseException;

public class ClientTree {
    private static final Logger log = LoggerFactory.getLogger((String)"net");
    private final Client client;
    private LinkEntry linkEntry;
    private final LinkCache linkCache;
    private long lastValidateTime;
    private int lastSeq = -1;
    private RootEntry root;
    private SubtreeSync enrSync;
    private SubtreeSync linkSync;
    private Set<String> curLinks;
    private String linkGCRoot;
    private final Random random;

    public ClientTree(Client c) {
        this.client = c;
        this.linkCache = new LinkCache();
        this.random = new Random();
    }

    public ClientTree(Client c, LinkCache lc, LinkEntry loc) {
        this.client = c;
        this.linkCache = lc;
        this.linkEntry = loc;
        this.curLinks = new HashSet<String>();
        this.random = new Random();
    }

    public boolean[] syncAll(Map<String, Entry> entries) throws DnsException, UnknownHostException, SignatureException, TextParseException {
        boolean[] isRootUpdate = this.updateRoot();
        this.linkSync.resolveAll(entries);
        this.enrSync.resolveAll(entries);
        return isRootUpdate;
    }

    public synchronized DnsNode syncRandom() throws DnsException, SignatureException, TextParseException, UnknownHostException {
        if (this.rootUpdateDue()) {
            this.updateRoot();
        }
        if (!this.linkSync.done()) {
            this.syncNextLink();
            return null;
        }
        this.gcLinks();
        if (this.enrSync.done()) {
            this.enrSync = new SubtreeSync(this.client, this.linkEntry, this.root.getERoot(), false);
        }
        return this.syncNextRandomNode();
    }

    public boolean canSyncRandom() {
        return this.rootUpdateDue() || !this.linkSync.done() || !this.enrSync.done() || this.enrSync.leaves == 0;
    }

    public void gcLinks() {
        if (!this.linkSync.done() || this.root.getLRoot().equals(this.linkGCRoot)) {
            return;
        }
        this.linkCache.resetLinks(this.linkEntry.getRepresent(), this.curLinks);
        this.linkGCRoot = this.root.getLRoot();
    }

    public void syncNextLink() throws DnsException, TextParseException, UnknownHostException {
        String hash = this.linkSync.missing.peek();
        Entry entry = this.linkSync.resolveNext(hash);
        this.linkSync.missing.poll();
        if (entry instanceof LinkEntry) {
            LinkEntry dest = (LinkEntry)entry;
            this.linkCache.addLink(this.linkEntry.getRepresent(), dest.getRepresent());
            this.curLinks.add(dest.getRepresent());
        }
    }

    private DnsNode syncNextRandomNode() throws DnsException, TextParseException, UnknownHostException {
        int pos = this.random.nextInt(this.enrSync.missing.size());
        String hash = this.enrSync.missing.get(pos);
        Entry entry = this.enrSync.resolveNext(hash);
        this.enrSync.missing.remove(pos);
        if (entry instanceof NodesEntry) {
            NodesEntry nodesEntry = (NodesEntry)entry;
            List<DnsNode> nodeList = nodesEntry.getNodes();
            int size = nodeList.size();
            return nodeList.get(this.random.nextInt(size));
        }
        log.info("Get branch or link entry in syncNextRandomNode");
        return null;
    }

    private boolean[] updateRoot() throws TextParseException, DnsException, SignatureException, UnknownHostException {
        log.info("UpdateRoot {}", (Object)this.linkEntry.getDomain());
        this.lastValidateTime = System.currentTimeMillis();
        RootEntry rootEntry = this.client.resolveRoot(this.linkEntry);
        if (rootEntry == null) {
            return new boolean[]{false, false};
        }
        if (rootEntry.getSeq() <= this.lastSeq) {
            log.info("The seq of url doesn't change, url:[{}], seq:{}", (Object)this.linkEntry.getRepresent(), (Object)this.lastSeq);
            return new boolean[]{false, false};
        }
        this.root = rootEntry;
        this.lastSeq = rootEntry.getSeq();
        boolean updateLRoot = false;
        boolean updateERoot = false;
        if (this.linkSync == null || !rootEntry.getLRoot().equals(this.linkSync.root)) {
            this.linkSync = new SubtreeSync(this.client, this.linkEntry, rootEntry.getLRoot(), true);
            this.curLinks = new HashSet<String>();
            updateLRoot = true;
        } else {
            log.info("The lroot of url doesn't change, url:[{}], lroot:[{}]", (Object)this.linkEntry.getRepresent(), (Object)this.linkSync.root);
        }
        if (this.enrSync == null || !rootEntry.getERoot().equals(this.enrSync.root)) {
            this.enrSync = new SubtreeSync(this.client, this.linkEntry, rootEntry.getERoot(), false);
            updateERoot = true;
        } else {
            log.info("The eroot of url doesn't change, url:[{}], eroot:[{}]", (Object)this.linkEntry.getRepresent(), (Object)this.enrSync.root);
        }
        return new boolean[]{updateLRoot, updateERoot};
    }

    private boolean rootUpdateDue() {
        boolean scheduledCheck;
        boolean bl = scheduledCheck = System.currentTimeMillis() > this.nextScheduledRootCheck();
        if (scheduledCheck) {
            log.info("Update root because of scheduledCheck, {}", (Object)this.linkEntry.getDomain());
        }
        return this.root == null || scheduledCheck;
    }

    public long nextScheduledRootCheck() {
        return this.lastValidateTime + 3600000L;
    }

    public String toString() {
        return this.linkEntry.toString();
    }

    public LinkEntry getLinkEntry() {
        return this.linkEntry;
    }

    public void setLinkEntry(LinkEntry linkEntry) {
        this.linkEntry = linkEntry;
    }

    public RootEntry getRoot() {
        return this.root;
    }

    public void setRoot(RootEntry root) {
        this.root = root;
    }
}

