/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.dns.lookup;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.p2p.base.Parameter;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TXTRecord;
import org.xbill.DNS.TextParseException;

public class LookUpTxt {
    private static final Logger log = LoggerFactory.getLogger((String)"net");
    static String[] publicDnsV4 = new String[]{"114.114.114.114", "114.114.115.115", "223.5.5.5", "223.6.6.6", "119.29.29.29", "117.50.11.11", "117.50.22.22", "101.226.4.6", "218.30.118.6", "123.125.81.6", "140.207.198.6", "8.8.8.8", "8.8.4.4", "9.9.9.9"};
    static String[] publicDnsV6 = new String[]{"2606:4700:4700::1111", "2606:4700:4700::1001", "2400:3200::1", "2400:3200:baba::1", "2a00:5a60::ad1:0ff", "2a00:5a60::ad2:0ff", "2620:74:1b::1:1", "2620:74:1c::2:2", "2a02:6b8::feed:0ff", "2a02:6b8:0:1::feed:0ff", "2001:4860:4860::8888", "2001:4860:4860::8844", "2620:fe::fe", "2620:fe::9", "2a00:5a60::ad1:0ff", "2a00:5a60::ad2:0ff"};
    static int maxRetryTimes = 5;
    static Random random = new Random();

    public static TXTRecord lookUpTxt(String hash, String domain) throws TextParseException, UnknownHostException {
        return LookUpTxt.lookUpTxt(hash + "." + domain);
    }

    public static TXTRecord lookUpTxt(String name) throws TextParseException, UnknownHostException {
        TXTRecord txt = null;
        log.info("LookUp name: {}", (Object)name);
        Lookup lookup = new Lookup(name, 16);
        Record[] records = null;
        long start = System.currentTimeMillis();
        for (int times = 0; times < maxRetryTimes; ++times) {
            String publicDns = StringUtils.isNotEmpty((CharSequence)Parameter.p2pConfig.getIp()) ? publicDnsV4[random.nextInt(publicDnsV4.length)] : publicDnsV6[random.nextInt(publicDnsV6.length)];
            SimpleResolver simpleResolver = new SimpleResolver(InetAddress.getByName(publicDns));
            simpleResolver.setTimeout(Duration.ofMillis(1000L));
            lookup.setResolver((Resolver)simpleResolver);
            long thisTime = System.currentTimeMillis();
            records = lookup.run();
            long end = System.currentTimeMillis();
            if (records != null) {
                log.debug("Succeed to use dns: {}, cur cost: {}ms, total cost: {}ms", new Object[]{publicDns, end - thisTime, end - start});
                break;
            }
            log.debug("Failed to use dns: {}, cur cost: {}ms", (Object)publicDns, (Object)(end - thisTime));
        }
        if (records == null) {
            log.error("Failed to lookUp name:{}", (Object)name);
            return null;
        }
        for (void var10_12 : records) {
            txt = (TXTRecord)var10_12;
        }
        return txt;
    }

    public static String joinTXTRecord(TXTRecord txtRecord) {
        StringBuilder sb = new StringBuilder();
        for (String s : txtRecord.getStrings()) {
            sb.append(s.trim());
        }
        return sb.toString();
    }
}

