/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.connection.socket;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultMessageSizeEstimator;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LoggingHandler;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.p2p.base.Parameter;
import org.tron.p2p.connection.socket.P2pChannelInitializer;

public class PeerServer {
    private static final Logger log = LoggerFactory.getLogger((String)"net");
    private ChannelFuture channelFuture;
    private boolean listening;

    public void init() {
        int port = Parameter.p2pConfig.getPort();
        if (port > 0) {
            new Thread(() -> this.start(port), "PeerServer").start();
        }
    }

    public void close() {
        if (this.listening && this.channelFuture != null && this.channelFuture.channel().isOpen()) {
            try {
                log.info("Closing TCP server...");
                this.channelFuture.channel().close().sync();
            }
            catch (Exception e) {
                log.warn("Closing TCP server failed.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(int port) {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("peerBoss").build());
        NioEventLoopGroup workerGroup = new NioEventLoopGroup(0, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("peerWorker-%d").build());
        P2pChannelInitializer p2pChannelInitializer = new P2pChannelInitializer("", false, true);
        try {
            ServerBootstrap b = new ServerBootstrap();
            b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup);
            b.channel(NioServerSocketChannel.class);
            b.option(ChannelOption.MESSAGE_SIZE_ESTIMATOR, (Object)DefaultMessageSizeEstimator.DEFAULT);
            b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)2000);
            b.handler((ChannelHandler)new LoggingHandler());
            b.childHandler((ChannelHandler)p2pChannelInitializer);
            log.info("TCP listener started, bind port {}", (Object)port);
            this.channelFuture = b.bind(port).sync();
            this.listening = true;
            this.channelFuture.channel().closeFuture().sync();
            log.info("TCP listener closed");
        }
        catch (Exception e) {
            log.error("Start TCP server failed", (Throwable)e);
        }
        finally {
            workerGroup.shutdownGracefully();
            bossGroup.shutdownGracefully();
            this.listening = false;
        }
    }
}

