/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.connection.business.pool;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.p2p.P2pConfig;
import org.tron.p2p.P2pEventHandler;
import org.tron.p2p.base.Parameter;
import org.tron.p2p.connection.Channel;
import org.tron.p2p.connection.ChannelManager;
import org.tron.p2p.connection.message.base.P2pDisconnectMessage;
import org.tron.p2p.connection.socket.PeerClient;
import org.tron.p2p.discover.Node;
import org.tron.p2p.discover.NodeManager;
import org.tron.p2p.dns.DnsManager;
import org.tron.p2p.dns.DnsNode;
import org.tron.p2p.exception.P2pException;
import org.tron.p2p.protos.Connect;
import org.tron.p2p.utils.CollectionUtils;
import org.tron.p2p.utils.NetUtil;

public class ConnPoolService
extends P2pEventHandler {
    private static final Logger log = LoggerFactory.getLogger((String)"net");
    private final List<Channel> activePeers = Collections.synchronizedList(new ArrayList());
    private Cache<InetAddress, Long> peerClientCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(120L, TimeUnit.SECONDS).recordStats().build();
    private final AtomicInteger passivePeersCount = new AtomicInteger(0);
    private final AtomicInteger activePeersCount = new AtomicInteger(0);
    private final AtomicInteger connectingPeersCount = new AtomicInteger(0);
    private final ScheduledExecutorService poolLoopExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new BasicThreadFactory.Builder().namingPattern("connPool").build());
    private final ScheduledExecutorService disconnectExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new BasicThreadFactory.Builder().namingPattern("randomDisconnect").build());
    public P2pConfig p2pConfig = Parameter.p2pConfig;
    private PeerClient peerClient;
    private List<InetSocketAddress> configActiveNodes = new ArrayList<InetSocketAddress>();

    public ConnPoolService() {
        this.messageTypes = new HashSet();
        try {
            Parameter.addP2pEventHandle(this);
            this.configActiveNodes.addAll(this.p2pConfig.getActiveNodes());
        }
        catch (P2pException p2pException) {
            // empty catch block
        }
    }

    public void init(PeerClient peerClient) {
        this.peerClient = peerClient;
        this.poolLoopExecutor.scheduleWithFixedDelay(() -> {
            try {
                this.connect(false);
            }
            catch (Exception t) {
                log.error("Exception in poolLoopExecutor worker", (Throwable)t);
            }
        }, 200L, 3600L, TimeUnit.MILLISECONDS);
        if (this.p2pConfig.isDisconnectionPolicyEnable()) {
            this.disconnectExecutor.scheduleWithFixedDelay(() -> {
                try {
                    this.check();
                }
                catch (Exception t) {
                    log.error("Exception in disconnectExecutor worker", (Throwable)t);
                }
            }, 30L, 30L, TimeUnit.SECONDS);
        }
    }

    private void addNode(Set<InetSocketAddress> inetSet, Node node) {
        if (node != null) {
            if (node.getInetSocketAddressV4() != null) {
                inetSet.add(node.getInetSocketAddressV4());
            }
            if (node.getInetSocketAddressV6() != null) {
                inetSet.add(node.getInetSocketAddressV6());
            }
        }
    }

    private void connect(boolean isFilterActiveNodes) {
        List<Node> connectableNodes;
        int lackSize;
        ArrayList<Node> connectNodes = new ArrayList<Node>();
        HashSet addressInUse = new HashSet();
        HashSet<InetSocketAddress> inetInUse = new HashSet<InetSocketAddress>();
        HashSet<String> nodesInUse = new HashSet<String>();
        nodesInUse.add(Hex.toHexString((byte[])this.p2pConfig.getNodeID()));
        ChannelManager.getChannels().values().forEach(channel -> {
            if (StringUtils.isNotEmpty((CharSequence)channel.getNodeId())) {
                nodesInUse.add(channel.getNodeId());
            }
            addressInUse.add(channel.getInetAddress());
            inetInUse.add(channel.getInetSocketAddress());
            this.addNode(inetInUse, channel.getNode());
        });
        this.addNode(inetInUse, new Node(Parameter.p2pConfig.getNodeID(), Parameter.p2pConfig.getIp(), Parameter.p2pConfig.getIpv6(), Parameter.p2pConfig.getPort()));
        this.p2pConfig.getActiveNodes().forEach(address -> {
            if (!(isFilterActiveNodes || inetInUse.contains(address) || addressInUse.contains(address.getAddress()))) {
                addressInUse.add(address.getAddress());
                inetInUse.add((InetSocketAddress)address);
                Node node = new Node((InetSocketAddress)address);
                if (node.getPreferInetSocketAddress() != null) {
                    connectNodes.add(node);
                }
            }
        });
        int activeLackSize = this.p2pConfig.getMinActiveConnections() - this.connectingPeersCount.get();
        int size = Math.max(this.p2pConfig.getMinConnections() - this.connectingPeersCount.get() - this.passivePeersCount.get(), activeLackSize);
        if (this.p2pConfig.getMinConnections() <= this.activePeers.size() && activeLackSize <= 0) {
            size = 0;
        }
        if ((lackSize = size) > 0) {
            connectableNodes = ChannelManager.getNodeDetectService().getConnectableNodes();
            for (Node node : connectableNodes) {
                if (!this.validNode(node, nodesInUse, inetInUse, null)) continue;
                connectNodes.add(node);
                nodesInUse.add(node.getHexId());
                inetInUse.add(node.getPreferInetSocketAddress());
                if (--lackSize > 0) continue;
                break;
            }
        }
        if (lackSize > 0) {
            connectableNodes = NodeManager.getConnectableNodes();
            List<Node> newNodes = this.getNodes(nodesInUse, inetInUse, connectableNodes, lackSize);
            connectNodes.addAll(newNodes);
            for (Node node : newNodes) {
                nodesInUse.add(node.getHexId());
                inetInUse.add(node.getPreferInetSocketAddress());
            }
            lackSize -= newNodes.size();
        }
        if (lackSize > 0 && !this.p2pConfig.getTreeUrls().isEmpty()) {
            List<DnsNode> dnsNodes = DnsManager.getDnsNodes();
            ArrayList<DnsNode> filtered = new ArrayList<DnsNode>();
            Collections.shuffle(dnsNodes);
            for (DnsNode dnsNode : dnsNodes) {
                if (!this.validNode(dnsNode, nodesInUse, inetInUse, null)) continue;
                DnsNode copyNode = (DnsNode)dnsNode.clone();
                copyNode.setId(NetUtil.getNodeId());
                this.addNode(inetInUse, dnsNode);
                filtered.add(copyNode);
            }
            List list = CollectionUtils.truncate(filtered, lackSize);
            connectNodes.addAll(list);
        }
        log.debug("Lack size:{}, connectNodes size:{}, is disconnect trigger: {}", new Object[]{size, connectNodes.size(), isFilterActiveNodes});
        connectNodes.forEach(n -> {
            log.info("Connect to peer {}", (Object)n.getPreferInetSocketAddress());
            this.peerClient.connectAsync((Node)n, false);
            this.peerClientCache.put((Object)n.getPreferInetSocketAddress().getAddress(), (Object)System.currentTimeMillis());
            if (!this.configActiveNodes.contains(n.getPreferInetSocketAddress())) {
                this.connectingPeersCount.incrementAndGet();
            }
        });
    }

    public List<Node> getNodes(Set<String> nodesInUse, Set<InetSocketAddress> inetInUse, List<Node> connectableNodes, int limit) {
        ArrayList<Node> filtered = new ArrayList<Node>();
        HashSet<InetSocketAddress> dynamicInetInUse = new HashSet<InetSocketAddress>(inetInUse);
        for (Node node2 : connectableNodes) {
            if (!this.validNode(node2, nodesInUse, inetInUse, dynamicInetInUse)) continue;
            filtered.add((Node)node2.clone());
            this.addNode(dynamicInetInUse, node2);
        }
        filtered.sort(Comparator.comparingLong(node -> -node.getUpdateTime()));
        return CollectionUtils.truncate(filtered, limit);
    }

    private boolean validNode(Node node, Set<String> nodesInUse, Set<InetSocketAddress> inetInUse, Set<InetSocketAddress> dynamicInet) {
        long now = System.currentTimeMillis();
        InetSocketAddress inetSocketAddress = node.getPreferInetSocketAddress();
        InetAddress inetAddress = inetSocketAddress.getAddress();
        Long forbiddenTime = (Long)ChannelManager.getBannedNodes().getIfPresent((Object)inetAddress);
        return !(forbiddenTime != null && now <= forbiddenTime || ChannelManager.getConnectionNum(inetAddress) >= this.p2pConfig.getMaxConnectionsWithSameIp() || node.getId() != null && nodesInUse.contains(node.getHexId()) || this.peerClientCache.getIfPresent((Object)inetAddress) != null || inetInUse.contains(inetSocketAddress)) && (dynamicInet == null || !dynamicInet.contains(inetSocketAddress));
    }

    private void check() {
        if (ChannelManager.getChannels().size() < this.p2pConfig.getMaxConnections()) {
            return;
        }
        ArrayList<Channel> channels = new ArrayList<Channel>(this.activePeers);
        Collection peers = channels.stream().filter(peer -> !peer.isDisconnect()).filter(peer -> !peer.isTrustPeer()).filter(peer -> !peer.isActive()).collect(Collectors.toList());
        if (!peers.isEmpty()) {
            ArrayList list = new ArrayList(peers);
            Channel peer2 = (Channel)list.get(new Random().nextInt(peers.size()));
            log.info("Disconnect with peer randomly: {}", (Object)peer2);
            peer2.send(new P2pDisconnectMessage(Connect.DisconnectReason.RANDOM_ELIMINATION));
            peer2.close();
        }
    }

    private synchronized void logActivePeers() {
        log.info("Peer stats: channels {}, activePeers {}, active {}, passive {}", new Object[]{ChannelManager.getChannels().size(), this.activePeers.size(), this.activePeersCount.get(), this.passivePeersCount.get()});
    }

    public void triggerConnect(InetSocketAddress address) {
        if (this.configActiveNodes.contains(address)) {
            return;
        }
        this.connectingPeersCount.decrementAndGet();
        try {
            if (!ChannelManager.isShutdown) {
                this.poolLoopExecutor.submit(() -> {
                    try {
                        this.connect(true);
                    }
                    catch (Exception t) {
                        log.error("Exception in poolLoopExecutor worker", (Throwable)t);
                    }
                });
            }
        }
        catch (Exception e) {
            log.warn("Submit task failed, message:{}", (Object)e.getMessage());
        }
    }

    @Override
    public synchronized void onConnect(Channel peer) {
        if (!this.activePeers.contains(peer)) {
            if (!peer.isActive()) {
                this.passivePeersCount.incrementAndGet();
            } else {
                this.activePeersCount.incrementAndGet();
            }
            this.activePeers.add(peer);
        }
        this.logActivePeers();
    }

    @Override
    public synchronized void onDisconnect(Channel peer) {
        if (this.activePeers.contains(peer)) {
            if (!peer.isActive()) {
                this.passivePeersCount.decrementAndGet();
            } else {
                this.activePeersCount.decrementAndGet();
            }
            this.activePeers.remove(peer);
        }
        this.logActivePeers();
    }

    @Override
    public void onMessage(Channel channel, byte[] data) {
    }

    public void close() {
        ArrayList<Channel> channels = new ArrayList<Channel>(this.activePeers);
        try {
            channels.forEach(p -> {
                if (!p.isDisconnect()) {
                    p.send(new P2pDisconnectMessage(Connect.DisconnectReason.PEER_QUITING));
                    p.close();
                }
            });
            this.poolLoopExecutor.shutdownNow();
        }
        catch (Exception e) {
            log.warn("Problems shutting down executor", (Throwable)e);
        }
    }

    public AtomicInteger getPassivePeersCount() {
        return this.passivePeersCount;
    }

    public AtomicInteger getActivePeersCount() {
        return this.activePeersCount;
    }

    public AtomicInteger getConnectingPeersCount() {
        return this.connectingPeersCount;
    }
}

