/*
 * Decompiled with CFR 0.152.
 */
package org.tron.p2p.connection.business.keepalive;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.p2p.connection.Channel;
import org.tron.p2p.connection.ChannelManager;
import org.tron.p2p.connection.business.MessageProcess;
import org.tron.p2p.connection.message.Message;
import org.tron.p2p.connection.message.base.P2pDisconnectMessage;
import org.tron.p2p.connection.message.keepalive.PingMessage;
import org.tron.p2p.connection.message.keepalive.PongMessage;
import org.tron.p2p.protos.Connect;

public class KeepAliveService
implements MessageProcess {
    private static final Logger log = LoggerFactory.getLogger((String)"net");
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new BasicThreadFactory.Builder().namingPattern("keepAlive").build());

    public void init() {
        this.executor.scheduleWithFixedDelay(() -> {
            try {
                long now = System.currentTimeMillis();
                ChannelManager.getChannels().values().stream().filter(p -> !p.isDisconnect()).forEach(p -> {
                    if (p.waitForPong) {
                        if (now - p.pingSent > 20000L) {
                            p.send(new P2pDisconnectMessage(Connect.DisconnectReason.PING_TIMEOUT));
                            p.close();
                        }
                    } else if (now - p.getLastSendTime() > 20000L && p.isFinishHandshake()) {
                        p.send(new PingMessage());
                        p.waitForPong = true;
                        p.pingSent = now;
                    }
                });
            }
            catch (Exception t) {
                log.error("Exception in keep alive task", (Throwable)t);
            }
        }, 2L, 2L, TimeUnit.SECONDS);
    }

    public void close() {
        this.executor.shutdown();
    }

    @Override
    public void processMessage(Channel channel, Message message) {
        switch (message.getType()) {
            case KEEP_ALIVE_PING: {
                channel.send(new PongMessage());
                break;
            }
            case KEEP_ALIVE_PONG: {
                channel.updateAvgLatency(System.currentTimeMillis() - channel.pingSent);
                channel.waitForPong = false;
                break;
            }
        }
    }
}

