/*
 * Decompiled with CFR 0.152.
 */
package org.tron.plugins;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.tongfei.progressbar.ProgressBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.plugins.utils.FileUtils;
import picocli.CommandLine;

@CommandLine.Command(name="cp", aliases={"copy"}, description={"Quick copy leveldb or rocksdb data."}, exitCodeListHeading="Exit Codes:%n", exitCodeList={"0:Successful", "n:Internal error: exception occurred,please check toolkit.log"})
public class DbCopy
implements Callable<Integer> {
    private static final Logger logger = LoggerFactory.getLogger((String)"copy");
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    @CommandLine.Parameters(index="0", defaultValue="output-directory/database", description={"Input path. Default: ${DEFAULT-VALUE}"})
    private File src;
    @CommandLine.Parameters(index="1", defaultValue="output-directory-cp/database", description={"Output path. Default: ${DEFAULT-VALUE}"})
    private File dest;
    @CommandLine.Option(names={"-h", "--help"})
    private boolean help;

    @Override
    public Integer call() throws Exception {
        if (this.help) {
            this.spec.commandLine().usage(System.out);
            return 0;
        }
        if (this.dest.exists()) {
            logger.info(" {} exist, please delete it first.", (Object)this.dest);
            this.spec.commandLine().getErr().println(this.spec.commandLine().getColorScheme().errorText(String.format("%s exist, please delete it first.", this.dest)));
            return 402;
        }
        if (!this.src.exists()) {
            logger.info(" {} does not exist.", (Object)this.src);
            this.spec.commandLine().getErr().println(this.spec.commandLine().getColorScheme().errorText(String.format("%s does not exist.", this.src)));
            return 404;
        }
        if (!this.src.isDirectory()) {
            logger.info(" {} is not a directory.", (Object)this.src);
            this.spec.commandLine().getErr().println(this.spec.commandLine().getColorScheme().errorText(String.format("%s is not a directory.", this.src)));
            return 403;
        }
        List<File> files = Arrays.stream((Object[])Objects.requireNonNull(this.src.listFiles())).filter(File::isDirectory).filter(e -> !"checkpoint".equals(e.getName())).collect(Collectors.toList());
        File cpV2Dir = new File(Paths.get(this.src.toString(), "checkpoint").toString());
        List<Object> cpList = new ArrayList();
        if (cpV2Dir.exists()) {
            cpList = Arrays.stream((Object[])Objects.requireNonNull(cpV2Dir.listFiles())).filter(File::isDirectory).collect(Collectors.toList());
        }
        if (files.isEmpty()) {
            logger.info("{} does not contain any database.", (Object)this.src);
            this.spec.commandLine().getOut().format("%s does not contain any database.", this.src).println();
            return 0;
        }
        long time = System.currentTimeMillis();
        ArrayList services = new ArrayList();
        files.forEach(f -> services.add(new DbCopier(this.src.getPath(), this.dest.getPath(), f.getName())));
        cpList.forEach(f -> services.add(new DbCopier(Paths.get(this.src.getPath(), "checkpoint").toString(), Paths.get(this.dest.getPath(), "checkpoint").toString(), f.getName())));
        List fails = ((Stream)ProgressBar.wrap(services.stream(), (String)"copy task").parallel()).map(dbCopier -> {
            try {
                return dbCopier.doCopy() ? null : dbCopier.name();
            }
            catch (Exception e) {
                logger.error("{}", (Throwable)e);
                this.spec.commandLine().getErr().println(this.spec.commandLine().getColorScheme().errorText(e.getMessage()));
                return dbCopier.name();
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        Arrays.stream((Object[])Objects.requireNonNull(this.src.listFiles())).filter(File::isFile).forEach(f -> FileUtils.copy(Paths.get(this.src.toString(), f.getName()), Paths.get(this.dest.toString(), f.getName())));
        long during = (System.currentTimeMillis() - time) / 1000L;
        this.spec.commandLine().getOut().format("copy db done, fails: %s, take %d s.", fails, during).println();
        logger.info("database copy use {} seconds total, fails: {}.", (Object)during, fails);
        return fails.size();
    }

    static class DbCopier
    implements Copier {
        private final String srcDir;
        private final String dstDir;
        private final String dbName;
        private final Path srcDbPath;
        private final Path dstDbPath;

        public DbCopier(String srcDir, String dstDir, String name) {
            this.srcDir = srcDir;
            this.dstDir = dstDir;
            this.dbName = name;
            this.srcDbPath = Paths.get(this.srcDir, name);
            this.dstDbPath = Paths.get(this.dstDir, name);
        }

        @Override
        public boolean doCopy() {
            File srcDb = this.srcDbPath.toFile();
            if (!srcDb.exists()) {
                logger.info(" {} does not exist.", (Object)srcDb);
                return true;
            }
            FileUtils.createDirIfNotExists(this.dstDir);
            logger.info("Copy database {} start", (Object)this.dbName);
            FileUtils.copyDir(Paths.get(this.srcDir, new String[0]), Paths.get(this.dstDir, new String[0]), this.dbName);
            logger.info("Copy database {} end", (Object)this.dbName);
            return true;
        }

        @Override
        public String name() {
            return this.dbName;
        }
    }

    static interface Copier {
        public boolean doCopy();

        public String name();
    }
}

