/*
 * Decompiled with CFR 0.152.
 */
package org.tron.plugins;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.tongfei.progressbar.ProgressBar;
import org.iq80.leveldb.CompressionType;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.impl.Filename;
import org.iq80.leveldb.impl.Iq80DBFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.plugins.utils.FileUtils;
import picocli.CommandLine;

@CommandLine.Command(name="archive", description={"A helper to rewrite leveldb manifest."})
public class DbArchive
implements Callable<Integer> {
    private static final Logger logger = LoggerFactory.getLogger((String)"archive");
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"-d", "--database-directory"}, defaultValue="output-directory/database", description={"java-tron database directory. Default: ${DEFAULT-VALUE}"})
    private String databaseDirectory;
    @CommandLine.Option(names={"-b", "--batch-size"}, defaultValue="80000", description={"deal manifest batch size. Default: ${DEFAULT-VALUE}"})
    private int maxBatchSize;
    @CommandLine.Option(names={"-m", "--manifest-size"}, defaultValue="0", description={"manifest min size(M) to archive. Default: ${DEFAULT-VALUE}"})
    private int maxManifestSize;
    @CommandLine.Option(names={"-h", "--help"})
    private boolean help;

    @Override
    public Integer call() throws Exception {
        if (this.help) {
            this.spec.commandLine().usage(System.out);
            return 0;
        }
        File dbDirectory = new File(this.databaseDirectory);
        if (!dbDirectory.exists()) {
            this.spec.commandLine().getErr().format("Directory %s does not exist.", this.databaseDirectory).println();
            logger.info("Directory {} does not exist.", (Object)this.databaseDirectory);
            return 404;
        }
        if (!dbDirectory.isDirectory()) {
            this.spec.commandLine().getErr().format(" %s is not directory.", this.databaseDirectory).println();
            logger.info("{} is not directory.", (Object)this.databaseDirectory);
            return 405;
        }
        List<File> files = Arrays.stream((Object[])Objects.requireNonNull(dbDirectory.listFiles())).filter(File::isDirectory).collect(Collectors.toList());
        if (files.isEmpty()) {
            this.spec.commandLine().getErr().format("Directory %s does not contain any database.", this.databaseDirectory).println();
            logger.info("Directory {} does not contain any database.", (Object)this.databaseDirectory);
            return 0;
        }
        long time = System.currentTimeMillis();
        ArrayList services = new ArrayList();
        files.forEach(f -> services.add(new ArchiveManifest(this.databaseDirectory, f.getName(), this.maxManifestSize, this.maxBatchSize)));
        ((Stream)ProgressBar.wrap(services.stream(), (String)"archive task").parallel()).forEach(Archive::doArchive);
        this.spec.commandLine().getOut().println("archive db done.");
        logger.info("DatabaseDirectory:{}, maxManifestSize:{}, maxBatchSize:{},database reopen use {} seconds total.", new Object[]{this.databaseDirectory, this.maxManifestSize, this.maxBatchSize, (System.currentTimeMillis() - time) / 1000L});
        return 0;
    }

    static class ArchiveManifest
    implements Archive {
        private static final String KEY_ENGINE = "ENGINE";
        private static final String LEVELDB = "LEVELDB";
        private final Path srcDbPath;
        private final String name;
        private final Options options;
        private final long startTime;

        public ArchiveManifest(String src, String name, int maxManifestSize, int maxBatchSize) {
            this.name = name;
            this.srcDbPath = Paths.get(src, name);
            this.startTime = System.currentTimeMillis();
            this.options = ArchiveManifest.newDefaultLevelDbOptions();
            this.options.maxManifestSize(maxManifestSize);
            this.options.maxBatchSize(maxBatchSize);
        }

        public static Options newDefaultLevelDbOptions() {
            Options dbOptions = new Options();
            dbOptions.createIfMissing(true);
            dbOptions.paranoidChecks(true);
            dbOptions.verifyChecksums(true);
            dbOptions.compressionType(CompressionType.SNAPPY);
            dbOptions.blockSize(4096);
            dbOptions.writeBufferSize(0xA00000);
            dbOptions.cacheSize(0xA00000L);
            dbOptions.maxOpenFiles(1000);
            dbOptions.maxBatchSize(64000);
            dbOptions.maxManifestSize(128);
            return dbOptions;
        }

        public void open() throws IOException {
            DB database = Iq80DBFactory.factory.open(this.srcDbPath.toFile(), this.options);
            database.close();
        }

        public boolean checkManifest(String dir) throws IOException {
            File currentFile = new File(dir, Filename.currentFileName());
            if (!currentFile.exists()) {
                return false;
            }
            String currentName = Files.asCharSource((File)currentFile, (Charset)StandardCharsets.UTF_8).read();
            if (currentName.isEmpty() || currentName.charAt(currentName.length() - 1) != '\n') {
                return false;
            }
            File current = new File(dir, currentName = currentName.substring(0, currentName.length() - 1));
            if (!current.isFile()) {
                return false;
            }
            long maxSize = this.options.maxManifestSize();
            if (maxSize < 0L) {
                return false;
            }
            logger.info("CurrentName {}/{},size {} kb.", new Object[]{dir, currentName, current.length() / 1024L});
            if ("market_pair_price_to_order".equalsIgnoreCase(this.name)) {
                logger.info("Db {} ignored.", (Object)this.name);
                return false;
            }
            return current.length() >= maxSize * 1024L * 1024L;
        }

        @Override
        public void doArchive() {
            File levelDbFile = this.srcDbPath.toFile();
            if (!levelDbFile.exists()) {
                logger.info("File {},does not exist, ignored.", (Object)this.srcDbPath);
                return;
            }
            try {
                if (this.checkManifest(levelDbFile.toString())) {
                    if (!FileUtils.isLevelDBEngine(this.srcDbPath)) {
                        logger.info("Db {},not leveldb, ignored.", (Object)this.name);
                        return;
                    }
                    this.open();
                    logger.info("Db {} archive use {} ms.", (Object)this.name, (Object)(System.currentTimeMillis() - this.startTime));
                } else {
                    logger.info("Db {},no need, ignored.", (Object)levelDbFile);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Db " + this.name + " archive failed.", e);
            }
        }
    }

    static interface Archive {
        default public void doArchive() {
        }
    }
}

