/*
 * Decompiled with CFR 0.152.
 */
package org.tron.tool.litefullnode;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Map;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.CompressionType;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.Options;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.Filter;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.TableFormatConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.PropUtil;
import org.tron.tool.litefullnode.db.DBInterface;
import org.tron.tool.litefullnode.db.LevelDBImpl;
import org.tron.tool.litefullnode.db.RocksDBImpl;

public class DbTool {
    private static final Logger logger = LoggerFactory.getLogger((String)"tool");
    private static final String KEY_ENGINE = "ENGINE";
    public static final String ENGINE_FILE = "engine.properties";
    private static final String FILE_SEPARATOR = File.separator;
    private static final String ROCKSDB = "ROCKSDB";
    private static Map<String, DBInterface> dbMap = Maps.newHashMap();

    public static DBInterface getDB(String sourceDir, String dbName) throws IOException, RocksDBException {
        DBInterface db;
        Path path = Paths.get(sourceDir, dbName);
        if (dbMap.containsKey(path.toString())) {
            return dbMap.get(path.toString());
        }
        DbType type = DbTool.getDbType(sourceDir, dbName);
        switch (type) {
            case LevelDB: {
                db = DbTool.openLevelDb(path);
                dbMap.put(path.toString(), db);
                break;
            }
            case RocksDB: {
                db = DbTool.openRocksDb(path);
                dbMap.put(path.toString(), db);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)type));
            }
        }
        return db;
    }

    public static void closeDB(String sourceDir, String dbName) throws IOException {
        Path path = Paths.get(sourceDir, dbName);
        DBInterface db = dbMap.get(path.toString());
        if (db != null) {
            try {
                dbMap.remove(path.toString());
                db.close();
            }
            catch (IOException e) {
                logger.error("close db {} error: {}", (Object)path, (Object)e);
                throw e;
            }
        }
    }

    public static void close() {
        Iterator<Map.Entry<String, DBInterface>> iterator = dbMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, DBInterface> next = iterator.next();
            try {
                next.getValue().close();
            }
            catch (IOException e) {
                logger.error("close db failed, db: {}", (Object)next.getKey(), (Object)e);
            }
            iterator.remove();
        }
    }

    private static DbType getDbType(String sourceDir, String dbName) {
        String engineFile = String.format("%s%s%s%s%s", sourceDir, FILE_SEPARATOR, dbName, FILE_SEPARATOR, ENGINE_FILE);
        if (!new File(engineFile).exists()) {
            return DbType.LevelDB;
        }
        String engine = PropUtil.readProperty((String)engineFile, (String)KEY_ENGINE);
        if (engine.equalsIgnoreCase(ROCKSDB)) {
            return DbType.RocksDB;
        }
        return DbType.LevelDB;
    }

    private static LevelDBImpl openLevelDb(Path db) throws IOException {
        DB database;
        Options options = DbTool.getLevelDbOptions();
        try {
            database = JniDBFactory.factory.open(db.toFile(), options);
        }
        catch (IOException e) {
            if (e.getMessage().contains("Corruption:")) {
                JniDBFactory.factory.repair(db.toFile(), options);
                database = JniDBFactory.factory.open(db.toFile(), options);
            }
            throw e;
        }
        return new LevelDBImpl(database);
    }

    private static RocksDBImpl openRocksDb(Path db) throws RocksDBException {
        RocksDB database;
        try (org.rocksdb.Options options = DbTool.newDefaultRocksDbOptions();){
            database = RocksDB.open((org.rocksdb.Options)options, (String)db.toString());
        }
        return new RocksDBImpl(database);
    }

    private static org.rocksdb.Options newDefaultRocksDbOptions() {
        org.rocksdb.Options options = new org.rocksdb.Options();
        options.setCreateIfMissing(true);
        options.setIncreaseParallelism(1);
        options.setNumLevels(7);
        options.setMaxOpenFiles(-1);
        options.setTargetFileSizeBase(0x4000000L);
        options.setTargetFileSizeMultiplier(1);
        options.setMaxBytesForLevelBase(0x20000000L);
        options.setMaxBackgroundCompactions(Math.max(1, Runtime.getRuntime().availableProcessors()));
        options.setLevel0FileNumCompactionTrigger(4);
        options.setLevelCompactionDynamicLevelBytes(true);
        BlockBasedTableConfig tableCfg = new BlockBasedTableConfig();
        tableCfg.setBlockSize(65536L);
        tableCfg.setBlockCacheSize(0x2000000L);
        tableCfg.setCacheIndexAndFilterBlocks(true);
        tableCfg.setPinL0FilterAndIndexBlocksInCache(true);
        tableCfg.setFilter((Filter)new BloomFilter(10, false));
        options.setTableFormatConfig((TableFormatConfig)tableCfg);
        return options;
    }

    private static Options getLevelDbOptions() {
        CompressionType defaultCompressionType = CompressionType.SNAPPY;
        int defaultBlockSize = 4096;
        int defaultWriteBufferSize = 0xA00000;
        long defaultCacheSize = 0xA00000L;
        int defaultMaxOpenFiles = 100;
        Options dbOptions = new Options();
        dbOptions.createIfMissing(true);
        dbOptions.paranoidChecks(true);
        dbOptions.verifyChecksums(true);
        dbOptions.compressionType(defaultCompressionType);
        dbOptions.blockSize(defaultBlockSize);
        dbOptions.writeBufferSize(defaultWriteBufferSize);
        dbOptions.cacheSize(defaultCacheSize);
        dbOptions.maxOpenFiles(defaultMaxOpenFiles);
        return dbOptions;
    }

    static enum DbType {
        LevelDB,
        RocksDB;

    }
}

