/*
 * Decompiled with CFR 0.152.
 */
package org.tron.program;

import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ObjectUtils;
import org.tron.common.application.Application;
import org.tron.common.application.ApplicationFactory;
import org.tron.common.application.TronApplicationContext;
import org.tron.common.client.DatabaseGrpcClient;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.prometheus.Metrics;
import org.tron.core.ChainBaseManager;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.config.DefaultConfig;
import org.tron.core.config.args.Args;
import org.tron.core.db.Manager;
import org.tron.core.services.RpcApiService;
import org.tron.core.services.http.solidity.SolidityNodeHttpApiService;
import org.tron.program.FullNode;
import org.tron.protos.Protocol;

public class SolidityNode {
    private static final Logger logger = LoggerFactory.getLogger((String)"app");
    private Manager dbManager;
    private ChainBaseManager chainBaseManager;
    private DatabaseGrpcClient databaseGrpcClient;
    private AtomicLong ID = new AtomicLong();
    private AtomicLong remoteBlockNum = new AtomicLong();
    private LinkedBlockingDeque<Protocol.Block> blockQueue = new LinkedBlockingDeque(100);
    private int exceptionSleepTime = 1000;
    private volatile boolean flag = true;

    public SolidityNode(Manager dbManager) {
        this.dbManager = dbManager;
        this.chainBaseManager = dbManager.getChainBaseManager();
        this.resolveCompatibilityIssueIfUsingFullNodeDatabase();
        this.ID.set(this.chainBaseManager.getDynamicPropertiesStore().getLatestSolidifiedBlockNum());
        this.databaseGrpcClient = new DatabaseGrpcClient(CommonParameter.getInstance().getTrustNodeAddr());
        this.remoteBlockNum.set(this.getLastSolidityBlockNum());
    }

    public static void main(String[] args) {
        logger.info("Solidity node is running.");
        Args.setParam(args, "config.conf");
        CommonParameter parameter = CommonParameter.getInstance();
        logger.info("index switch is {}", (Object)BooleanUtils.toStringOnOff((boolean)BooleanUtils.toBoolean((String)parameter.getStorage().getIndexSwitch())));
        if (ObjectUtils.isEmpty((Object)parameter.getTrustNodeAddr())) {
            logger.error("Trust node is not set.");
            return;
        }
        parameter.setSolidityNode(true);
        TronApplicationContext context = new TronApplicationContext(DefaultConfig.class);
        if (parameter.isHelp()) {
            logger.info("Here is the help message.");
            return;
        }
        Metrics.init();
        Application appT = ApplicationFactory.create((ApplicationContext)context);
        FullNode.shutdown(appT);
        RpcApiService rpcApiService = (RpcApiService)context.getBean(RpcApiService.class);
        appT.addService(rpcApiService);
        SolidityNodeHttpApiService httpApiService = (SolidityNodeHttpApiService)context.getBean(SolidityNodeHttpApiService.class);
        if (CommonParameter.getInstance().solidityNodeHttpEnable) {
            appT.addService(httpApiService);
        }
        appT.initServices(parameter);
        appT.startServices();
        appT.startup();
        SolidityNode node = new SolidityNode(appT.getDbManager());
        node.start();
        rpcApiService.blockUntilShutdown();
    }

    private void start() {
        try {
            new Thread(this::getBlock).start();
            new Thread(this::processBlock).start();
            logger.info("Success to start solid node, ID: {}, remoteBlockNum: {}.", (Object)this.ID.get(), (Object)this.remoteBlockNum);
        }
        catch (Exception e) {
            logger.error("Failed to start solid node, address: {}.", (Object)CommonParameter.getInstance().getTrustNodeAddr());
            System.exit(0);
        }
    }

    private void getBlock() {
        long blockNum = this.ID.incrementAndGet();
        while (this.flag) {
            try {
                if (blockNum > this.remoteBlockNum.get()) {
                    this.sleep(3000L);
                    this.remoteBlockNum.set(this.getLastSolidityBlockNum());
                    continue;
                }
                Protocol.Block block = this.getBlockByNum(blockNum);
                this.blockQueue.put(block);
                blockNum = this.ID.incrementAndGet();
            }
            catch (Exception e) {
                logger.error("Failed to get block {}, reason: {}.", (Object)blockNum, (Object)e.getMessage());
                this.sleep(this.exceptionSleepTime);
            }
        }
    }

    private void processBlock() {
        while (this.flag) {
            try {
                Protocol.Block block = this.blockQueue.take();
                this.loopProcessBlock(block);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                this.sleep(this.exceptionSleepTime);
            }
        }
    }

    private void loopProcessBlock(Protocol.Block block) {
        while (this.flag) {
            long blockNum = block.getBlockHeader().getRawData().getNumber();
            try {
                this.dbManager.pushVerifiedBlock(new BlockCapsule(block));
                this.chainBaseManager.getDynamicPropertiesStore().saveLatestSolidifiedBlockNum(blockNum);
                logger.info("Success to process block: {}, blockQueueSize: {}.", (Object)blockNum, (Object)this.blockQueue.size());
                return;
            }
            catch (Exception e) {
                logger.error("Failed to process block {}.", (Object)new BlockCapsule(block), (Object)e);
                this.sleep(this.exceptionSleepTime);
                block = this.getBlockByNum(blockNum);
            }
        }
    }

    private Protocol.Block getBlockByNum(long blockNum) {
        while (true) {
            try {
                while (true) {
                    long time = System.currentTimeMillis();
                    Protocol.Block block = this.databaseGrpcClient.getBlock(blockNum);
                    long num = block.getBlockHeader().getRawData().getNumber();
                    if (num == blockNum) {
                        logger.info("Success to get block: {}, cost: {}ms.", (Object)blockNum, (Object)(System.currentTimeMillis() - time));
                        return block;
                    }
                    logger.warn("Get block id not the same , {}, {}.", (Object)num, (Object)blockNum);
                    this.sleep(this.exceptionSleepTime);
                }
            }
            catch (Exception e) {
                logger.error("Failed to get block: {}, reason: {}.", (Object)blockNum, (Object)e.getMessage());
                this.sleep(this.exceptionSleepTime);
                continue;
            }
            break;
        }
    }

    private long getLastSolidityBlockNum() {
        while (true) {
            try {
                long time = System.currentTimeMillis();
                long blockNum = this.databaseGrpcClient.getDynamicProperties().getLastSolidityBlockNum();
                logger.info("Get last remote solid blockNum: {}, remoteBlockNum: {}, cost: {}.", new Object[]{blockNum, this.remoteBlockNum, System.currentTimeMillis() - time});
                return blockNum;
            }
            catch (Exception e) {
                logger.error("Failed to get last solid blockNum: {}, reason: {}.", (Object)this.remoteBlockNum.get(), (Object)e.getMessage());
                this.sleep(this.exceptionSleepTime);
                continue;
            }
            break;
        }
    }

    public void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception e1) {
            logger.error(e1.getMessage());
        }
    }

    private void resolveCompatibilityIssueIfUsingFullNodeDatabase() {
        long lastSolidityBlockNum = this.chainBaseManager.getDynamicPropertiesStore().getLatestSolidifiedBlockNum();
        long headBlockNum = this.chainBaseManager.getHeadBlockNum();
        logger.info("headBlockNum:{}, solidityBlockNum:{}, diff:{}", new Object[]{headBlockNum, lastSolidityBlockNum, headBlockNum - lastSolidityBlockNum});
        if (lastSolidityBlockNum < headBlockNum) {
            logger.info("use fullNode database, headBlockNum:{}, solidityBlockNum:{}, diff:{}", new Object[]{headBlockNum, lastSolidityBlockNum, headBlockNum - lastSolidityBlockNum});
            this.chainBaseManager.getDynamicPropertiesStore().saveLatestSolidifiedBlockNum(headBlockNum);
        }
    }
}

