/*
 * Decompiled with CFR 0.152.
 */
package org.tron.program;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import com.beust.jcommander.JCommander;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.tron.common.application.Application;
import org.tron.common.application.ApplicationFactory;
import org.tron.common.application.TronApplicationContext;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.prometheus.Metrics;
import org.tron.core.config.DefaultConfig;
import org.tron.core.config.args.Args;
import org.tron.core.services.RpcApiService;
import org.tron.core.services.http.FullNodeHttpApiService;
import org.tron.core.services.interfaceJsonRpcOnPBFT.JsonRpcServiceOnPBFT;
import org.tron.core.services.interfaceJsonRpcOnSolidity.JsonRpcServiceOnSolidity;
import org.tron.core.services.interfaceOnPBFT.RpcApiServiceOnPBFT;
import org.tron.core.services.interfaceOnPBFT.http.PBFT.HttpApiOnPBFTService;
import org.tron.core.services.interfaceOnSolidity.RpcApiServiceOnSolidity;
import org.tron.core.services.interfaceOnSolidity.http.solidity.HttpApiOnSolidityService;
import org.tron.core.services.jsonrpc.FullNodeJsonRpcHttpService;

public class FullNode {
    private static final Logger logger = LoggerFactory.getLogger((String)"app");
    public static volatile boolean shutDownSign = false;

    public static void load(String path) {
        try {
            File file = new File(path);
            if (!(file.exists() && file.isFile() && file.canRead())) {
                return;
            }
            LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)lc);
            lc.reset();
            configurator.doConfigure(file);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    public static void main(String[] args) {
        logger.info("Full node running.");
        Args.setParam(args, "config.conf");
        CommonParameter parameter = Args.getInstance();
        FullNode.load(parameter.getLogbackPath());
        if (parameter.isHelp()) {
            JCommander jCommander = JCommander.newBuilder().addObject((Object)Args.PARAMETER).build();
            jCommander.parse(args);
            Args.printHelp(jCommander);
            return;
        }
        if (Args.getInstance().isDebug()) {
            logger.info("in debug mode, it won't check energy time");
        } else {
            logger.info("not in debug mode, it will check energy time");
        }
        Metrics.init();
        DefaultListableBeanFactory beanFactory = new DefaultListableBeanFactory();
        beanFactory.setAllowCircularReferences(false);
        TronApplicationContext context = new TronApplicationContext(beanFactory);
        context.register(new Class[]{DefaultConfig.class});
        context.refresh();
        Application appT = ApplicationFactory.create((ApplicationContext)context);
        FullNode.shutdown(appT);
        RpcApiService rpcApiService = (RpcApiService)context.getBean(RpcApiService.class);
        appT.addService(rpcApiService);
        FullNodeHttpApiService httpApiService = (FullNodeHttpApiService)context.getBean(FullNodeHttpApiService.class);
        if (CommonParameter.getInstance().fullNodeHttpEnable) {
            appT.addService(httpApiService);
        }
        if (CommonParameter.getInstance().jsonRpcHttpFullNodeEnable) {
            FullNodeJsonRpcHttpService jsonRpcHttpService = (FullNodeJsonRpcHttpService)context.getBean(FullNodeJsonRpcHttpService.class);
            appT.addService(jsonRpcHttpService);
        }
        RpcApiServiceOnSolidity rpcApiServiceOnSolidity = (RpcApiServiceOnSolidity)context.getBean(RpcApiServiceOnSolidity.class);
        appT.addService(rpcApiServiceOnSolidity);
        HttpApiOnSolidityService httpApiOnSolidityService = (HttpApiOnSolidityService)context.getBean(HttpApiOnSolidityService.class);
        if (CommonParameter.getInstance().solidityNodeHttpEnable) {
            appT.addService(httpApiOnSolidityService);
        }
        if (CommonParameter.getInstance().jsonRpcHttpSolidityNodeEnable) {
            JsonRpcServiceOnSolidity jsonRpcServiceOnSolidity = (JsonRpcServiceOnSolidity)context.getBean(JsonRpcServiceOnSolidity.class);
            appT.addService(jsonRpcServiceOnSolidity);
        }
        RpcApiServiceOnPBFT rpcApiServiceOnPBFT = (RpcApiServiceOnPBFT)context.getBean(RpcApiServiceOnPBFT.class);
        appT.addService(rpcApiServiceOnPBFT);
        HttpApiOnPBFTService httpApiOnPBFTService = (HttpApiOnPBFTService)context.getBean(HttpApiOnPBFTService.class);
        appT.addService(httpApiOnPBFTService);
        if (CommonParameter.getInstance().jsonRpcHttpPBFTNodeEnable) {
            JsonRpcServiceOnPBFT jsonRpcServiceOnPBFT = (JsonRpcServiceOnPBFT)context.getBean(JsonRpcServiceOnPBFT.class);
            appT.addService(jsonRpcServiceOnPBFT);
        }
        appT.initServices(parameter);
        appT.startServices();
        appT.startup();
        rpcApiService.blockUntilShutdown();
    }

    public static void shutdown(Application app) {
        logger.info("********register application shutdown hook********");
        Runtime.getRuntime().addShutdownHook(new Thread(app::shutdown));
    }
}

