/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.zen.note;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Optional;
import org.tron.common.utils.ByteArray;
import org.tron.common.zksnark.JLibrustzcash;
import org.tron.common.zksnark.LibrustzcashParam;
import org.tron.core.exception.ZksnarkException;
import org.tron.core.zen.address.DiversifierT;
import org.tron.core.zen.address.FullViewingKey;
import org.tron.core.zen.address.IncomingViewingKey;
import org.tron.core.zen.address.PaymentAddress;
import org.tron.core.zen.note.NoteEncryption;

public class Note {
    private DiversifierT d;
    private byte[] pkD;
    private long value = 0L;
    private byte[] rcm;
    private byte[] memo = new byte[512];

    public Note() {
        this.d = new DiversifierT();
        this.rcm = new byte[32];
    }

    public Note(PaymentAddress address, long value) throws ZksnarkException {
        this.value = value;
        this.d = address.getD();
        this.pkD = address.getPkD();
        this.rcm = new byte[32];
        JLibrustzcash.librustzcashSaplingGenerateR((byte[])this.rcm);
    }

    public Note(DiversifierT d, byte[] pkD, long value, byte[] r) {
        this.d = d;
        this.pkD = pkD;
        this.value = value;
        this.rcm = r;
    }

    public Note(DiversifierT d, byte[] pkD, long value, byte[] r, byte[] memo) {
        this.d = d;
        this.pkD = pkD;
        this.value = value;
        this.rcm = r;
        this.setMemo(memo);
    }

    public static byte[] generateR() throws ZksnarkException {
        byte[] r = new byte[32];
        JLibrustzcash.librustzcashSaplingGenerateR((byte[])r);
        return r;
    }

    public static Note decode(NoteEncryption.Encryption.EncPlaintext encPlaintext) throws ZksnarkException {
        byte[] data = encPlaintext.getData();
        ByteBuffer buffer = ByteBuffer.allocate(8);
        if (encPlaintext.getData()[0] != 1) {
            throw new ZksnarkException("lead byte of NotePlaintext is not recognized");
        }
        Note ret = new Note();
        byte[] noteD = new byte[11];
        System.arraycopy(data, 1, noteD, 0, 11);
        ret.d.setData(noteD);
        byte[] valueLong = new byte[8];
        System.arraycopy(data, 12, valueLong, 0, 8);
        for (int i = 0; i < valueLong.length / 2; ++i) {
            byte temp = valueLong[i];
            valueLong[i] = valueLong[valueLong.length - 1 - i];
            valueLong[valueLong.length - 1 - i] = temp;
        }
        buffer.put(valueLong, 0, valueLong.length);
        buffer.flip();
        ret.value = buffer.getLong();
        byte[] noteRcm = new byte[32];
        System.arraycopy(data, 20, noteRcm, 0, 32);
        ret.rcm = noteRcm;
        byte[] noteMemo = new byte[512];
        System.arraycopy(data, 52, noteMemo, 0, 512);
        ret.memo = noteMemo;
        return ret;
    }

    public static Optional<Note> decrypt(byte[] ciphertext, byte[] ivk, byte[] epk, byte[] cmu) throws ZksnarkException {
        Optional<NoteEncryption.Encryption.EncPlaintext> pt = NoteEncryption.Encryption.attemptEncDecryption(ciphertext, ivk, epk);
        if (!pt.isPresent()) {
            return Optional.empty();
        }
        Note ret = Note.decode(pt.get());
        byte[] pkD = new byte[32];
        if (!JLibrustzcash.librustzcashIvkToPkd((LibrustzcashParam.IvkToPkdParams)new LibrustzcashParam.IvkToPkdParams(ivk, ret.d.getData(), pkD))) {
            return Optional.empty();
        }
        byte[] cmuExpected = new byte[32];
        if (!JLibrustzcash.librustzcashComputeCm((LibrustzcashParam.ComputeCmParams)new LibrustzcashParam.ComputeCmParams(ret.d.getData(), pkD, ret.value, ret.rcm, cmuExpected))) {
            return Optional.empty();
        }
        if (!Arrays.equals(cmu, cmuExpected)) {
            return Optional.empty();
        }
        return Optional.of(ret);
    }

    public static Optional<Note> decrypt(NoteEncryption.Encryption.EncCiphertext ciphertext, byte[] epk, byte[] esk, byte[] pkD, byte[] cmu) throws ZksnarkException {
        Optional<NoteEncryption.Encryption.EncPlaintext> pt = NoteEncryption.Encryption.attemptEncDecryption(ciphertext, epk, esk, pkD);
        if (!pt.isPresent()) {
            return Optional.empty();
        }
        Note ret = Note.decode(pt.get());
        byte[] cmuExpected = new byte[32];
        if (!JLibrustzcash.librustzcashComputeCm((LibrustzcashParam.ComputeCmParams)new LibrustzcashParam.ComputeCmParams(ret.d.getData(), pkD, ret.value, ret.rcm, cmuExpected))) {
            return Optional.empty();
        }
        if (!Arrays.equals(cmu, cmuExpected)) {
            return Optional.empty();
        }
        return Optional.of(ret);
    }

    public void setMemo(byte[] memo) {
        if (ByteArray.isEmpty((byte[])memo)) {
            return;
        }
        int memoSize = memo.length < 512 ? memo.length : 512;
        System.arraycopy(memo, 0, this.memo, 0, memoSize);
    }

    public byte[] cm() throws ZksnarkException {
        byte[] result = new byte[32];
        if (!JLibrustzcash.librustzcashComputeCm((LibrustzcashParam.ComputeCmParams)new LibrustzcashParam.ComputeCmParams(this.d.getData(), this.pkD, this.value, this.rcm, result))) {
            return null;
        }
        return result;
    }

    public byte[] nullifier(FullViewingKey vk, long position) throws ZksnarkException {
        byte[] ak = vk.getAk();
        byte[] nk = vk.getNk();
        byte[] result = new byte[32];
        if (!JLibrustzcash.librustzcashComputeNf((LibrustzcashParam.ComputeNfParams)new LibrustzcashParam.ComputeNfParams(this.d.getData(), this.pkD, this.value, this.rcm, ak, nk, position, result))) {
            return null;
        }
        return result;
    }

    public byte[] nullifier(byte[] ak, byte[] nk, long position) throws ZksnarkException {
        byte[] result = new byte[32];
        if (!JLibrustzcash.librustzcashComputeNf((LibrustzcashParam.ComputeNfParams)new LibrustzcashParam.ComputeNfParams(this.d.getData(), this.pkD, this.value, this.rcm, ak, nk, position, result))) {
            return null;
        }
        return result;
    }

    public Optional<Note> note(IncomingViewingKey ivk) throws ZksnarkException {
        Optional<PaymentAddress> addr = ivk.address(this.d);
        if (addr.isPresent()) {
            return Optional.of(new Note(this.d, addr.get().getPkD(), this.value, this.rcm));
        }
        return Optional.empty();
    }

    public Optional<NotePlaintextEncryptionResult> encrypt(byte[] pkD) throws ZksnarkException {
        NoteEncryption.Encryption.EncPlaintext pt;
        Optional<NoteEncryption> sne = NoteEncryption.fromDiversifier(this.d);
        if (!sne.isPresent()) {
            return Optional.empty();
        }
        NoteEncryption enc = sne.get();
        Optional<NoteEncryption.Encryption.EncCiphertext> encciphertext = enc.encryptToRecipient(pkD, pt = this.encode());
        if (!encciphertext.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(new NotePlaintextEncryptionResult(encciphertext.get().getData(), enc));
    }

    public NoteEncryption.Encryption.EncPlaintext encode() {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(0, this.value);
        byte[] valueLong = buffer.array();
        for (int i = 0; i < valueLong.length / 2; ++i) {
            byte temp = valueLong[i];
            valueLong[i] = valueLong[valueLong.length - 1 - i];
            valueLong[valueLong.length - 1 - i] = temp;
        }
        byte[] data = new byte[564];
        data[0] = 1;
        System.arraycopy(this.d.getData(), 0, data, 1, 11);
        System.arraycopy(valueLong, 0, data, 12, 8);
        System.arraycopy(this.rcm, 0, data, 20, 32);
        System.arraycopy(this.memo, 0, data, 52, 512);
        NoteEncryption.Encryption.EncPlaintext ret = new NoteEncryption.Encryption.EncPlaintext();
        ret.setData(data);
        return ret;
    }

    public DiversifierT getD() {
        return this.d;
    }

    public void setD(DiversifierT d) {
        this.d = d;
    }

    public byte[] getPkD() {
        return this.pkD;
    }

    public void setPkD(byte[] pkD) {
        this.pkD = pkD;
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.value = value;
    }

    public byte[] getRcm() {
        return this.rcm;
    }

    public void setRcm(byte[] rcm) {
        this.rcm = rcm;
    }

    public byte[] getMemo() {
        return this.memo;
    }

    public class NotePlaintextEncryptionResult {
        private byte[] encCiphertext;
        private NoteEncryption noteEncryption;

        public NotePlaintextEncryptionResult(byte[] encCiphertext, NoteEncryption noteEncryption) {
            this.encCiphertext = encCiphertext;
            this.noteEncryption = noteEncryption;
        }

        public byte[] getEncCiphertext() {
            return this.encCiphertext;
        }

        public void setEncCiphertext(byte[] encCiphertext) {
            this.encCiphertext = encCiphertext;
        }

        public NoteEncryption getNoteEncryption() {
            return this.noteEncryption;
        }

        public void setNoteEncryption(NoteEncryption noteEncryption) {
            this.noteEncryption = noteEncryption;
        }
    }
}

