/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.zen.address;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.ByteArray;
import org.tron.common.zksnark.JLibrustzcash;
import org.tron.core.exception.ZksnarkException;
import org.tron.core.zen.address.FullViewingKey;

public class ExpandedSpendingKey {
    private static final Logger logger = LoggerFactory.getLogger((String)"shieldTransaction");
    private byte[] ask;
    private byte[] nsk;
    private byte[] ovk;

    public ExpandedSpendingKey() {
    }

    public static byte[] getAkFromAsk(byte[] ask) throws ZksnarkException {
        return JLibrustzcash.librustzcashAskToAk((byte[])ask);
    }

    public static byte[] getNkFromNsk(byte[] nsk) throws ZksnarkException {
        return JLibrustzcash.librustzcashNskToNk((byte[])nsk);
    }

    public static ExpandedSpendingKey decode(byte[] m_bytes) {
        ExpandedSpendingKey key = new ExpandedSpendingKey();
        byte[] ask = ByteArray.subArray((byte[])m_bytes, (int)0, (int)32);
        byte[] nsk = ByteArray.subArray((byte[])m_bytes, (int)32, (int)64);
        byte[] ovk = ByteArray.subArray((byte[])m_bytes, (int)64, (int)96);
        key.setAsk(ask);
        key.setNsk(nsk);
        key.setOvk(ovk);
        return key;
    }

    public FullViewingKey fullViewingKey() throws ZksnarkException {
        byte[] ak = JLibrustzcash.librustzcashAskToAk((byte[])this.ask);
        byte[] nk = JLibrustzcash.librustzcashNskToNk((byte[])this.nsk);
        return new FullViewingKey(ak, nk, this.ovk);
    }

    public byte[] encode() {
        byte[] m_bytes = new byte[96];
        System.arraycopy(this.ask, 0, m_bytes, 0, 32);
        System.arraycopy(this.nsk, 0, m_bytes, 32, 32);
        System.arraycopy(this.ovk, 0, m_bytes, 64, 32);
        return m_bytes;
    }

    public ExpandedSpendingKey(byte[] ask, byte[] nsk, byte[] ovk) {
        this.ask = ask;
        this.nsk = nsk;
        this.ovk = ovk;
    }

    public void setAsk(byte[] ask) {
        this.ask = ask;
    }

    public byte[] getAsk() {
        return this.ask;
    }

    public void setNsk(byte[] nsk) {
        this.nsk = nsk;
    }

    public byte[] getNsk() {
        return this.nsk;
    }

    public void setOvk(byte[] ovk) {
        this.ovk = ovk;
    }

    public byte[] getOvk() {
        return this.ovk;
    }
}

