/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.jsonrpc.types;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.protobuf.ByteString;
import java.util.Arrays;
import org.tron.common.utils.ByteArray;
import org.tron.core.Wallet;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.services.jsonrpc.JsonRpcApiUtil;
import org.tron.protos.Protocol;
import org.tron.protos.contract.SmartContractOuterClass;

@JsonPropertyOrder(alphabetic=true)
public class TransactionResult {
    private final String hash;
    private final String nonce;
    private final String blockHash;
    private final String blockNumber;
    private final String transactionIndex;
    private final String from;
    private final String to;
    private final String gas;
    private final String gasPrice;
    private final String value;
    private final String input;
    private final String type = "0x0";
    private String v;
    private String r;
    private String s;

    private void parseSignature(Protocol.Transaction tx) {
        if (tx.getSignatureCount() == 0) {
            this.v = ByteArray.toJsonHex((byte[])new byte[1]);
            this.r = ByteArray.toJsonHex((byte[])new byte[32]);
            this.s = ByteArray.toJsonHex((byte[])new byte[32]);
            return;
        }
        ByteString signature = tx.getSignature(0);
        byte[] signData = signature.toByteArray();
        byte[] rByte = Arrays.copyOfRange(signData, 0, 32);
        byte[] sByte = Arrays.copyOfRange(signData, 32, 64);
        byte vByte = signData[64];
        if (vByte < 27) {
            vByte = (byte)(vByte + 27);
        }
        this.v = ByteArray.toJsonHex((int)vByte);
        this.r = ByteArray.toJsonHex((byte[])rByte);
        this.s = ByteArray.toJsonHex((byte[])sByte);
    }

    private String parseInput(Protocol.Transaction tx) {
        String data;
        if (tx.getRawData().getContractCount() == 0) {
            data = "0x";
        } else {
            Protocol.Transaction.Contract contract = tx.getRawData().getContract(0);
            if (contract.getType() == Protocol.Transaction.Contract.ContractType.TriggerSmartContract) {
                try {
                    SmartContractOuterClass.TriggerSmartContract triggerSmartContract = (SmartContractOuterClass.TriggerSmartContract)contract.getParameter().unpack(SmartContractOuterClass.TriggerSmartContract.class);
                    data = ByteArray.toJsonHex((byte[])triggerSmartContract.getData().toByteArray());
                }
                catch (Exception e) {
                    data = "0x";
                }
            } else {
                data = "0x";
            }
        }
        return data;
    }

    public TransactionResult(BlockCapsule blockCapsule, int index, Protocol.Transaction tx, long energyUsageTotal, long energyFee, Wallet wallet) {
        TransactionCapsule capsule = new TransactionCapsule(tx);
        byte[] txId = capsule.getTransactionId().getBytes();
        this.hash = ByteArray.toJsonHex((byte[])txId);
        this.nonce = ByteArray.toJsonHex((byte[])new byte[8]);
        this.blockHash = ByteArray.toJsonHex((byte[])blockCapsule.getBlockId().getBytes());
        this.blockNumber = ByteArray.toJsonHex((Long)blockCapsule.getNum());
        this.transactionIndex = ByteArray.toJsonHex((int)index);
        if (!tx.getRawData().getContractList().isEmpty()) {
            Protocol.Transaction.Contract contract = tx.getRawData().getContract(0);
            byte[] fromByte = capsule.getOwnerAddress();
            byte[] toByte = JsonRpcApiUtil.getToAddress(tx);
            this.from = blockCapsule.getNum() == 0L ? ByteArray.toJsonHex((byte[])new byte[20]) : ByteArray.toJsonHexAddress((byte[])fromByte);
            this.to = ByteArray.toJsonHexAddress((byte[])toByte);
            this.value = ByteArray.toJsonHex((Long)JsonRpcApiUtil.getTransactionAmount(contract, this.hash, wallet));
        } else {
            this.from = ByteArray.toJsonHex((byte[])new byte[20]);
            this.to = ByteArray.toJsonHex((byte[])new byte[20]);
            this.value = "0x0";
        }
        this.gas = ByteArray.toJsonHex((Long)energyUsageTotal);
        this.gasPrice = ByteArray.toJsonHex((Long)energyFee);
        this.input = this.parseInput(tx);
        this.parseSignature(tx);
    }

    public TransactionResult(Protocol.Transaction tx, Wallet wallet) {
        TransactionCapsule capsule = new TransactionCapsule(tx);
        byte[] txId = capsule.getTransactionId().getBytes();
        this.hash = ByteArray.toJsonHex((byte[])txId);
        this.nonce = ByteArray.toJsonHex((byte[])new byte[8]);
        this.blockHash = "0x";
        this.blockNumber = "0x";
        this.transactionIndex = "0x";
        if (!tx.getRawData().getContractList().isEmpty()) {
            Protocol.Transaction.Contract contract = tx.getRawData().getContract(0);
            byte[] fromByte = capsule.getOwnerAddress();
            byte[] toByte = JsonRpcApiUtil.getToAddress(tx);
            this.from = ByteArray.toJsonHexAddress((byte[])fromByte);
            this.to = ByteArray.toJsonHexAddress((byte[])toByte);
            this.value = ByteArray.toJsonHex((Long)JsonRpcApiUtil.getTransactionAmount(contract, this.hash, wallet));
        } else {
            this.from = ByteArray.toJsonHex((byte[])new byte[20]);
            this.to = ByteArray.toJsonHex((byte[])new byte[20]);
            this.value = "0x0";
        }
        this.gas = "0x0";
        this.gasPrice = "0x";
        this.input = this.parseInput(tx);
        this.parseSignature(tx);
    }

    public String toString() {
        return "TransactionResult(hash=" + this.getHash() + ", nonce=" + this.getNonce() + ", blockHash=" + this.getBlockHash() + ", blockNumber=" + this.getBlockNumber() + ", transactionIndex=" + this.getTransactionIndex() + ", from=" + this.getFrom() + ", to=" + this.getTo() + ", gas=" + this.getGas() + ", gasPrice=" + this.getGasPrice() + ", value=" + this.getValue() + ", input=" + this.getInput() + ", type=" + this.getType() + ", v=" + this.getV() + ", r=" + this.getR() + ", s=" + this.getS() + ")";
    }

    public String getHash() {
        return this.hash;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getBlockHash() {
        return this.blockHash;
    }

    public String getBlockNumber() {
        return this.blockNumber;
    }

    public String getTransactionIndex() {
        return this.transactionIndex;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String getGas() {
        return this.gas;
    }

    public String getGasPrice() {
        return this.gasPrice;
    }

    public String getValue() {
        return this.value;
    }

    public String getInput() {
        return this.input;
    }

    public String getType() {
        return this.type;
    }

    public String getV() {
        return this.v;
    }

    public String getR() {
        return this.r;
    }

    public String getS() {
        return this.s;
    }
}

