/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.jsonrpc.filters;

import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.runtime.vm.DataWord;
import org.tron.common.utils.ByteArray;
import org.tron.core.capsule.TransactionRetCapsule;
import org.tron.core.db.Manager;
import org.tron.core.exception.BadItemException;
import org.tron.core.exception.ItemNotFoundException;
import org.tron.core.exception.JsonRpcTooManyResultException;
import org.tron.core.services.jsonrpc.TronJsonRpc;
import org.tron.core.services.jsonrpc.filters.LogFilter;
import org.tron.core.services.jsonrpc.filters.LogFilterWrapper;
import org.tron.protos.Protocol;

public class LogMatch {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    private final LogFilterWrapper logFilterWrapper;
    private final List<Long> blockNumList;
    private final Manager manager;

    public LogMatch(LogFilterWrapper logFilterWrapper, List<Long> blockNumList, Manager manager) {
        this.logFilterWrapper = logFilterWrapper;
        this.blockNumList = blockNumList;
        this.manager = manager;
    }

    public static List<TronJsonRpc.LogFilterElement> matchBlock(LogFilter logFilter, long blockNum, String blockHash, List<Protocol.TransactionInfo> transactionInfoList, boolean removed) {
        int txCount = transactionInfoList.size();
        ArrayList<TronJsonRpc.LogFilterElement> matchedLog = new ArrayList<TronJsonRpc.LogFilterElement>();
        int logIndexInBlock = 0;
        for (int i = 0; i < txCount; ++i) {
            Protocol.TransactionInfo transactionInfo = transactionInfoList.get(i);
            int logCount = transactionInfo.getLogCount();
            for (int j = 0; j < logCount; ++j) {
                Protocol.TransactionInfo.Log log = transactionInfo.getLog(j);
                if (logFilter.matchesExactly(log)) {
                    ArrayList<DataWord> topicList = new ArrayList<DataWord>();
                    for (ByteString topic : log.getTopicsList()) {
                        topicList.add(new DataWord(topic.toByteArray()));
                    }
                    TronJsonRpc.LogFilterElement logFilterElement = new TronJsonRpc.LogFilterElement(blockHash, blockNum, ByteArray.toHexString((byte[])transactionInfo.getId().toByteArray()), i, ByteArray.toHexString((byte[])log.getAddress().toByteArray()), topicList, ByteArray.toHexString((byte[])log.getData().toByteArray()), logIndexInBlock, removed);
                    matchedLog.add(logFilterElement);
                }
                ++logIndexInBlock;
            }
        }
        return matchedLog;
    }

    public TronJsonRpc.LogFilterElement[] matchBlockOneByOne() throws BadItemException, ItemNotFoundException, JsonRpcTooManyResultException {
        ArrayList<TronJsonRpc.LogFilterElement> logFilterElementList = new ArrayList<TronJsonRpc.LogFilterElement>();
        for (long blockNum : this.blockNumList) {
            TransactionRetCapsule transactionRetCapsule = this.manager.getTransactionRetStore().getTransactionInfoByBlockNum(ByteArray.fromLong((long)blockNum));
            if (transactionRetCapsule == null) continue;
            Protocol.TransactionRet transactionRet = transactionRetCapsule.getInstance();
            List transactionInfoList = transactionRet.getTransactioninfoList();
            String blockHash = this.manager.getChainBaseManager().getBlockIdByNum(blockNum).toString();
            List<TronJsonRpc.LogFilterElement> matchedLog = LogMatch.matchBlock(this.logFilterWrapper.getLogFilter(), blockNum, blockHash, transactionInfoList, false);
            if (!matchedLog.isEmpty()) {
                logFilterElementList.addAll(matchedLog);
            }
            if (logFilterElementList.size() <= 10000) continue;
            throw new JsonRpcTooManyResultException("query returned more than 10000 results");
        }
        return logFilterElementList.toArray(new TronJsonRpc.LogFilterElement[0]);
    }
}

