/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.jsonrpc.filters;

import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.bloom.Bloom;
import org.tron.common.crypto.Hash;
import org.tron.common.runtime.vm.DataWord;
import org.tron.core.exception.JsonRpcInvalidParamsException;
import org.tron.core.services.jsonrpc.JsonRpcApiUtil;
import org.tron.core.services.jsonrpc.TronJsonRpc;
import org.tron.protos.Protocol;

public class LogFilter {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    private byte[][] contractAddresses = new byte[0][];
    private List<byte[][]> topics = new ArrayList<byte[][]>();
    private Bloom[][] filterBlooms;

    public LogFilter() {
    }

    public LogFilter(TronJsonRpc.FilterRequest fr) throws JsonRpcInvalidParamsException {
        if (fr.getAddress() instanceof String) {
            this.withContractAddress(new byte[][]{JsonRpcApiUtil.addressToByteArray((String)fr.getAddress())});
        } else if (fr.getAddress() instanceof ArrayList) {
            ArrayList<byte[]> addr = new ArrayList<byte[]>();
            int i = 0;
            for (Object s : (ArrayList)fr.getAddress()) {
                try {
                    addr.add(JsonRpcApiUtil.addressToByteArray((String)s));
                    ++i;
                }
                catch (JsonRpcInvalidParamsException e) {
                    throw new JsonRpcInvalidParamsException(String.format("invalid address at index %d: %s", i, s));
                }
            }
            this.withContractAddress((byte[][])addr.toArray((T[])new byte[addr.size()][]));
        } else if (fr.getAddress() != null) {
            throw new JsonRpcInvalidParamsException("invalid addresses in query");
        }
        if (fr.getTopics() != null) {
            if (fr.getTopics().length > 4) {
                throw new JsonRpcInvalidParamsException("topics size should be <= 4");
            }
            for (Object topic : fr.getTopics()) {
                if (topic == null) {
                    this.withTopic(null);
                    continue;
                }
                if (topic instanceof String) {
                    try {
                        this.withTopic(new byte[][]{new DataWord(JsonRpcApiUtil.topicToByteArray((String)topic)).getData()});
                        continue;
                    }
                    catch (JsonRpcInvalidParamsException e) {
                        throw new JsonRpcInvalidParamsException("invalid topic(s): " + topic);
                    }
                }
                if (topic instanceof ArrayList) {
                    ArrayList<byte[]> t = new ArrayList<byte[]>();
                    for (Object s : (ArrayList)topic) {
                        try {
                            t.add(new DataWord(JsonRpcApiUtil.topicToByteArray((String)s)).getData());
                        }
                        catch (JsonRpcInvalidParamsException e) {
                            throw new JsonRpcInvalidParamsException("invalid topic(s): " + s);
                        }
                    }
                    this.withTopic((byte[][])t.toArray((T[])new byte[t.size()][]));
                    continue;
                }
                throw new JsonRpcInvalidParamsException("invalid topic(s)");
            }
        }
    }

    private void withContractAddress(byte[] ... orAddress) {
        this.contractAddresses = orAddress;
    }

    private void withTopic(byte[] ... orTopic) {
        this.topics.add(orTopic);
    }

    private void initBlooms() {
        if (this.filterBlooms != null) {
            return;
        }
        ArrayList<byte[][]> addrAndTopics = new ArrayList<byte[][]>(this.topics);
        addrAndTopics.add(this.contractAddresses);
        this.filterBlooms = new Bloom[addrAndTopics.size()][];
        for (int i = 0; i < addrAndTopics.size(); ++i) {
            byte[][] orTopics = (byte[][])addrAndTopics.get(i);
            if (orTopics == null || orTopics.length == 0) {
                this.filterBlooms[i] = new Bloom[]{new Bloom()};
                continue;
            }
            this.filterBlooms[i] = new Bloom[orTopics.length];
            for (int j = 0; j < orTopics.length; ++j) {
                this.filterBlooms[i][j] = Bloom.create((byte[])Hash.sha3((byte[])orTopics[j]));
            }
        }
    }

    public boolean matchBloom(Bloom blockBloom) {
        this.initBlooms();
        for (Bloom[] andBloom : this.filterBlooms) {
            boolean orMatches = false;
            for (Bloom orBloom : andBloom) {
                if (!blockBloom.matches(orBloom)) continue;
                orMatches = true;
                break;
            }
            if (orMatches) continue;
            return false;
        }
        return true;
    }

    private boolean matchesContractAddress(byte[] toAddr) {
        for (byte[] address : this.contractAddresses) {
            if (!Arrays.equals(address, toAddr)) continue;
            return true;
        }
        return this.contractAddresses.length == 0;
    }

    public boolean matchesExactly(Protocol.TransactionInfo.Log logInfo) {
        if (!this.matchesContractAddress(logInfo.getAddress().toByteArray())) {
            return false;
        }
        List logTopics = logInfo.getTopicsList();
        for (int i = 0; i < this.topics.size(); ++i) {
            if (i >= logTopics.size()) {
                return false;
            }
            byte[][] orTopics = this.topics.get(i);
            if (orTopics == null || orTopics.length <= 0) continue;
            boolean orMatches = false;
            byte[] logTopic = ((ByteString)logTopics.get(i)).toByteArray();
            for (byte[] orTopic : orTopics) {
                if (!new DataWord(orTopic).equals((Object)new DataWord(logTopic))) continue;
                orMatches = true;
                break;
            }
            if (orMatches) continue;
            return false;
        }
        return true;
    }

    public byte[][] getContractAddresses() {
        return this.contractAddresses;
    }

    public void setContractAddresses(byte[][] contractAddresses) {
        this.contractAddresses = contractAddresses;
    }

    public List<byte[][]> getTopics() {
        return this.topics;
    }

    public void setTopics(List<byte[][]> topics) {
        this.topics = topics;
    }

    public void setFilterBlooms(Bloom[][] filterBlooms) {
        this.filterBlooms = filterBlooms;
    }
}

