/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.jsonrpc;

import com.google.common.base.Throwables;
import com.google.common.primitives.Longs;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.api.GrpcAPI;
import org.tron.common.crypto.Hash;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.runtime.vm.DataWord;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.ByteUtil;
import org.tron.common.utils.DecodeUtil;
import org.tron.common.utils.Sha256Hash;
import org.tron.common.utils.StringUtil;
import org.tron.core.Wallet;
import org.tron.core.exception.JsonRpcInvalidParamsException;
import org.tron.protos.Protocol;
import org.tron.protos.contract.AccountContract;
import org.tron.protos.contract.AssetIssueContractOuterClass;
import org.tron.protos.contract.BalanceContract;
import org.tron.protos.contract.ExchangeContract;
import org.tron.protos.contract.ShieldContract;
import org.tron.protos.contract.SmartContractOuterClass;
import org.tron.protos.contract.VoteAssetContractOuterClass;
import org.tron.protos.contract.WitnessContract;

public class JsonRpcApiUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");

    public static byte[] convertToTronAddress(byte[] address) {
        byte[] newAddress = new byte[21];
        byte[] temp = new byte[]{Wallet.getAddressPreFixByte()};
        System.arraycopy(temp, 0, newAddress, 0, temp.length);
        if (address.length <= 20) {
            int start = 20 - address.length;
            System.arraycopy(address, 0, newAddress, temp.length + start, address.length);
        } else {
            int start = address.length - 20;
            System.arraycopy(address, start, newAddress, temp.length, 20);
        }
        return newAddress;
    }

    public static String encode58Check(byte[] input) {
        if (input == null || input.length == 0) {
            return "";
        }
        return StringUtil.encode58Check((byte[])input);
    }

    public static String getMethodSign(String method) {
        byte[] selector = new byte[4];
        System.arraycopy(Hash.sha3((byte[])method.getBytes()), 0, selector, 0, 4);
        return Hex.toHexString((byte[])selector);
    }

    public static SmartContractOuterClass.TriggerSmartContract triggerCallContract(byte[] address, byte[] contractAddress, long callValue, byte[] data, long tokenValue, String tokenId) {
        SmartContractOuterClass.TriggerSmartContract.Builder builder = SmartContractOuterClass.TriggerSmartContract.newBuilder();
        builder.setOwnerAddress(ByteString.copyFrom((byte[])address));
        builder.setContractAddress(ByteString.copyFrom((byte[])contractAddress));
        builder.setData(ByteString.copyFrom((byte[])data));
        builder.setCallValue(callValue);
        if (StringUtils.isNotEmpty((CharSequence)tokenId)) {
            builder.setCallTokenValue(tokenValue);
            builder.setTokenId(Long.parseLong(tokenId));
        }
        return builder.build();
    }

    public static String getBlockID(Protocol.Block block) {
        long blockNum = block.getBlockHeader().getRawData().getNumber();
        byte[] blockHash = Sha256Hash.of((boolean)true, (byte[])block.getBlockHeader().getRawData().toByteArray()).getByteString().toByteArray();
        byte[] numBytes = Longs.toByteArray((long)blockNum);
        byte[] hash = new byte[blockHash.length];
        System.arraycopy(numBytes, 0, hash, 0, 8);
        System.arraycopy(blockHash, 8, hash, 8, blockHash.length - 8);
        return "0x" + ByteArray.toHexString((byte[])hash);
    }

    public static byte[] getToAddress(Protocol.Transaction transaction) {
        List<ByteString> toAddressList = JsonRpcApiUtil.getTo(transaction);
        if (!toAddressList.isEmpty()) {
            return toAddressList.get(0).toByteArray();
        }
        return new byte[0];
    }

    public static List<ByteString> getTo(Protocol.Transaction transaction) {
        Protocol.Transaction.Contract contract = transaction.getRawData().getContract(0);
        ArrayList<ByteString> list = new ArrayList<ByteString>();
        try {
            Any contractParameter = contract.getParameter();
            switch (contract.getType()) {
                case AccountCreateContract: {
                    list.add(((AccountContract.AccountCreateContract)contractParameter.unpack(AccountContract.AccountCreateContract.class)).getAccountAddress());
                    break;
                }
                case TransferContract: {
                    list.add(((BalanceContract.TransferContract)contractParameter.unpack(BalanceContract.TransferContract.class)).getToAddress());
                    break;
                }
                case TransferAssetContract: {
                    list.add(((AssetIssueContractOuterClass.TransferAssetContract)contractParameter.unpack(AssetIssueContractOuterClass.TransferAssetContract.class)).getToAddress());
                    break;
                }
                case VoteAssetContract: {
                    list.addAll(((VoteAssetContractOuterClass.VoteAssetContract)contractParameter.unpack(VoteAssetContractOuterClass.VoteAssetContract.class)).getVoteAddressList());
                    break;
                }
                case VoteWitnessContract: {
                    for (WitnessContract.VoteWitnessContract.Vote vote : ((WitnessContract.VoteWitnessContract)contractParameter.unpack(WitnessContract.VoteWitnessContract.class)).getVotesList()) {
                        list.add(vote.getVoteAddress());
                    }
                    break;
                }
                case ParticipateAssetIssueContract: {
                    list.add(((AssetIssueContractOuterClass.ParticipateAssetIssueContract)contractParameter.unpack(AssetIssueContractOuterClass.ParticipateAssetIssueContract.class)).getToAddress());
                    break;
                }
                case FreezeBalanceContract: {
                    ByteString receiverAddress = ((BalanceContract.FreezeBalanceContract)contractParameter.unpack(BalanceContract.FreezeBalanceContract.class)).getReceiverAddress();
                    if (receiverAddress.isEmpty()) break;
                    list.add(receiverAddress);
                    break;
                }
                case UnfreezeBalanceContract: {
                    ByteString receiverAddress = ((BalanceContract.UnfreezeBalanceContract)contractParameter.unpack(BalanceContract.UnfreezeBalanceContract.class)).getReceiverAddress();
                    if (receiverAddress.isEmpty()) break;
                    list.add(receiverAddress);
                    break;
                }
                case DelegateResourceContract: {
                    ByteString receiverAddress = ((BalanceContract.DelegateResourceContract)contractParameter.unpack(BalanceContract.DelegateResourceContract.class)).getReceiverAddress();
                    if (receiverAddress.isEmpty()) break;
                    list.add(receiverAddress);
                    break;
                }
                case UnDelegateResourceContract: {
                    ByteString receiverAddress = ((BalanceContract.UnDelegateResourceContract)contractParameter.unpack(BalanceContract.UnDelegateResourceContract.class)).getReceiverAddress();
                    if (receiverAddress.isEmpty()) break;
                    list.add(receiverAddress);
                    break;
                }
                case TriggerSmartContract: {
                    list.add(((SmartContractOuterClass.TriggerSmartContract)contractParameter.unpack(SmartContractOuterClass.TriggerSmartContract.class)).getContractAddress());
                    break;
                }
                case UpdateSettingContract: {
                    list.add(((SmartContractOuterClass.UpdateSettingContract)contractParameter.unpack(SmartContractOuterClass.UpdateSettingContract.class)).getContractAddress());
                    break;
                }
                case UpdateEnergyLimitContract: {
                    list.add(((SmartContractOuterClass.UpdateEnergyLimitContract)contractParameter.unpack(SmartContractOuterClass.UpdateEnergyLimitContract.class)).getContractAddress());
                    break;
                }
                case ClearABIContract: {
                    list.add(((SmartContractOuterClass.ClearABIContract)contractParameter.unpack(SmartContractOuterClass.ClearABIContract.class)).getContractAddress());
                    break;
                }
                case ShieldedTransferContract: {
                    ShieldContract.ShieldedTransferContract shieldedTransferContract = (ShieldContract.ShieldedTransferContract)contract.getParameter().unpack(ShieldContract.ShieldedTransferContract.class);
                    if (shieldedTransferContract.getTransparentToAddress().isEmpty()) break;
                    list.add(shieldedTransferContract.getTransparentToAddress());
                    break;
                }
            }
            return list;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
    }

    public static String getTxID(Protocol.Transaction transaction) {
        return ByteArray.toHexString((byte[])Sha256Hash.hash((boolean)true, (byte[])transaction.getRawData().toByteArray()));
    }

    public static long getTransactionAmount(Protocol.Transaction.Contract contract, String hash, Wallet wallet) {
        long amount = 0L;
        try {
            switch (contract.getType()) {
                case UnfreezeBalanceContract: 
                case WithdrawBalanceContract: 
                case WithdrawExpireUnfreezeContract: 
                case UnfreezeBalanceV2Contract: 
                case CancelAllUnfreezeV2Contract: {
                    Protocol.TransactionInfo transactionInfo = wallet.getTransactionInfoById(ByteString.copyFrom((byte[])ByteArray.fromHexString((String)hash)));
                    amount = JsonRpcApiUtil.getAmountFromTransactionInfo(hash, contract.getType(), transactionInfo);
                    break;
                }
                default: {
                    amount = JsonRpcApiUtil.getTransactionAmount(contract, hash, null, wallet);
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception happens when get amount. Exception = [{}]", (Object)Throwables.getStackTraceAsString((Throwable)e));
        }
        return amount;
    }

    public static long getTransactionAmount(Protocol.Transaction.Contract contract, String hash, Protocol.TransactionInfo transactionInfo, Wallet wallet) {
        long amount = 0L;
        try {
            Any contractParameter = contract.getParameter();
            switch (contract.getType()) {
                case TransferContract: {
                    amount = ((BalanceContract.TransferContract)contractParameter.unpack(BalanceContract.TransferContract.class)).getAmount();
                    break;
                }
                case TransferAssetContract: {
                    amount = ((AssetIssueContractOuterClass.TransferAssetContract)contractParameter.unpack(AssetIssueContractOuterClass.TransferAssetContract.class)).getAmount();
                    break;
                }
                case VoteWitnessContract: {
                    List votesList = ((WitnessContract.VoteWitnessContract)contractParameter.unpack(WitnessContract.VoteWitnessContract.class)).getVotesList();
                    long voteNumber = 0L;
                    for (WitnessContract.VoteWitnessContract.Vote vote : votesList) {
                        voteNumber += vote.getVoteCount();
                    }
                    amount = voteNumber;
                    break;
                }
                case WitnessCreateContract: {
                    amount = 9999000000L;
                    break;
                }
                case AssetIssueContract: 
                case ExchangeCreateContract: {
                    amount = 1024000000L;
                    break;
                }
                case ParticipateAssetIssueContract: {
                    break;
                }
                case FreezeBalanceContract: {
                    amount = ((BalanceContract.FreezeBalanceContract)contractParameter.unpack(BalanceContract.FreezeBalanceContract.class)).getFrozenBalance();
                    break;
                }
                case TriggerSmartContract: {
                    amount = ((SmartContractOuterClass.TriggerSmartContract)contractParameter.unpack(SmartContractOuterClass.TriggerSmartContract.class)).getCallValue();
                    break;
                }
                case ExchangeInjectContract: {
                    amount = ((ExchangeContract.ExchangeInjectContract)contractParameter.unpack(ExchangeContract.ExchangeInjectContract.class)).getQuant();
                    break;
                }
                case ExchangeWithdrawContract: {
                    amount = ((ExchangeContract.ExchangeWithdrawContract)contractParameter.unpack(ExchangeContract.ExchangeWithdrawContract.class)).getQuant();
                    break;
                }
                case ExchangeTransactionContract: {
                    amount = ((ExchangeContract.ExchangeTransactionContract)contractParameter.unpack(ExchangeContract.ExchangeTransactionContract.class)).getQuant();
                    break;
                }
                case AccountPermissionUpdateContract: {
                    amount = 100000000L;
                    break;
                }
                case ShieldedTransferContract: {
                    ShieldContract.ShieldedTransferContract shieldedTransferContract = (ShieldContract.ShieldedTransferContract)contract.getParameter().unpack(ShieldContract.ShieldedTransferContract.class);
                    if (shieldedTransferContract.getFromAmount() > 0L) {
                        amount = shieldedTransferContract.getFromAmount();
                        break;
                    }
                    if (shieldedTransferContract.getToAmount() <= 0L) break;
                    amount = shieldedTransferContract.getToAmount();
                    break;
                }
                case UnfreezeBalanceContract: 
                case WithdrawBalanceContract: 
                case WithdrawExpireUnfreezeContract: 
                case UnfreezeBalanceV2Contract: 
                case CancelAllUnfreezeV2Contract: {
                    amount = JsonRpcApiUtil.getAmountFromTransactionInfo(hash, contract.getType(), transactionInfo);
                    break;
                }
                case UnfreezeAssetContract: {
                    amount = JsonRpcApiUtil.getUnfreezeAssetAmount(((AssetIssueContractOuterClass.UnfreezeAssetContract)contractParameter.unpack(AssetIssueContractOuterClass.UnfreezeAssetContract.class)).getOwnerAddress().toByteArray(), wallet);
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception happens when get amount. Exception = [{}]", (Object)Throwables.getStackTraceAsString((Throwable)e));
        }
        return amount;
    }

    public static long getAmountFromTransactionInfo(String hash, Protocol.Transaction.Contract.ContractType contractType, Protocol.TransactionInfo transactionInfo) {
        long amount = 0L;
        try {
            if (transactionInfo != null) {
                switch (contractType) {
                    case UnfreezeBalanceContract: 
                    case UnfreezeBalanceV2Contract: {
                        amount = transactionInfo.getUnfreezeAmount();
                        break;
                    }
                    case WithdrawBalanceContract: {
                        amount = transactionInfo.getWithdrawAmount();
                        break;
                    }
                    case ExchangeInjectContract: {
                        amount = transactionInfo.getExchangeInjectAnotherAmount();
                        break;
                    }
                    case ExchangeWithdrawContract: {
                        amount = transactionInfo.getExchangeWithdrawAnotherAmount();
                        break;
                    }
                    case ExchangeTransactionContract: {
                        amount = transactionInfo.getExchangeReceivedAmount();
                        break;
                    }
                    case WithdrawExpireUnfreezeContract: {
                        amount = transactionInfo.getWithdrawExpireAmount();
                        break;
                    }
                    case CancelAllUnfreezeV2Contract: {
                        amount = transactionInfo.getCancelUnfreezeV2AmountMap().values().stream().mapToLong(v -> v).sum();
                        break;
                    }
                }
            } else {
                logger.warn("Can't find transaction {} ", (Object)hash);
            }
        }
        catch (Exception e) {
            logger.warn("Exception happens when get amount from transactionInfo. Exception = [{}]", (Object)Throwables.getStackTraceAsString((Throwable)e));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return amount;
    }

    public static long getUnfreezeAssetAmount(byte[] addressBytes, Wallet wallet) {
        long amount = 0L;
        try {
            if (addressBytes == null) {
                return amount;
            }
            GrpcAPI.AssetIssueList assetIssueList = wallet.getAssetIssueByAccount(ByteString.copyFrom((byte[])addressBytes));
            if (assetIssueList != null) {
                if (assetIssueList.getAssetIssueCount() != 1) {
                    return amount;
                }
                AssetIssueContractOuterClass.AssetIssueContract assetIssue = assetIssueList.getAssetIssue(0);
                for (AssetIssueContractOuterClass.AssetIssueContract.FrozenSupply frozenSupply : assetIssue.getFrozenSupplyList()) {
                    amount += frozenSupply.getFrozenAmount();
                }
            }
        }
        catch (Exception e) {
            logger.warn("Exception happens when get token10 frozenAmount. Exception = [{}]", (Object)Throwables.getStackTraceAsString((Throwable)e));
        }
        return amount;
    }

    public static byte[] addressCompatibleToByteArray(String hexAddress) throws JsonRpcInvalidParamsException {
        byte[] addressByte;
        try {
            addressByte = ByteArray.fromHexString((String)hexAddress);
            if (addressByte.length != 21 && addressByte.length != 20) {
                throw new JsonRpcInvalidParamsException("invalid address hash value");
            }
            if (addressByte.length == 20) {
                addressByte = ByteUtil.merge((byte[][])new byte[][]{{DecodeUtil.addressPreFixByte}, addressByte});
            } else if (addressByte[0] != ByteArray.fromHexString((String)DecodeUtil.addressPreFixString)[0]) {
                throw new JsonRpcInvalidParamsException("invalid address hash value");
            }
        }
        catch (Exception e) {
            throw new JsonRpcInvalidParamsException(e.getMessage());
        }
        return addressByte;
    }

    public static byte[] addressToByteArray(String hexAddress) throws JsonRpcInvalidParamsException {
        byte[] addressByte = ByteArray.fromHexString((String)hexAddress);
        if (addressByte.length != 20) {
            throw new JsonRpcInvalidParamsException("invalid address: " + hexAddress);
        }
        return new DataWord(addressByte).getLast20Bytes();
    }

    public static byte[] topicToByteArray(String hexTopic) throws JsonRpcInvalidParamsException {
        byte[] topicByte = ByteArray.fromHexString((String)hexTopic);
        if (topicByte.length != 32) {
            throw new JsonRpcInvalidParamsException("invalid topic: " + hexTopic);
        }
        return topicByte;
    }

    public static boolean paramStringIsNull(String string) {
        return StringUtils.isEmpty((CharSequence)string) || string.equals("0x");
    }

    public static boolean paramQuantityIsNull(String quantity) {
        return StringUtils.isEmpty((CharSequence)quantity) || quantity.equals("0x0");
    }

    public static long parseQuantityValue(String value) throws JsonRpcInvalidParamsException {
        long callValue = 0L;
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            try {
                callValue = ByteArray.jsonHexToLong((String)value);
            }
            catch (Exception e) {
                throw new JsonRpcInvalidParamsException("invalid param value: invalid hex number");
            }
        }
        return callValue;
    }

    public static long getEnergyUsageTotal(Protocol.Transaction transaction, Wallet wallet) {
        long energyUsageTotal = 0L;
        byte[] txHash = Sha256Hash.hash((boolean)CommonParameter.getInstance().isECKeyCryptoEngine(), (byte[])transaction.getRawData().toByteArray());
        Protocol.TransactionInfo transactionInfo = wallet.getTransactionInfoById(ByteString.copyFrom((byte[])txHash));
        if (transactionInfo != null) {
            energyUsageTotal = transactionInfo.getReceipt().getEnergyUsageTotal();
        }
        return energyUsageTotal;
    }

    public static long getEnergyUsageTotal(List<Protocol.TransactionInfo> transactionInfoList, int i, long blockNum) {
        long energyUsageTotal = 0L;
        if (!transactionInfoList.isEmpty()) {
            try {
                energyUsageTotal = transactionInfoList.get(i).getReceipt().getEnergyUsageTotal();
            }
            catch (Exception e) {
                logger.warn("getBlockResult cannot get energy from transactionInfo, block.num={}, error is {}", (Object)blockNum, (Object)e.getMessage());
            }
        }
        return energyUsageTotal;
    }

    public static int getTransactionIndex(String txId, List<Protocol.Transaction> txList) {
        int transactionIndex = -1;
        for (int index = 0; index < txList.size(); ++index) {
            Protocol.Transaction transaction = txList.get(index);
            if (!JsonRpcApiUtil.getTxID(transaction).equals(txId)) continue;
            transactionIndex = index;
            break;
        }
        return transactionIndex;
    }

    public static long parseEnergyFee(long timestamp, String energyPriceHistory) {
        String[] priceList = energyPriceHistory.split(",");
        for (int i = priceList.length - 1; i >= 0; --i) {
            String[] priceArray = priceList[i].split(":");
            long time = Long.parseLong(priceArray[0]);
            long price = Long.parseLong(priceArray[1]);
            if (timestamp <= time) continue;
            return price;
        }
        return -1L;
    }

    public static long getByJsonBlockId(String blockNumOrTag) throws JsonRpcInvalidParamsException {
        if ("pending".equalsIgnoreCase(blockNumOrTag)) {
            throw new JsonRpcInvalidParamsException("TAG pending not supported");
        }
        if (StringUtils.isEmpty((CharSequence)blockNumOrTag) || "latest".equalsIgnoreCase(blockNumOrTag)) {
            return -1L;
        }
        if ("earliest".equalsIgnoreCase(blockNumOrTag)) {
            return 0L;
        }
        return ByteArray.jsonHexToLong((String)blockNumOrTag);
    }

    public static String generateFilterId() {
        SecureRandom random = new SecureRandom();
        byte[] uid = new byte[16];
        random.nextBytes(uid);
        return ByteArray.toHexString((byte[])uid);
    }
}

