/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.Message;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.api.GrpcAPI;
import org.tron.common.utils.ByteArray;
import org.tron.core.Wallet;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.PostParams;
import org.tron.core.services.http.RateLimiterServlet;
import org.tron.core.services.http.Util;

@Component
public class ScanAndMarkNoteByIvkServlet
extends RateLimiterServlet {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    @Autowired
    private Wallet wallet;

    private String convertOutput(GrpcAPI.DecryptNotesMarked notes, boolean visible) {
        String resultString = JsonFormat.printToString((Message)notes, visible);
        if (notes.getNoteTxsCount() == 0) {
            return resultString;
        }
        JSONObject markedNotes = JSONObject.parseObject((String)resultString);
        JSONArray array = markedNotes.getJSONArray("noteTxs");
        for (int index = 0; index < array.size(); ++index) {
            JSONObject item = array.getJSONObject(index);
            item.put("is_spend", (Object)notes.getNoteTxs(index).getIsSpend());
            item.put("index", (Object)notes.getNoteTxs(index).getIndex());
        }
        return markedNotes.toJSONString();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            PostParams params = PostParams.getPostParams(request);
            GrpcAPI.IvkDecryptAndMarkParameters.Builder ivkDecryptParameters = GrpcAPI.IvkDecryptAndMarkParameters.newBuilder();
            JsonFormat.merge(params.getParams(), (Message.Builder)ivkDecryptParameters);
            GrpcAPI.DecryptNotesMarked notes = this.wallet.scanAndMarkNoteByIvk(ivkDecryptParameters.getStartBlockIndex(), ivkDecryptParameters.getEndBlockIndex(), ivkDecryptParameters.getIvk().toByteArray(), ivkDecryptParameters.getAk().toByteArray(), ivkDecryptParameters.getNk().toByteArray());
            response.getWriter().println(this.convertOutput(notes, params.isVisible()));
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            long startNum = Long.parseLong(request.getParameter("start_block_index"));
            long endNum = Long.parseLong(request.getParameter("end_block_index"));
            String ivk = request.getParameter("ivk");
            String ak = request.getParameter("ak");
            String nk = request.getParameter("nk");
            boolean visible = Util.getVisible(request);
            GrpcAPI.DecryptNotesMarked notes = this.wallet.scanAndMarkNoteByIvk(startNum, endNum, ByteArray.fromHexString((String)ivk), ByteArray.fromHexString((String)ak), ByteArray.fromHexString((String)nk));
            response.getWriter().println(this.convertOutput(notes, visible));
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }
}

