/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.api.GrpcAPI;
import org.tron.core.Wallet;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.PostParams;
import org.tron.core.services.http.RateLimiterServlet;
import org.tron.core.services.http.Util;
import org.tron.protos.Protocol;

@Component
public class GetTransactionInfoByBlockNumServlet
extends RateLimiterServlet {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    @Autowired
    private Wallet wallet;

    private JSONObject convertLogAddressToTronAddress(Protocol.TransactionInfo transactionInfo, boolean visible) {
        if (visible) {
            List<Protocol.TransactionInfo.Log> newLogList = Util.convertLogAddressToTronAddress(transactionInfo);
            transactionInfo = transactionInfo.toBuilder().clearLog().addAllLog(newLogList).build();
        }
        return JSONObject.parseObject((String)JsonFormat.printToString((Message)transactionInfo, visible));
    }

    private String printTransactionInfoList(GrpcAPI.TransactionInfoList list, boolean selfType) {
        JSONArray jsonArray = new JSONArray();
        for (Protocol.TransactionInfo transactionInfo : list.getTransactionInfoList()) {
            jsonArray.add((Object)this.convertLogAddressToTronAddress(transactionInfo, selfType));
        }
        return jsonArray.toJSONString();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            boolean visible = Util.getVisible(request);
            long num = Long.parseLong(request.getParameter("num"));
            if (num > 0L) {
                GrpcAPI.TransactionInfoList reply = this.wallet.getTransactionInfoByBlockNum(num);
                response.getWriter().println(this.printTransactionInfoList(reply, visible));
            } else {
                response.getWriter().println("{}");
            }
        }
        catch (Exception e) {
            logger.debug("Exception: {}", (Object)e.getMessage());
            try {
                response.getWriter().println(Util.printErrorMsg(e));
            }
            catch (IOException ioe) {
                logger.debug("IOException: {}", (Object)ioe.getMessage());
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            PostParams params = PostParams.getPostParams(request);
            GrpcAPI.NumberMessage.Builder build = GrpcAPI.NumberMessage.newBuilder();
            JsonFormat.merge(params.getParams(), (Message.Builder)build, params.isVisible());
            long num = build.getNum();
            if (num > 0L) {
                GrpcAPI.TransactionInfoList reply = this.wallet.getTransactionInfoByBlockNum(num);
                response.getWriter().println(this.printTransactionInfoList(reply, params.isVisible()));
            } else {
                response.getWriter().println("{}");
            }
        }
        catch (Exception e) {
            logger.debug("Exception: {}", (Object)e.getMessage());
            try {
                response.getWriter().println(Util.printErrorMsg(e));
            }
            catch (IOException ioe) {
                logger.debug("IOException: {}", (Object)ioe.getMessage());
            }
        }
    }
}

