/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.google.protobuf.Message;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.utils.ByteArray;
import org.tron.core.Wallet;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.RateLimiterServlet;
import org.tron.core.services.http.Util;
import org.tron.protos.Protocol;

@Component
public class GetMarketOrderListByPairServlet
extends RateLimiterServlet {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    @Autowired
    private Wallet wallet;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            boolean visible = Util.getVisible(request);
            String sellTokenId = request.getParameter("sell_token_id");
            String buyTokenId = request.getParameter("buy_token_id");
            if (visible) {
                sellTokenId = Util.getHexString(sellTokenId);
                buyTokenId = Util.getHexString(buyTokenId);
            }
            this.fillResponse(visible, ByteArray.fromHexString((String)sellTokenId), ByteArray.fromHexString((String)buyTokenId), response);
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            String input = request.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
            Util.checkBodySize(input);
            boolean visible = Util.getVisiblePost(input);
            Protocol.MarketOrderPair.Builder build = Protocol.MarketOrderPair.newBuilder();
            JsonFormat.merge(input, (Message.Builder)build, visible);
            this.fillResponse(visible, build.getSellTokenId().toByteArray(), build.getBuyTokenId().toByteArray(), response);
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }

    private void fillResponse(boolean visible, byte[] sellTokenId, byte[] buyTokenId, HttpServletResponse response) throws Exception {
        Protocol.MarketOrderList reply = this.wallet.getMarketOrderListByPair(sellTokenId, buyTokenId);
        if (reply != null) {
            response.getWriter().println(JsonFormat.printToString((Message)reply, visible));
        } else {
            response.getWriter().println("{}");
        }
    }
}

