/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.api.GrpcAPI;
import org.tron.common.utils.ByteArray;
import org.tron.core.Wallet;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.PostParams;
import org.tron.core.services.http.RateLimiterServlet;
import org.tron.core.services.http.Util;

@Component
public class GetCanDelegatedMaxSizeServlet
extends RateLimiterServlet {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    @Autowired
    private Wallet wallet;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            boolean visible = Util.getVisible(request);
            int type = Integer.parseInt(request.getParameter("type"));
            String ownerAddress = request.getParameter("owner_address");
            if (visible) {
                ownerAddress = Util.getHexAddress(ownerAddress);
            }
            this.fillResponse(visible, ByteString.copyFrom((byte[])ByteArray.fromHexString((String)ownerAddress)), type, response);
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            PostParams params = PostParams.getPostParams(request);
            GrpcAPI.CanDelegatedMaxSizeRequestMessage.Builder build = GrpcAPI.CanDelegatedMaxSizeRequestMessage.newBuilder();
            JsonFormat.merge(params.getParams(), (Message.Builder)build, params.isVisible());
            this.fillResponse(params.isVisible(), build.getOwnerAddress(), build.getType(), response);
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }

    private void fillResponse(boolean visible, ByteString ownerAddress, int resourceType, HttpServletResponse response) throws IOException {
        GrpcAPI.CanDelegatedMaxSizeResponseMessage reply = this.wallet.getCanDelegatedMaxSize(ownerAddress, resourceType);
        if (reply != null) {
            response.getWriter().println(JsonFormat.printToString((Message)reply, visible));
        } else {
            response.getWriter().println("{}");
        }
    }
}

