/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Strings;
import com.google.protobuf.Message;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.api.GrpcAPI;
import org.tron.core.Wallet;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.PostParams;
import org.tron.core.services.http.RateLimiterServlet;
import org.tron.core.services.http.Util;
import org.tron.protos.Protocol;

@Component
public class GetBlockServlet
extends RateLimiterServlet {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    @Autowired
    private Wallet wallet;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.handle(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.handle(request, response);
    }

    private void handle(HttpServletRequest request, HttpServletResponse response) {
        try {
            PostParams params = this.parseParams(request);
            GrpcAPI.BlockReq message = this.buildRequest(params.getParams(), params.isVisible());
            this.fillResponse(params.isVisible(), message, response);
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }

    private PostParams parseParams(HttpServletRequest request) throws Exception {
        HttpMethod m = HttpMethod.fromString((String)request.getMethod());
        if (HttpMethod.GET.equals((Object)m)) {
            String idOrNum = request.getParameter("id_or_num");
            JSONObject params = new JSONObject();
            if (!Strings.isNullOrEmpty((String)idOrNum)) {
                params.put("id_or_num", (Object)idOrNum);
            }
            params.put("detail", (Object)Boolean.parseBoolean(request.getParameter("detail")));
            return new PostParams(JSON.toJSONString((Object)params), Boolean.parseBoolean(request.getParameter("visible")));
        }
        if (HttpMethod.POST.equals((Object)m)) {
            return PostParams.getPostParams(request);
        }
        throw new UnsupportedOperationException();
    }

    private GrpcAPI.BlockReq buildRequest(String params, boolean visible) throws JsonFormat.ParseException {
        GrpcAPI.BlockReq.Builder build = GrpcAPI.BlockReq.newBuilder();
        if (!Strings.isNullOrEmpty((String)params)) {
            JsonFormat.merge(params, (Message.Builder)build, visible);
        }
        return build.build();
    }

    private void fillResponse(boolean visible, GrpcAPI.BlockReq request, HttpServletResponse response) throws IOException {
        try {
            Protocol.Block reply = this.wallet.getBlock(request);
            if (reply != null) {
                response.getWriter().println(Util.printBlock(reply, visible));
            } else {
                response.getWriter().println("{}");
            }
        }
        catch (IllegalArgumentException e) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("Error", (Object)e.getMessage());
            response.getWriter().println(jsonObject.toJSONString());
        }
    }
}

