/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.google.protobuf.Message;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.api.GrpcAPI;
import org.tron.core.Wallet;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.PostParams;
import org.tron.core.services.http.RateLimiterServlet;
import org.tron.core.services.http.Util;

@Component
public class GetBlockByLatestNumServlet
extends RateLimiterServlet {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    private static final long BLOCK_LIMIT_NUM = 100L;
    @Autowired
    private Wallet wallet;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            this.fillResponse(Util.getVisible(request), Long.parseLong(request.getParameter("num")), response);
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            PostParams params = PostParams.getPostParams(request);
            GrpcAPI.NumberMessage.Builder build = GrpcAPI.NumberMessage.newBuilder();
            JsonFormat.merge(params.getParams(), (Message.Builder)build, params.isVisible());
            this.fillResponse(params.isVisible(), build.getNum(), response);
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }

    private void fillResponse(boolean visible, long num, HttpServletResponse response) throws IOException {
        GrpcAPI.BlockList reply;
        if (num > 0L && num < 100L && (reply = this.wallet.getBlockByLatestNum(num)) != null) {
            response.getWriter().println(Util.printBlockList(reply, visible));
            return;
        }
        response.getWriter().println("{}");
    }
}

