/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.commons.io.FileUtils;
import org.eclipse.jetty.server.ConnectionLimit;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.application.Service;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.zksnark.JLibrustzcash;
import org.tron.common.zksnark.LibrustzcashParam;
import org.tron.core.config.args.Args;
import org.tron.core.exception.ZksnarkException;
import org.tron.core.services.filter.HttpApiAccessFilter;
import org.tron.core.services.filter.HttpInterceptor;
import org.tron.core.services.filter.LiteFnQueryHttpFilter;
import org.tron.core.services.http.AccountPermissionUpdateServlet;
import org.tron.core.services.http.BroadcastHexServlet;
import org.tron.core.services.http.BroadcastServlet;
import org.tron.core.services.http.CancelAllUnfreezeV2Servlet;
import org.tron.core.services.http.ClearABIServlet;
import org.tron.core.services.http.CreateAccountServlet;
import org.tron.core.services.http.CreateAssetIssueServlet;
import org.tron.core.services.http.CreateCommonTransactionServlet;
import org.tron.core.services.http.CreateShieldNullifierServlet;
import org.tron.core.services.http.CreateShieldedContractParametersServlet;
import org.tron.core.services.http.CreateShieldedContractParametersWithoutAskServlet;
import org.tron.core.services.http.CreateShieldedTransactionServlet;
import org.tron.core.services.http.CreateShieldedTransactionWithoutSpendAuthSigServlet;
import org.tron.core.services.http.CreateSpendAuthSigServlet;
import org.tron.core.services.http.CreateWitnessServlet;
import org.tron.core.services.http.DelegateResourceServlet;
import org.tron.core.services.http.DeployContractServlet;
import org.tron.core.services.http.EstimateEnergyServlet;
import org.tron.core.services.http.ExchangeCreateServlet;
import org.tron.core.services.http.ExchangeInjectServlet;
import org.tron.core.services.http.ExchangeTransactionServlet;
import org.tron.core.services.http.ExchangeWithdrawServlet;
import org.tron.core.services.http.FreezeBalanceServlet;
import org.tron.core.services.http.FreezeBalanceV2Servlet;
import org.tron.core.services.http.GetAccountBalanceServlet;
import org.tron.core.services.http.GetAccountByIdServlet;
import org.tron.core.services.http.GetAccountNetServlet;
import org.tron.core.services.http.GetAccountResourceServlet;
import org.tron.core.services.http.GetAccountServlet;
import org.tron.core.services.http.GetAkFromAskServlet;
import org.tron.core.services.http.GetAssetIssueByAccountServlet;
import org.tron.core.services.http.GetAssetIssueByIdServlet;
import org.tron.core.services.http.GetAssetIssueByNameServlet;
import org.tron.core.services.http.GetAssetIssueListByNameServlet;
import org.tron.core.services.http.GetAssetIssueListServlet;
import org.tron.core.services.http.GetAvailableUnfreezeCountServlet;
import org.tron.core.services.http.GetBandwidthPricesServlet;
import org.tron.core.services.http.GetBlockBalanceServlet;
import org.tron.core.services.http.GetBlockByIdServlet;
import org.tron.core.services.http.GetBlockByLatestNumServlet;
import org.tron.core.services.http.GetBlockByLimitNextServlet;
import org.tron.core.services.http.GetBlockByNumServlet;
import org.tron.core.services.http.GetBlockServlet;
import org.tron.core.services.http.GetBrokerageServlet;
import org.tron.core.services.http.GetBurnTrxServlet;
import org.tron.core.services.http.GetCanDelegatedMaxSizeServlet;
import org.tron.core.services.http.GetCanWithdrawUnfreezeAmountServlet;
import org.tron.core.services.http.GetChainParametersServlet;
import org.tron.core.services.http.GetContractInfoServlet;
import org.tron.core.services.http.GetContractServlet;
import org.tron.core.services.http.GetDelegatedResourceAccountIndexServlet;
import org.tron.core.services.http.GetDelegatedResourceAccountIndexV2Servlet;
import org.tron.core.services.http.GetDelegatedResourceServlet;
import org.tron.core.services.http.GetDelegatedResourceV2Servlet;
import org.tron.core.services.http.GetDiversifierServlet;
import org.tron.core.services.http.GetEnergyPricesServlet;
import org.tron.core.services.http.GetExchangeByIdServlet;
import org.tron.core.services.http.GetExpandedSpendingKeyServlet;
import org.tron.core.services.http.GetIncomingViewingKeyServlet;
import org.tron.core.services.http.GetMarketOrderByAccountServlet;
import org.tron.core.services.http.GetMarketOrderByIdServlet;
import org.tron.core.services.http.GetMarketOrderListByPairServlet;
import org.tron.core.services.http.GetMarketPairListServlet;
import org.tron.core.services.http.GetMarketPriceByPairServlet;
import org.tron.core.services.http.GetMemoFeePricesServlet;
import org.tron.core.services.http.GetMerkleTreeVoucherInfoServlet;
import org.tron.core.services.http.GetNewShieldedAddressServlet;
import org.tron.core.services.http.GetNextMaintenanceTimeServlet;
import org.tron.core.services.http.GetNkFromNskServlet;
import org.tron.core.services.http.GetNodeInfoServlet;
import org.tron.core.services.http.GetNowBlockServlet;
import org.tron.core.services.http.GetPaginatedAssetIssueListServlet;
import org.tron.core.services.http.GetPaginatedExchangeListServlet;
import org.tron.core.services.http.GetPaginatedProposalListServlet;
import org.tron.core.services.http.GetPendingSizeServlet;
import org.tron.core.services.http.GetProposalByIdServlet;
import org.tron.core.services.http.GetRcmServlet;
import org.tron.core.services.http.GetRewardServlet;
import org.tron.core.services.http.GetShieldTransactionHashServlet;
import org.tron.core.services.http.GetSpendingKeyServlet;
import org.tron.core.services.http.GetTransactionApprovedListServlet;
import org.tron.core.services.http.GetTransactionByIdServlet;
import org.tron.core.services.http.GetTransactionCountByBlockNumServlet;
import org.tron.core.services.http.GetTransactionFromPendingServlet;
import org.tron.core.services.http.GetTransactionInfoByBlockNumServlet;
import org.tron.core.services.http.GetTransactionInfoByIdServlet;
import org.tron.core.services.http.GetTransactionListFromPendingServlet;
import org.tron.core.services.http.GetTransactionReceiptByIdServlet;
import org.tron.core.services.http.GetTransactionSignWeightServlet;
import org.tron.core.services.http.GetTriggerInputForShieldedTRC20ContractServlet;
import org.tron.core.services.http.GetZenPaymentAddressServlet;
import org.tron.core.services.http.IsShieldedTRC20ContractNoteSpentServlet;
import org.tron.core.services.http.IsSpendServlet;
import org.tron.core.services.http.ListExchangesServlet;
import org.tron.core.services.http.ListNodesServlet;
import org.tron.core.services.http.ListProposalsServlet;
import org.tron.core.services.http.ListWitnessesServlet;
import org.tron.core.services.http.MarketCancelOrderServlet;
import org.tron.core.services.http.MarketSellAssetServlet;
import org.tron.core.services.http.MetricsServlet;
import org.tron.core.services.http.ParticipateAssetIssueServlet;
import org.tron.core.services.http.ProposalApproveServlet;
import org.tron.core.services.http.ProposalCreateServlet;
import org.tron.core.services.http.ProposalDeleteServlet;
import org.tron.core.services.http.ScanAndMarkNoteByIvkServlet;
import org.tron.core.services.http.ScanNoteByIvkServlet;
import org.tron.core.services.http.ScanNoteByOvkServlet;
import org.tron.core.services.http.ScanShieldedTRC20NotesByIvkServlet;
import org.tron.core.services.http.ScanShieldedTRC20NotesByOvkServlet;
import org.tron.core.services.http.SetAccountIdServlet;
import org.tron.core.services.http.TotalTransactionServlet;
import org.tron.core.services.http.TransferAssetServlet;
import org.tron.core.services.http.TransferServlet;
import org.tron.core.services.http.TriggerConstantContractServlet;
import org.tron.core.services.http.TriggerSmartContractServlet;
import org.tron.core.services.http.UnDelegateResourceServlet;
import org.tron.core.services.http.UnFreezeAssetServlet;
import org.tron.core.services.http.UnFreezeBalanceServlet;
import org.tron.core.services.http.UnFreezeBalanceV2Servlet;
import org.tron.core.services.http.UpdateAccountServlet;
import org.tron.core.services.http.UpdateAssetServlet;
import org.tron.core.services.http.UpdateBrokerageServlet;
import org.tron.core.services.http.UpdateEnergyLimitServlet;
import org.tron.core.services.http.UpdateSettingServlet;
import org.tron.core.services.http.UpdateWitnessServlet;
import org.tron.core.services.http.ValidateAddressServlet;
import org.tron.core.services.http.VoteWitnessAccountServlet;
import org.tron.core.services.http.WithdrawBalanceServlet;
import org.tron.core.services.http.WithdrawExpireUnfreezeServlet;

@Component
public class FullNodeHttpApiService
implements Service {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    private int port = Args.getInstance().getFullNodeHttpPort();
    private Server server;
    @Autowired
    private GetAccountServlet getAccountServlet;
    @Autowired
    private TransferServlet transferServlet;
    @Autowired
    private BroadcastServlet broadcastServlet;
    @Autowired
    private UpdateAccountServlet updateAccountServlet;
    @Autowired
    private VoteWitnessAccountServlet voteWitnessAccountServlet;
    @Autowired
    private CreateAssetIssueServlet createAssetIssueServlet;
    @Autowired
    private UpdateWitnessServlet updateWitnessServlet;
    @Autowired
    private CreateAccountServlet createAccountServlet;
    @Autowired
    private CreateWitnessServlet createWitnessServlet;
    @Autowired
    private TransferAssetServlet transferAssetServlet;
    @Autowired
    private ParticipateAssetIssueServlet participateAssetIssueServlet;
    @Autowired
    private FreezeBalanceServlet freezeBalanceServlet;
    @Autowired
    private UnFreezeBalanceServlet unFreezeBalanceServlet;
    @Autowired
    private UnFreezeAssetServlet unFreezeAssetServlet;
    @Autowired
    private WithdrawBalanceServlet withdrawBalanceServlet;
    @Autowired
    private UpdateAssetServlet updateAssetServlet;
    @Autowired
    private ListNodesServlet listNodesServlet;
    @Autowired
    private GetAssetIssueByAccountServlet getAssetIssueByAccountServlet;
    @Autowired
    private GetAccountNetServlet getAccountNetServlet;
    @Autowired
    private GetAssetIssueByNameServlet getAssetIssueByNameServlet;
    @Autowired
    private GetAssetIssueListByNameServlet getAssetIssueListByNameServlet;
    @Autowired
    private GetAssetIssueByIdServlet getAssetIssueByIdServlet;
    @Autowired
    private GetNowBlockServlet getNowBlockServlet;
    @Autowired
    private GetBlockByNumServlet getBlockByNumServlet;
    @Autowired
    private GetBlockByIdServlet getBlockByIdServlet;
    @Autowired
    private GetBlockByLimitNextServlet getBlockByLimitNextServlet;
    @Autowired
    private GetBlockByLatestNumServlet getBlockByLatestNumServlet;
    @Autowired
    private GetTransactionByIdServlet getTransactionByIdServlet;
    @Autowired
    private GetTransactionInfoByIdServlet getTransactionInfoByIdServlet;
    @Autowired
    private GetTransactionReceiptByIdServlet getTransactionReceiptByIdServlet;
    @Autowired
    private GetTransactionCountByBlockNumServlet getTransactionCountByBlockNumServlet;
    @Autowired
    private ListWitnessesServlet listWitnessesServlet;
    @Autowired
    private GetAssetIssueListServlet getAssetIssueListServlet;
    @Autowired
    private GetPaginatedAssetIssueListServlet getPaginatedAssetIssueListServlet;
    @Autowired
    private GetPaginatedProposalListServlet getPaginatedProposalListServlet;
    @Autowired
    private GetPaginatedExchangeListServlet getPaginatedExchangeListServlet;
    @Autowired
    private TotalTransactionServlet totalTransactionServlet;
    @Autowired
    private GetNextMaintenanceTimeServlet getNextMaintenanceTimeServlet;
    @Autowired
    private ValidateAddressServlet validateAddressServlet;
    @Autowired
    private DeployContractServlet deployContractServlet;
    @Autowired
    private TriggerSmartContractServlet triggerSmartContractServlet;
    @Autowired
    private TriggerConstantContractServlet triggerConstantContractServlet;
    @Autowired
    private EstimateEnergyServlet estimateEnergyServlet;
    @Autowired
    private GetContractServlet getContractServlet;
    @Autowired
    private GetContractInfoServlet getContractInfoServlet;
    @Autowired
    private ClearABIServlet clearABIServlet;
    @Autowired
    private ProposalCreateServlet proposalCreateServlet;
    @Autowired
    private ProposalApproveServlet proposalApproveServlet;
    @Autowired
    private ProposalDeleteServlet proposalDeleteServlet;
    @Autowired
    private ListProposalsServlet listProposalsServlet;
    @Autowired
    private GetProposalByIdServlet getProposalByIdServlet;
    @Autowired
    private ExchangeCreateServlet exchangeCreateServlet;
    @Autowired
    private ExchangeInjectServlet exchangeInjectServlet;
    @Autowired
    private ExchangeTransactionServlet exchangeTransactionServlet;
    @Autowired
    private ExchangeWithdrawServlet exchangeWithdrawServlet;
    @Autowired
    private GetExchangeByIdServlet getExchangeByIdServlet;
    @Autowired
    private ListExchangesServlet listExchangesServlet;
    @Autowired
    private GetChainParametersServlet getChainParametersServlet;
    @Autowired
    private GetAccountResourceServlet getAccountResourceServlet;
    @Autowired
    private GetNodeInfoServlet getNodeInfoServlet;
    @Autowired
    private GetTransactionSignWeightServlet getTransactionSignWeightServlet;
    @Autowired
    private GetTransactionApprovedListServlet getTransactionApprovedListServlet;
    @Autowired
    private AccountPermissionUpdateServlet accountPermissionUpdateServlet;
    @Autowired
    private UpdateSettingServlet updateSettingServlet;
    @Autowired
    private UpdateEnergyLimitServlet updateEnergyLimitServlet;
    @Autowired
    private GetDelegatedResourceAccountIndexServlet getDelegatedResourceAccountIndexServlet;
    @Autowired
    private GetDelegatedResourceAccountIndexV2Servlet getDelegatedResourceAccountIndexV2Servlet;
    @Autowired
    private GetDelegatedResourceServlet getDelegatedResourceServlet;
    @Autowired
    private GetDelegatedResourceV2Servlet getDelegatedResourceV2Servlet;
    @Autowired
    private GetCanDelegatedMaxSizeServlet getCanDelegatedMaxSizeServlet;
    @Autowired
    private GetAvailableUnfreezeCountServlet getAvailableUnfreezeCountServlet;
    @Autowired
    private GetCanWithdrawUnfreezeAmountServlet getCanWithdrawUnfreezeAmountServlet;
    @Autowired
    private SetAccountIdServlet setAccountServlet;
    @Autowired
    private GetAccountByIdServlet getAccountByIdServlet;
    @Autowired
    private GetExpandedSpendingKeyServlet getExpandedSpendingKeyServlet;
    @Autowired
    private GetAkFromAskServlet getAkFromAskServlet;
    @Autowired
    private GetNkFromNskServlet getNkFromNskServlet;
    @Autowired
    private GetSpendingKeyServlet getSpendingKeyServlet;
    @Autowired
    private GetNewShieldedAddressServlet getNewShieldedAddressServlet;
    @Autowired
    private GetDiversifierServlet getDiversifierServlet;
    @Autowired
    private GetIncomingViewingKeyServlet getIncomingViewingKeyServlet;
    @Autowired
    private GetZenPaymentAddressServlet getZenPaymentAddressServlet;
    @Autowired
    private CreateShieldedTransactionServlet createShieldedTransactionServlet;
    @Autowired
    private ScanNoteByIvkServlet scanNoteByIvkServlet;
    @Autowired
    private ScanAndMarkNoteByIvkServlet scanAndMarkNoteByIvkServlet;
    @Autowired
    private ScanNoteByOvkServlet scanNoteByOvkServlet;
    @Autowired
    private GetRcmServlet getRcmServlet;
    @Autowired
    private CreateSpendAuthSigServlet createSpendAuthSigServlet;
    @Autowired
    private CreateShieldNullifierServlet createShieldNullifierServlet;
    @Autowired
    private GetShieldTransactionHashServlet getShieldTransactionHashServlet;
    @Autowired
    private GetMerkleTreeVoucherInfoServlet getMerkleTreeVoucherInfoServlet;
    @Autowired
    private IsSpendServlet isSpendServlet;
    @Autowired
    private CreateShieldedTransactionWithoutSpendAuthSigServlet createShieldedTransactionWithoutSpendAuthSigServlet;
    @Autowired
    private BroadcastHexServlet broadcastHexServlet;
    @Autowired
    private GetBurnTrxServlet getBurnTrxServlet;
    @Autowired
    private GetBrokerageServlet getBrokerageServlet;
    @Autowired
    private GetRewardServlet getRewardServlet;
    @Autowired
    private UpdateBrokerageServlet updateBrokerageServlet;
    @Autowired
    private CreateCommonTransactionServlet createCommonTransactionServlet;
    @Autowired
    private GetTransactionInfoByBlockNumServlet getTransactionInfoByBlockNumServlet;
    @Autowired
    private IsShieldedTRC20ContractNoteSpentServlet isShieldedTRC20ContractNoteSpentServlet;
    @Autowired
    private CreateShieldedContractParametersServlet createShieldedContractParametersServlet;
    @Autowired
    private CreateShieldedContractParametersWithoutAskServlet createShieldedContractParametersWithoutAskServlet;
    @Autowired
    private ScanShieldedTRC20NotesByIvkServlet scanShieldedTRC20NotesByIvkServlet;
    @Autowired
    private ScanShieldedTRC20NotesByOvkServlet scanShieldedTRC20NotesByOvkServlet;
    @Autowired
    private GetTriggerInputForShieldedTRC20ContractServlet getTriggerInputForShieldedTRC20ContractServlet;
    @Autowired
    private MetricsServlet metricsServlet;
    @Autowired
    private MarketSellAssetServlet marketSellAssetServlet;
    @Autowired
    private MarketCancelOrderServlet marketCancelOrderServlet;
    @Autowired
    private GetMarketOrderByAccountServlet getMarketOrderByAccountServlet;
    @Autowired
    private GetMarketOrderByIdServlet getMarketOrderByIdServlet;
    @Autowired
    private GetMarketPriceByPairServlet getMarketPriceByPairServlet;
    @Autowired
    private GetMarketOrderListByPairServlet getMarketOrderListByPairServlet;
    @Autowired
    private GetMarketPairListServlet getMarketPairListServlet;
    @Autowired
    private GetAccountBalanceServlet getAccountBalanceServlet;
    @Autowired
    private GetBlockBalanceServlet getBlockBalanceServlet;
    @Autowired
    private LiteFnQueryHttpFilter liteFnQueryHttpFilter;
    @Autowired
    private HttpApiAccessFilter httpApiAccessFilter;
    @Autowired
    private GetTransactionFromPendingServlet getTransactionFromPendingServlet;
    @Autowired
    private GetTransactionListFromPendingServlet getTransactionListFromPendingServlet;
    @Autowired
    private GetPendingSizeServlet getPendingSizeServlet;
    @Autowired
    private GetEnergyPricesServlet getEnergyPricesServlet;
    @Autowired
    private GetBandwidthPricesServlet getBandwidthPricesServlet;
    @Autowired
    private GetBlockServlet getBlockServlet;
    @Autowired
    private GetMemoFeePricesServlet getMemoFeePricesServlet;
    @Autowired
    private FreezeBalanceV2Servlet freezeBalanceV2Servlet;
    @Autowired
    private UnFreezeBalanceV2Servlet unFreezeBalanceV2Servlet;
    @Autowired
    private WithdrawExpireUnfreezeServlet withdrawExpireUnfreezeServlet;
    @Autowired
    private DelegateResourceServlet delegateResourceServlet;
    @Autowired
    private UnDelegateResourceServlet unDelegateResourceServlet;
    @Autowired
    private CancelAllUnfreezeV2Servlet cancelAllUnfreezeV2Servlet;

    private static String getParamsFile(String fileName) {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("params" + File.separator + fileName);
        File fileOut = new File(System.getProperty("java.io.tmpdir") + File.separator + fileName + "." + System.currentTimeMillis());
        try {
            FileUtils.copyToFile((InputStream)in, (File)fileOut);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return fileOut.getAbsolutePath();
    }

    public static void librustzcashInitZksnarkParams() {
        logger.info("init zk param begin");
        if (!JLibrustzcash.isOpenZen()) {
            logger.info("zen switch is off, zen will not start.");
            return;
        }
        String spendPath = FullNodeHttpApiService.getParamsFile("sapling-spend.params");
        String spendHash = "25fd9a0d1c1be0526c14662947ae95b758fe9f3d7fb7f55e9b4437830dcc6215a7ce3ea465914b157715b7a4d681389ea4aa84438190e185d5e4c93574d3a19a";
        String outputPath = FullNodeHttpApiService.getParamsFile("sapling-output.params");
        String outputHash = "a1cb23b93256adce5bce2cb09cefbc96a1d16572675ceb691e9a3626ec15b5b546926ff1c536cfe3a9df07d796b32fdfc3e5d99d65567257bf286cd2858d71a6";
        try {
            JLibrustzcash.librustzcashInitZksnarkParams((LibrustzcashParam.InitZksnarkParams)new LibrustzcashParam.InitZksnarkParams(spendPath, spendHash, outputPath, outputHash));
        }
        catch (ZksnarkException e) {
            logger.error("librustzcashInitZksnarkParams fail!", (Throwable)e);
        }
        logger.info("init zk param done");
    }

    @Override
    public void init() {
    }

    @Override
    public void init(CommonParameter args) {
        FullNodeHttpApiService.librustzcashInitZksnarkParams();
    }

    @Override
    public void start() {
        try {
            this.server = new Server(this.port);
            ServletContextHandler context = new ServletContextHandler(1);
            context.setContextPath("/");
            this.server.setHandler((Handler)context);
            context.addServlet(new ServletHolder((Servlet)this.getAccountServlet), "/wallet/getaccount");
            context.addServlet(new ServletHolder((Servlet)this.transferServlet), "/wallet/createtransaction");
            context.addServlet(new ServletHolder((Servlet)this.broadcastServlet), "/wallet/broadcasttransaction");
            context.addServlet(new ServletHolder((Servlet)this.updateAccountServlet), "/wallet/updateaccount");
            context.addServlet(new ServletHolder((Servlet)this.voteWitnessAccountServlet), "/wallet/votewitnessaccount");
            context.addServlet(new ServletHolder((Servlet)this.createAssetIssueServlet), "/wallet/createassetissue");
            context.addServlet(new ServletHolder((Servlet)this.updateWitnessServlet), "/wallet/updatewitness");
            context.addServlet(new ServletHolder((Servlet)this.createAccountServlet), "/wallet/createaccount");
            context.addServlet(new ServletHolder((Servlet)this.createWitnessServlet), "/wallet/createwitness");
            context.addServlet(new ServletHolder((Servlet)this.transferAssetServlet), "/wallet/transferasset");
            context.addServlet(new ServletHolder((Servlet)this.participateAssetIssueServlet), "/wallet/participateassetissue");
            context.addServlet(new ServletHolder((Servlet)this.freezeBalanceServlet), "/wallet/freezebalance");
            context.addServlet(new ServletHolder((Servlet)this.unFreezeBalanceServlet), "/wallet/unfreezebalance");
            context.addServlet(new ServletHolder((Servlet)this.unFreezeAssetServlet), "/wallet/unfreezeasset");
            context.addServlet(new ServletHolder((Servlet)this.withdrawBalanceServlet), "/wallet/withdrawbalance");
            context.addServlet(new ServletHolder((Servlet)this.updateAssetServlet), "/wallet/updateasset");
            context.addServlet(new ServletHolder((Servlet)this.listNodesServlet), "/wallet/listnodes");
            context.addServlet(new ServletHolder((Servlet)this.getAssetIssueByAccountServlet), "/wallet/getassetissuebyaccount");
            context.addServlet(new ServletHolder((Servlet)this.getAccountNetServlet), "/wallet/getaccountnet");
            context.addServlet(new ServletHolder((Servlet)this.getAssetIssueByNameServlet), "/wallet/getassetissuebyname");
            context.addServlet(new ServletHolder((Servlet)this.getAssetIssueListByNameServlet), "/wallet/getassetissuelistbyname");
            context.addServlet(new ServletHolder((Servlet)this.getAssetIssueByIdServlet), "/wallet/getassetissuebyid");
            context.addServlet(new ServletHolder((Servlet)this.getNowBlockServlet), "/wallet/getnowblock");
            context.addServlet(new ServletHolder((Servlet)this.getBlockByNumServlet), "/wallet/getblockbynum");
            context.addServlet(new ServletHolder((Servlet)this.getBlockByIdServlet), "/wallet/getblockbyid");
            context.addServlet(new ServletHolder((Servlet)this.getBlockByLimitNextServlet), "/wallet/getblockbylimitnext");
            context.addServlet(new ServletHolder((Servlet)this.getBlockByLatestNumServlet), "/wallet/getblockbylatestnum");
            context.addServlet(new ServletHolder((Servlet)this.getTransactionByIdServlet), "/wallet/gettransactionbyid");
            context.addServlet(new ServletHolder((Servlet)this.getTransactionInfoByIdServlet), "/wallet/gettransactioninfobyid");
            context.addServlet(new ServletHolder((Servlet)this.getTransactionReceiptByIdServlet), "/wallet/gettransactionreceiptbyid");
            context.addServlet(new ServletHolder((Servlet)this.getTransactionCountByBlockNumServlet), "/wallet/gettransactioncountbyblocknum");
            context.addServlet(new ServletHolder((Servlet)this.listWitnessesServlet), "/wallet/listwitnesses");
            context.addServlet(new ServletHolder((Servlet)this.getAssetIssueListServlet), "/wallet/getassetissuelist");
            context.addServlet(new ServletHolder((Servlet)this.getPaginatedAssetIssueListServlet), "/wallet/getpaginatedassetissuelist");
            context.addServlet(new ServletHolder((Servlet)this.getPaginatedProposalListServlet), "/wallet/getpaginatedproposallist");
            context.addServlet(new ServletHolder((Servlet)this.getPaginatedExchangeListServlet), "/wallet/getpaginatedexchangelist");
            context.addServlet(new ServletHolder((Servlet)this.totalTransactionServlet), "/wallet/totaltransaction");
            context.addServlet(new ServletHolder((Servlet)this.getNextMaintenanceTimeServlet), "/wallet/getnextmaintenancetime");
            context.addServlet(new ServletHolder((Servlet)this.validateAddressServlet), "/wallet/validateaddress");
            context.addServlet(new ServletHolder((Servlet)this.deployContractServlet), "/wallet/deploycontract");
            context.addServlet(new ServletHolder((Servlet)this.triggerSmartContractServlet), "/wallet/triggersmartcontract");
            context.addServlet(new ServletHolder((Servlet)this.triggerConstantContractServlet), "/wallet/triggerconstantcontract");
            context.addServlet(new ServletHolder((Servlet)this.estimateEnergyServlet), "/wallet/estimateenergy");
            context.addServlet(new ServletHolder((Servlet)this.getContractServlet), "/wallet/getcontract");
            context.addServlet(new ServletHolder((Servlet)this.getContractInfoServlet), "/wallet/getcontractinfo");
            context.addServlet(new ServletHolder((Servlet)this.clearABIServlet), "/wallet/clearabi");
            context.addServlet(new ServletHolder((Servlet)this.proposalCreateServlet), "/wallet/proposalcreate");
            context.addServlet(new ServletHolder((Servlet)this.proposalApproveServlet), "/wallet/proposalapprove");
            context.addServlet(new ServletHolder((Servlet)this.proposalDeleteServlet), "/wallet/proposaldelete");
            context.addServlet(new ServletHolder((Servlet)this.listProposalsServlet), "/wallet/listproposals");
            context.addServlet(new ServletHolder((Servlet)this.getProposalByIdServlet), "/wallet/getproposalbyid");
            context.addServlet(new ServletHolder((Servlet)this.exchangeCreateServlet), "/wallet/exchangecreate");
            context.addServlet(new ServletHolder((Servlet)this.exchangeInjectServlet), "/wallet/exchangeinject");
            context.addServlet(new ServletHolder((Servlet)this.exchangeTransactionServlet), "/wallet/exchangetransaction");
            context.addServlet(new ServletHolder((Servlet)this.exchangeWithdrawServlet), "/wallet/exchangewithdraw");
            context.addServlet(new ServletHolder((Servlet)this.getExchangeByIdServlet), "/wallet/getexchangebyid");
            context.addServlet(new ServletHolder((Servlet)this.listExchangesServlet), "/wallet/listexchanges");
            context.addServlet(new ServletHolder((Servlet)this.getChainParametersServlet), "/wallet/getchainparameters");
            context.addServlet(new ServletHolder((Servlet)this.getAccountResourceServlet), "/wallet/getaccountresource");
            context.addServlet(new ServletHolder((Servlet)this.getTransactionSignWeightServlet), "/wallet/getsignweight");
            context.addServlet(new ServletHolder((Servlet)this.getTransactionApprovedListServlet), "/wallet/getapprovedlist");
            context.addServlet(new ServletHolder((Servlet)this.accountPermissionUpdateServlet), "/wallet/accountpermissionupdate");
            context.addServlet(new ServletHolder((Servlet)this.getNodeInfoServlet), "/wallet/getnodeinfo");
            context.addServlet(new ServletHolder((Servlet)this.updateSettingServlet), "/wallet/updatesetting");
            context.addServlet(new ServletHolder((Servlet)this.updateEnergyLimitServlet), "/wallet/updateenergylimit");
            context.addServlet(new ServletHolder((Servlet)this.getDelegatedResourceServlet), "/wallet/getdelegatedresource");
            context.addServlet(new ServletHolder((Servlet)this.getDelegatedResourceV2Servlet), "/wallet/getdelegatedresourcev2");
            context.addServlet(new ServletHolder((Servlet)this.getCanDelegatedMaxSizeServlet), "/wallet/getcandelegatedmaxsize");
            context.addServlet(new ServletHolder((Servlet)this.getAvailableUnfreezeCountServlet), "/wallet/getavailableunfreezecount");
            context.addServlet(new ServletHolder((Servlet)this.getCanWithdrawUnfreezeAmountServlet), "/wallet/getcanwithdrawunfreezeamount");
            context.addServlet(new ServletHolder((Servlet)this.getDelegatedResourceAccountIndexServlet), "/wallet/getdelegatedresourceaccountindex");
            context.addServlet(new ServletHolder((Servlet)this.getDelegatedResourceAccountIndexV2Servlet), "/wallet/getdelegatedresourceaccountindexv2");
            context.addServlet(new ServletHolder((Servlet)this.setAccountServlet), "/wallet/setaccountid");
            context.addServlet(new ServletHolder((Servlet)this.getAccountByIdServlet), "/wallet/getaccountbyid");
            context.addServlet(new ServletHolder((Servlet)this.getExpandedSpendingKeyServlet), "/wallet/getexpandedspendingkey");
            context.addServlet(new ServletHolder((Servlet)this.getAkFromAskServlet), "/wallet/getakfromask");
            context.addServlet(new ServletHolder((Servlet)this.getNkFromNskServlet), "/wallet/getnkfromnsk");
            context.addServlet(new ServletHolder((Servlet)this.getSpendingKeyServlet), "/wallet/getspendingkey");
            context.addServlet(new ServletHolder((Servlet)this.getNewShieldedAddressServlet), "/wallet/getnewshieldedaddress");
            context.addServlet(new ServletHolder((Servlet)this.getDiversifierServlet), "/wallet/getdiversifier");
            context.addServlet(new ServletHolder((Servlet)this.getIncomingViewingKeyServlet), "/wallet/getincomingviewingkey");
            context.addServlet(new ServletHolder((Servlet)this.getZenPaymentAddressServlet), "/wallet/getzenpaymentaddress");
            context.addServlet(new ServletHolder((Servlet)this.getRcmServlet), "/wallet/getrcm");
            context.addServlet(new ServletHolder((Servlet)this.createSpendAuthSigServlet), "/wallet/createspendauthsig");
            context.addServlet(new ServletHolder((Servlet)this.isShieldedTRC20ContractNoteSpentServlet), "/wallet/isshieldedtrc20contractnotespent");
            context.addServlet(new ServletHolder((Servlet)this.createShieldedContractParametersServlet), "/wallet/createshieldedcontractparameters");
            context.addServlet(new ServletHolder((Servlet)this.createShieldedContractParametersWithoutAskServlet), "/wallet/createshieldedcontractparameterswithoutask");
            context.addServlet(new ServletHolder((Servlet)this.scanShieldedTRC20NotesByIvkServlet), "/wallet/scanshieldedtrc20notesbyivk");
            context.addServlet(new ServletHolder((Servlet)this.scanShieldedTRC20NotesByOvkServlet), "/wallet/scanshieldedtrc20notesbyovk");
            context.addServlet(new ServletHolder((Servlet)this.getTriggerInputForShieldedTRC20ContractServlet), "/wallet/gettriggerinputforshieldedtrc20contract");
            context.addServlet(new ServletHolder((Servlet)this.broadcastHexServlet), "/wallet/broadcasthex");
            context.addServlet(new ServletHolder((Servlet)this.getBrokerageServlet), "/wallet/getBrokerage");
            context.addServlet(new ServletHolder((Servlet)this.getRewardServlet), "/wallet/getReward");
            context.addServlet(new ServletHolder((Servlet)this.updateBrokerageServlet), "/wallet/updateBrokerage");
            context.addServlet(new ServletHolder((Servlet)this.createCommonTransactionServlet), "/wallet/createCommonTransaction");
            context.addServlet(new ServletHolder((Servlet)this.getTransactionInfoByBlockNumServlet), "/wallet/gettransactioninfobyblocknum");
            context.addServlet(new ServletHolder((Servlet)this.listNodesServlet), "/net/listnodes");
            context.addServlet(new ServletHolder((Servlet)this.metricsServlet), "/monitor/getstatsinfo");
            context.addServlet(new ServletHolder((Servlet)this.getNodeInfoServlet), "/monitor/getnodeinfo");
            context.addServlet(new ServletHolder((Servlet)this.marketSellAssetServlet), "/wallet/marketsellasset");
            context.addServlet(new ServletHolder((Servlet)this.marketCancelOrderServlet), "/wallet/marketcancelorder");
            context.addServlet(new ServletHolder((Servlet)this.getMarketOrderByAccountServlet), "/wallet/getmarketorderbyaccount");
            context.addServlet(new ServletHolder((Servlet)this.getMarketOrderByIdServlet), "/wallet/getmarketorderbyid");
            context.addServlet(new ServletHolder((Servlet)this.getMarketPriceByPairServlet), "/wallet/getmarketpricebypair");
            context.addServlet(new ServletHolder((Servlet)this.getMarketOrderListByPairServlet), "/wallet/getmarketorderlistbypair");
            context.addServlet(new ServletHolder((Servlet)this.getMarketPairListServlet), "/wallet/getmarketpairlist");
            context.addServlet(new ServletHolder((Servlet)this.getAccountBalanceServlet), "/wallet/getaccountbalance");
            context.addServlet(new ServletHolder((Servlet)this.getBlockBalanceServlet), "/wallet/getblockbalance");
            context.addServlet(new ServletHolder((Servlet)this.getBurnTrxServlet), "/wallet/getburntrx");
            context.addServlet(new ServletHolder((Servlet)this.getTransactionFromPendingServlet), "/wallet/gettransactionfrompending");
            context.addServlet(new ServletHolder((Servlet)this.getTransactionListFromPendingServlet), "/wallet/gettransactionlistfrompending");
            context.addServlet(new ServletHolder((Servlet)this.getPendingSizeServlet), "/wallet/getpendingsize");
            context.addServlet(new ServletHolder((Servlet)this.getEnergyPricesServlet), "/wallet/getenergyprices");
            context.addServlet(new ServletHolder((Servlet)this.getBandwidthPricesServlet), "/wallet/getbandwidthprices");
            context.addServlet(new ServletHolder((Servlet)this.getBlockServlet), "/wallet/getblock");
            context.addServlet(new ServletHolder((Servlet)this.getMemoFeePricesServlet), "/wallet/getmemofee");
            context.addServlet(new ServletHolder((Servlet)this.freezeBalanceV2Servlet), "/wallet/freezebalancev2");
            context.addServlet(new ServletHolder((Servlet)this.unFreezeBalanceV2Servlet), "/wallet/unfreezebalancev2");
            context.addServlet(new ServletHolder((Servlet)this.withdrawExpireUnfreezeServlet), "/wallet/withdrawexpireunfreeze");
            context.addServlet(new ServletHolder((Servlet)this.delegateResourceServlet), "/wallet/delegateresource");
            context.addServlet(new ServletHolder((Servlet)this.unDelegateResourceServlet), "/wallet/undelegateresource");
            context.addServlet(new ServletHolder((Servlet)this.cancelAllUnfreezeV2Servlet), "/wallet/cancelallunfreezev2");
            int maxHttpConnectNumber = Args.getInstance().getMaxHttpConnectNumber();
            if (maxHttpConnectNumber > 0) {
                this.server.addBean((Object)new ConnectionLimit(maxHttpConnectNumber, this.server));
            }
            context.addFilter(new FilterHolder((Filter)this.liteFnQueryHttpFilter), "/*", EnumSet.allOf(DispatcherType.class));
            context.addFilter(new FilterHolder((Filter)this.httpApiAccessFilter), "/*", EnumSet.allOf(DispatcherType.class));
            context.getServletHandler().getFilterMappings()[1].setPathSpecs(new String[]{"/wallet/*", "/net/listnodes", "/monitor/getstatsinfo", "/monitor/getnodeinfo"});
            ServletHandler handler = new ServletHandler();
            FilterHolder fh = handler.addFilterWithMapping(HttpInterceptor.class, "/*", EnumSet.of(DispatcherType.REQUEST));
            context.addFilter(fh, "/*", EnumSet.of(DispatcherType.REQUEST));
            this.server.start();
        }
        catch (Exception e) {
            logger.debug("IOException: {}", (Object)e.getMessage());
        }
    }

    @Override
    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            logger.debug("IOException: {}", (Object)e.getMessage());
        }
    }
}

