/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Strings;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.utils.ByteArray;
import org.tron.core.Wallet;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.PostParams;
import org.tron.core.services.http.RateLimiterServlet;
import org.tron.core.services.http.Util;
import org.tron.protos.Protocol;
import org.tron.protos.contract.SmartContractOuterClass;

@Component
public class DeployContractServlet
extends RateLimiterServlet {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    @Autowired
    private Wallet wallet;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            String name;
            byte[] byteCode;
            PostParams params = PostParams.getPostParams(request);
            SmartContractOuterClass.CreateSmartContract.Builder build = SmartContractOuterClass.CreateSmartContract.newBuilder();
            JSONObject jsonObject = JSONObject.parseObject((String)params.getParams());
            String owner_address = jsonObject.getString("owner_address");
            if (params.isVisible()) {
                owner_address = Util.getHexAddress(owner_address);
            }
            byte[] ownerAddress = ByteArray.fromHexString((String)owner_address);
            build.setOwnerAddress(ByteString.copyFrom((byte[])ownerAddress));
            build.setCallTokenValue(Util.getJsonLongValue(jsonObject, "call_token_value")).setTokenId(Util.getJsonLongValue(jsonObject, "token_id"));
            SmartContractOuterClass.SmartContract.ABI.Builder abiBuilder = SmartContractOuterClass.SmartContract.ABI.newBuilder();
            if (jsonObject.containsKey((Object)"abi")) {
                String abi = jsonObject.getString("abi");
                StringBuffer abiSB = new StringBuffer("{");
                abiSB.append("\"entrys\":");
                abiSB.append(abi);
                abiSB.append("}");
                JsonFormat.merge(abiSB.toString(), (Message.Builder)abiBuilder, params.isVisible());
            }
            SmartContractOuterClass.SmartContract.Builder smartBuilder = SmartContractOuterClass.SmartContract.newBuilder();
            smartBuilder.setAbi(abiBuilder).setCallValue(Util.getJsonLongValue(jsonObject, "call_value")).setConsumeUserResourcePercent(Util.getJsonLongValue(jsonObject, "consume_user_resource_percent")).setOriginEnergyLimit(Util.getJsonLongValue(jsonObject, "origin_energy_limit"));
            if (!ArrayUtils.isEmpty((byte[])ownerAddress)) {
                smartBuilder.setOriginAddress(ByteString.copyFrom((byte[])ownerAddress));
            }
            String jsonByteCode = jsonObject.getString("bytecode");
            if (jsonObject.containsKey((Object)"parameter")) {
                jsonByteCode = jsonByteCode + jsonObject.getString("parameter");
            }
            if (!ArrayUtils.isEmpty((byte[])(byteCode = ByteArray.fromHexString((String)jsonByteCode)))) {
                smartBuilder.setBytecode(ByteString.copyFrom((byte[])byteCode));
            }
            if (!Strings.isNullOrEmpty((String)(name = jsonObject.getString("name")))) {
                smartBuilder.setName(name);
            }
            long feeLimit = Util.getJsonLongValue(jsonObject, "fee_limit");
            build.setNewContract(smartBuilder);
            Protocol.Transaction tx = this.wallet.createTransactionCapsule((Message)build.build(), Protocol.Transaction.Contract.ContractType.CreateSmartContract).getInstance();
            Protocol.Transaction.Builder txBuilder = tx.toBuilder();
            Protocol.Transaction.raw.Builder rawBuilder = tx.getRawData().toBuilder();
            rawBuilder.setFeeLimit(feeLimit);
            txBuilder.setRawData(rawBuilder);
            tx = Util.setTransactionPermissionId(jsonObject, txBuilder.build());
            response.getWriter().println(Util.printCreateTransaction(tx, params.isVisible()));
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }
}

