/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.Message;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.api.GrpcAPI;
import org.tron.core.Wallet;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.PostParams;
import org.tron.core.services.http.RateLimiterServlet;
import org.tron.core.services.http.Util;
import org.tron.protos.Protocol;

@Component
public class CreateShieldedTransactionWithoutSpendAuthSigServlet
extends RateLimiterServlet {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    @Autowired
    private Wallet wallet;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            PostParams params = PostParams.getPostParams(request);
            GrpcAPI.PrivateParametersWithoutAsk.Builder build = GrpcAPI.PrivateParametersWithoutAsk.newBuilder();
            JsonFormat.merge(params.getParams(), (Message.Builder)build, params.isVisible());
            Protocol.Transaction tx = this.wallet.createShieldedTransactionWithoutSpendAuthSig(build.build()).getInstance();
            String txString = Util.printCreateTransaction(tx, params.isVisible());
            JSONObject jsonObject = JSON.parseObject((String)txString);
            if (jsonObject.containsKey((Object)"txID")) {
                jsonObject.remove((Object)"txID");
            }
            response.getWriter().println(jsonObject.toJSONString());
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }
}

