/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.Message;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.api.GrpcAPI;
import org.tron.common.utils.ByteArray;
import org.tron.core.Wallet;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.PostParams;
import org.tron.core.services.http.RateLimiterServlet;
import org.tron.core.services.http.Util;
import org.tron.protos.Protocol;

@Component
public class BroadcastServlet
extends RateLimiterServlet {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    @Autowired
    private Wallet wallet;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            PostParams params = PostParams.getPostParams(request);
            Protocol.Transaction transaction = Util.packTransaction(params.getParams(), params.isVisible());
            TransactionCapsule transactionCapsule = new TransactionCapsule(transaction);
            String transactionID = ByteArray.toHexString((byte[])transactionCapsule.getTransactionId().getBytes());
            GrpcAPI.Return result = this.wallet.broadcastTransaction(transaction);
            JSONObject res = JSONObject.parseObject((String)JsonFormat.printToString((Message)result, params.isVisible()));
            res.put("txid", (Object)transactionID);
            response.getWriter().println(res.toJSONString());
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }
}

