/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.entity.NodeInfo;
import org.tron.common.entity.PeerInfo;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.prometheus.MetricTime;
import org.tron.core.ChainBaseManager;
import org.tron.core.db.Manager;
import org.tron.core.net.TronNetService;
import org.tron.core.net.peer.PeerConnection;
import org.tron.core.net.peer.PeerManager;
import org.tron.core.net.service.statistics.NodeStatistics;
import org.tron.core.services.WitnessProductBlockService;
import org.tron.p2p.P2pConfig;
import org.tron.p2p.P2pService;
import org.tron.p2p.connection.Channel;
import org.tron.program.Version;
import org.tron.protos.Protocol;

@Component
public class NodeInfoService {
    private MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
    private RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
    private ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    private CommonParameter parameter = CommonParameter.getInstance();
    @Autowired
    private Manager dbManager;
    @Autowired
    private ChainBaseManager chainBaseManager;
    @Autowired
    private WitnessProductBlockService witnessProductBlockService;

    @MetricTime
    public NodeInfo getNodeInfo() {
        NodeInfo nodeInfo = new NodeInfo();
        this.setConnectInfo(nodeInfo);
        this.setMachineInfo(nodeInfo);
        this.setConfigNodeInfo(nodeInfo);
        this.setBlockInfo(nodeInfo);
        this.setCheatWitnessInfo(nodeInfo);
        return nodeInfo;
    }

    private void setMachineInfo(NodeInfo nodeInfo) {
        NodeInfo.MachineInfo machineInfo = new NodeInfo.MachineInfo();
        machineInfo.setThreadCount(this.threadMXBean.getThreadCount());
        machineInfo.setCpuCount(Runtime.getRuntime().availableProcessors());
        machineInfo.setTotalMemory(this.operatingSystemMXBean.getTotalPhysicalMemorySize());
        machineInfo.setFreeMemory(this.operatingSystemMXBean.getFreePhysicalMemorySize());
        machineInfo.setCpuRate(this.operatingSystemMXBean.getSystemCpuLoad());
        machineInfo.setJavaVersion(this.runtimeMXBean.getSystemProperties().get("java.version"));
        machineInfo.setOsName(this.operatingSystemMXBean.getName() + " " + this.operatingSystemMXBean.getVersion());
        machineInfo.setJvmTotalMemory(this.memoryMXBean.getHeapMemoryUsage().getMax());
        machineInfo.setJvmFreeMemory(this.memoryMXBean.getHeapMemoryUsage().getMax() - this.memoryMXBean.getHeapMemoryUsage().getUsed());
        machineInfo.setProcessCpuRate(this.operatingSystemMXBean.getProcessCpuLoad());
        ArrayList<NodeInfo.MachineInfo.MemoryDescInfo> memoryDescInfoList = new ArrayList<NodeInfo.MachineInfo.MemoryDescInfo>();
        List<MemoryPoolMXBean> pools = ManagementFactory.getMemoryPoolMXBeans();
        if (CollectionUtils.isNotEmpty(pools)) {
            for (MemoryPoolMXBean pool : pools) {
                NodeInfo.MachineInfo.MemoryDescInfo memoryDescInfo = new NodeInfo.MachineInfo.MemoryDescInfo();
                memoryDescInfo.setName(pool.getName());
                memoryDescInfo.setInitSize(pool.getUsage().getInit());
                memoryDescInfo.setUseSize(pool.getUsage().getUsed());
                memoryDescInfo.setMaxSize(pool.getUsage().getMax());
                if (pool.getUsage().getMax() > 0L) {
                    memoryDescInfo.setUseRate((double)pool.getUsage().getUsed() / (double)pool.getUsage().getMax());
                } else {
                    memoryDescInfo.setUseRate((double)pool.getUsage().getUsed() / (double)pool.getUsage().getCommitted());
                }
                memoryDescInfoList.add(memoryDescInfo);
            }
        }
        machineInfo.setMemoryDescInfoList(memoryDescInfoList);
        long[] deadlockedIds = this.threadMXBean.findDeadlockedThreads();
        if (ArrayUtils.isNotEmpty((long[])deadlockedIds)) {
            machineInfo.setDeadLockThreadCount(deadlockedIds.length);
            ThreadInfo[] deadlockInfos = this.threadMXBean.getThreadInfo(deadlockedIds);
            ArrayList<NodeInfo.MachineInfo.DeadLockThreadInfo> deadLockThreadInfoList = new ArrayList<NodeInfo.MachineInfo.DeadLockThreadInfo>();
            for (ThreadInfo deadlockInfo : deadlockInfos) {
                NodeInfo.MachineInfo.DeadLockThreadInfo deadLockThreadInfo = new NodeInfo.MachineInfo.DeadLockThreadInfo();
                deadLockThreadInfo.setName(deadlockInfo.getThreadName());
                deadLockThreadInfo.setLockName(deadlockInfo.getLockName());
                deadLockThreadInfo.setLockOwner(deadlockInfo.getLockOwnerName());
                deadLockThreadInfo.setBlockTime(deadlockInfo.getBlockedTime());
                deadLockThreadInfo.setWaitTime(deadlockInfo.getWaitedTime());
                deadLockThreadInfo.setState(deadlockInfo.getThreadState().name());
                deadLockThreadInfo.setStackTrace(Arrays.toString(deadlockInfo.getStackTrace()));
                deadLockThreadInfoList.add(deadLockThreadInfo);
            }
            machineInfo.setDeadLockThreadInfoList(deadLockThreadInfoList);
        }
        nodeInfo.setMachineInfo(machineInfo);
    }

    private void setConnectInfo(NodeInfo nodeInfo) {
        int activeCnt = PeerManager.getActivePeersCount().get();
        int passiveCnt = PeerManager.getPassivePeersCount().get();
        nodeInfo.setCurrentConnectCount(activeCnt + passiveCnt);
        nodeInfo.setActiveConnectCount(activeCnt);
        nodeInfo.setPassiveConnectCount(passiveCnt);
        ArrayList<PeerInfo> peerInfoList = new ArrayList<PeerInfo>();
        for (PeerConnection peerConnection : PeerManager.getPeers()) {
            Channel channel = peerConnection.getChannel();
            NodeStatistics nodeStatistics = peerConnection.getNodeStatistics();
            P2pService P2pService2 = TronNetService.getP2pService();
            P2pConfig p2pConfig = TronNetService.getP2pConfig();
            PeerInfo peerInfo = new PeerInfo();
            peerInfo.setHeadBlockWeBothHave(peerConnection.getBlockBothHave().getString());
            peerInfo.setActive(peerConnection.getChannel().isActive());
            peerInfo.setAvgLatency((double)peerConnection.getChannel().getAvgLatency());
            peerInfo.setBlockInPorcSize(peerConnection.getSyncBlockInProcess().size());
            peerInfo.setConnectTime(channel.getStartTime());
            peerInfo.setDisconnectTimes(nodeStatistics.getDisconnectTimes());
            peerInfo.setHost(channel.getInetAddress().toString());
            peerInfo.setLastBlockUpdateTime(peerConnection.getBlockBothHaveUpdateTime());
            peerInfo.setLastSyncBlock(peerConnection.getLastSyncBlockId() == null ? "" : peerConnection.getLastSyncBlockId().getString());
            Protocol.ReasonCode reasonCode = nodeStatistics.getLocalDisconnectReason();
            peerInfo.setLocalDisconnectReason(reasonCode == null ? "" : reasonCode.toString());
            reasonCode = nodeStatistics.getRemoteDisconnectReason();
            peerInfo.setRemoteDisconnectReason(reasonCode == null ? "" : reasonCode.toString());
            peerInfo.setNeedSyncFromPeer(peerConnection.isNeedSyncFromPeer());
            peerInfo.setNeedSyncFromUs(peerConnection.isNeedSyncFromUs());
            int tableNodesSize = P2pService2.getTableNodes().size();
            peerInfo.setNodeCount(tableNodesSize);
            peerInfo.setNodeId(Hex.encodeHexString((byte[])p2pConfig.getNodeID()));
            peerInfo.setPort(p2pConfig.getPort());
            peerInfo.setRemainNum(peerConnection.getRemainNum());
            peerInfo.setSyncBlockRequestedSize(peerConnection.getSyncBlockRequested().size());
            peerInfo.setSyncFlag(peerConnection.isDisconnect());
            peerInfo.setSyncToFetchSize(peerConnection.getSyncBlockToFetch().size());
            peerInfo.setSyncToFetchSizePeekNum(peerConnection.getSyncBlockToFetch().size() > 0 ? peerConnection.getSyncBlockToFetch().peek().getNum() : -1L);
            peerInfo.setUnFetchSynNum(peerConnection.getRemainNum());
            peerInfoList.add(peerInfo);
        }
        nodeInfo.setPeerList(peerInfoList);
    }

    private void setConfigNodeInfo(NodeInfo nodeInfo) {
        NodeInfo.ConfigNodeInfo configNodeInfo = new NodeInfo.ConfigNodeInfo();
        configNodeInfo.setCodeVersion(Version.getVersion());
        configNodeInfo.setVersionNum("18031");
        configNodeInfo.setP2pVersion(String.valueOf(this.parameter.getNodeP2pVersion()));
        configNodeInfo.setListenPort(this.parameter.getNodeListenPort());
        configNodeInfo.setDiscoverEnable(this.parameter.isNodeDiscoveryEnable());
        configNodeInfo.setActiveNodeSize(this.parameter.getActiveNodes().size());
        configNodeInfo.setPassiveNodeSize(this.parameter.getPassiveNodes().size());
        configNodeInfo.setSendNodeSize(this.parameter.getSeedNode().getAddressList().size());
        configNodeInfo.setMaxConnectCount(this.parameter.getMaxConnections());
        configNodeInfo.setSameIpMaxConnectCount(this.parameter.getMaxConnectionsWithSameIp());
        configNodeInfo.setBackupListenPort(this.parameter.getBackupPort());
        configNodeInfo.setBackupMemberSize(this.parameter.getBackupMembers().size());
        configNodeInfo.setBackupPriority(this.parameter.getBackupPriority());
        configNodeInfo.setDbVersion(2);
        configNodeInfo.setMinParticipationRate(this.parameter.getMinParticipationRate());
        configNodeInfo.setSupportConstant(this.parameter.isSupportConstant());
        configNodeInfo.setMinTimeRatio(this.parameter.getMinTimeRatio());
        configNodeInfo.setMaxTimeRatio(this.parameter.getMaxTimeRatio());
        configNodeInfo.setAllowCreationOfContracts(this.parameter.getAllowCreationOfContracts());
        configNodeInfo.setAllowAdaptiveEnergy(this.parameter.getAllowAdaptiveEnergy());
        nodeInfo.setConfigNodeInfo(configNodeInfo);
    }

    protected void setBlockInfo(NodeInfo nodeInfo) {
        nodeInfo.setBeginSyncNum(this.dbManager.getSyncBeginNumber());
        nodeInfo.setBlock(this.chainBaseManager.getHeadBlockId().getString());
        nodeInfo.setSolidityBlock(this.chainBaseManager.getSolidBlockId().getString());
    }

    protected void setCheatWitnessInfo(NodeInfo nodeInfo) {
        for (Map.Entry<String, WitnessProductBlockService.CheatWitnessInfo> entry : this.witnessProductBlockService.queryCheatWitnessInfo().entrySet()) {
            nodeInfo.getCheatWitnessInfoMap().put(entry.getKey(), entry.getValue().toString());
        }
    }
}

