/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.net.service.statistics;

import org.tron.protos.Protocol;

public class NodeStatistics {
    private Protocol.ReasonCode remoteDisconnectReason = null;
    private Protocol.ReasonCode localDisconnectReason = null;
    private int disconnectTimes = 0;
    private long start = System.currentTimeMillis();

    public Protocol.ReasonCode getDisconnectReason() {
        if (this.localDisconnectReason != null) {
            return this.localDisconnectReason;
        }
        if (this.remoteDisconnectReason != null) {
            return this.remoteDisconnectReason;
        }
        return Protocol.ReasonCode.UNKNOWN;
    }

    public void nodeDisconnectedRemote(Protocol.ReasonCode reason) {
        this.remoteDisconnectReason = reason;
        this.notifyDisconnect();
    }

    public void nodeDisconnectedLocal(Protocol.ReasonCode reason) {
        this.localDisconnectReason = reason;
        this.notifyDisconnect();
    }

    private void notifyDisconnect() {
        ++this.disconnectTimes;
    }

    public String toString() {
        return "time:" + (System.currentTimeMillis() - this.start) + ", disconnectTimes:" + this.disconnectTimes + ", localReason:" + this.localDisconnectReason + ", remoteReason:" + this.remoteDisconnectReason;
    }

    public Protocol.ReasonCode getRemoteDisconnectReason() {
        return this.remoteDisconnectReason;
    }

    public Protocol.ReasonCode getLocalDisconnectReason() {
        return this.localDisconnectReason;
    }

    public int getDisconnectTimes() {
        return this.disconnectTimes;
    }
}

