/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.net.service.relay;

import com.google.protobuf.ByteString;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.tron.common.backup.BackupManager;
import org.tron.common.crypto.SignInterface;
import org.tron.common.crypto.SignUtils;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.Sha256Hash;
import org.tron.core.ChainBaseManager;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.config.args.Args;
import org.tron.core.db.Manager;
import org.tron.core.net.TronNetDelegate;
import org.tron.core.net.TronNetService;
import org.tron.core.net.message.adv.BlockMessage;
import org.tron.core.net.message.handshake.HelloMessage;
import org.tron.core.net.peer.Item;
import org.tron.core.net.peer.PeerConnection;
import org.tron.core.store.WitnessScheduleStore;
import org.tron.p2p.connection.Channel;
import org.tron.protos.Protocol;

@Component
public class RelayService {
    private static final Logger logger = LoggerFactory.getLogger((String)"net");
    @Autowired
    private ChainBaseManager chainBaseManager;
    @Autowired
    private TronNetDelegate tronNetDelegate;
    @Autowired
    private ApplicationContext ctx;
    private Manager manager;
    private WitnessScheduleStore witnessScheduleStore;
    private BackupManager backupManager;
    private ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private CommonParameter parameter = Args.getInstance();
    private List<InetSocketAddress> fastForwardNodes = this.parameter.getFastForwardNodes();
    private ByteString witnessAddress = ByteString.copyFrom((byte[])Args.getLocalWitnesses().getWitnessAccountAddress(CommonParameter.getInstance().isECKeyCryptoEngine()));
    private int keySize = Args.getLocalWitnesses().getPrivateKeys().size();
    private int maxFastForwardNum = Args.getInstance().getMaxFastForwardNum();

    public void init() {
        this.manager = (Manager)this.ctx.getBean(Manager.class);
        this.witnessScheduleStore = (WitnessScheduleStore)this.ctx.getBean(WitnessScheduleStore.class);
        this.backupManager = (BackupManager)this.ctx.getBean(BackupManager.class);
        logger.info("Fast forward config, isWitness: {}, keySize: {}, fastForwardNodes: {}", new Object[]{this.parameter.isWitness(), this.keySize, this.fastForwardNodes.size()});
        if (!this.parameter.isWitness() || this.keySize == 0 || this.fastForwardNodes.isEmpty()) {
            return;
        }
        this.executorService.scheduleWithFixedDelay(() -> {
            try {
                if (this.witnessScheduleStore.getActiveWitnesses().contains(this.witnessAddress) && this.backupManager.getStatus().equals((Object)BackupManager.BackupStatusEnum.MASTER)) {
                    this.connect();
                } else {
                    this.disconnect();
                }
            }
            catch (Exception e) {
                logger.info("Execute failed.", (Throwable)e);
            }
        }, 30L, 100L, TimeUnit.SECONDS);
    }

    public void close() {
        this.executorService.shutdown();
    }

    public void fillHelloMessage(HelloMessage message, Channel channel) {
        if (this.isActiveWitness()) {
            this.fastForwardNodes.forEach(address -> {
                if (address.getAddress().equals(channel.getInetAddress())) {
                    SignInterface cryptoEngine = SignUtils.fromPrivate((byte[])ByteArray.fromHexString((String)Args.getLocalWitnesses().getPrivateKey()), (boolean)Args.getInstance().isECKeyCryptoEngine());
                    ByteString sig = ByteString.copyFrom((byte[])cryptoEngine.Base64toBytes(cryptoEngine.signHash(Sha256Hash.of((boolean)CommonParameter.getInstance().isECKeyCryptoEngine(), (byte[])ByteArray.fromLong((long)message.getTimestamp())).getBytes())));
                    message.setHelloMessage(message.getHelloMessage().toBuilder().setAddress(this.witnessAddress).setSignature(sig).build());
                }
            });
        }
    }

    public boolean checkHelloMessage(HelloMessage message, Channel channel) {
        if (!this.parameter.isFastForward()) {
            return true;
        }
        Protocol.HelloMessage msg = message.getHelloMessage();
        if (msg.getAddress() == null || msg.getAddress().isEmpty()) {
            logger.info("HelloMessage from {}, address is empty.", (Object)channel.getInetAddress());
            return false;
        }
        if (!this.witnessScheduleStore.getActiveWitnesses().contains(msg.getAddress())) {
            logger.warn("HelloMessage from {}, {} is not a schedule witness.", (Object)channel.getInetAddress(), (Object)ByteArray.toHexString((byte[])msg.getAddress().toByteArray()));
            return false;
        }
        try {
            boolean flag;
            Sha256Hash hash = Sha256Hash.of((boolean)CommonParameter.getInstance().isECKeyCryptoEngine(), (byte[])ByteArray.fromLong((long)msg.getTimestamp()));
            String sig = TransactionCapsule.getBase64FromByteString((ByteString)msg.getSignature());
            byte[] sigAddress = SignUtils.signatureToAddress((byte[])hash.getBytes(), (String)sig, (boolean)Args.getInstance().isECKeyCryptoEngine());
            if (this.manager.getDynamicPropertiesStore().getAllowMultiSign() != 1L) {
                flag = Arrays.equals(sigAddress, msg.getAddress().toByteArray());
            } else {
                byte[] witnessPermissionAddress = this.manager.getAccountStore().get(msg.getAddress().toByteArray()).getWitnessPermissionAddress();
                flag = Arrays.equals(sigAddress, witnessPermissionAddress);
            }
            if (flag) {
                TronNetService.getP2pConfig().getTrustNodes().add(channel.getInetAddress());
            }
            return flag;
        }
        catch (Exception e) {
            logger.error("Check hello message failed, msg: {}, {}", new Object[]{message, channel.getInetAddress(), e});
            return false;
        }
    }

    private boolean isActiveWitness() {
        return this.parameter.isWitness() && this.keySize > 0 && this.fastForwardNodes.size() > 0 && this.witnessScheduleStore.getActiveWitnesses().contains(this.witnessAddress) && this.backupManager.getStatus().equals((Object)BackupManager.BackupStatusEnum.MASTER);
    }

    private void connect() {
        for (InetSocketAddress fastForwardNode : this.fastForwardNodes) {
            if (TronNetService.getP2pConfig().getActiveNodes().contains(fastForwardNode)) continue;
            TronNetService.getP2pConfig().getActiveNodes().add(fastForwardNode);
        }
    }

    private void disconnect() {
        this.fastForwardNodes.forEach(address -> {
            TronNetService.getP2pConfig().getActiveNodes().remove(address);
            TronNetService.getPeers().forEach(peer -> {
                if (peer.getInetAddress().equals(address.getAddress())) {
                    peer.getChannel().close();
                }
            });
        });
    }

    private Set<ByteString> getNextWitnesses(ByteString key, Integer count) {
        List list = this.chainBaseManager.getWitnessScheduleStore().getActiveWitnesses();
        int index = list.indexOf(key);
        if (index < 0) {
            return new HashSet<ByteString>(list);
        }
        HashSet<ByteString> set = new HashSet<ByteString>();
        while (count > 0) {
            set.add((ByteString)list.get(++index % list.size()));
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count - 1);
        }
        return set;
    }

    public void broadcast(BlockMessage msg) {
        Set<ByteString> witnesses = this.getNextWitnesses(msg.getBlockCapsule().getWitnessAddress(), this.maxFastForwardNum);
        Item item = new Item((Sha256Hash)msg.getBlockId(), Protocol.Inventory.InventoryType.BLOCK);
        List<PeerConnection> peers = this.tronNetDelegate.getActivePeer().stream().filter(peer -> !peer.isNeedSyncFromPeer() && !peer.isNeedSyncFromUs()).filter(peer -> peer.getAdvInvReceive().getIfPresent((Object)item) == null && peer.getAdvInvSpread().getIfPresent((Object)item) == null).filter(peer -> peer.getAddress() != null && witnesses.contains(peer.getAddress())).collect(Collectors.toList());
        peers.forEach(peer -> {
            peer.sendMessage(msg);
            peer.getAdvInvSpread().put((Object)item, (Object)System.currentTimeMillis());
            peer.setFastForwardBlock(msg.getBlockId());
        });
    }
}

