/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.net.service.handshake;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.utils.ByteArray;
import org.tron.core.ChainBaseManager;
import org.tron.core.config.args.Args;
import org.tron.core.net.TronNetService;
import org.tron.core.net.message.handshake.HelloMessage;
import org.tron.core.net.peer.PeerConnection;
import org.tron.core.net.peer.PeerManager;
import org.tron.core.net.service.effective.EffectiveCheckService;
import org.tron.core.net.service.relay.RelayService;
import org.tron.p2p.discover.Node;
import org.tron.protos.Protocol;

@Component
public class HandshakeService {
    private static final Logger logger = LoggerFactory.getLogger((String)"net");
    @Autowired
    private RelayService relayService;
    @Autowired
    private EffectiveCheckService effectiveCheckService;
    @Autowired
    private ChainBaseManager chainBaseManager;

    public void startHandshake(PeerConnection peer) {
        this.sendHelloMessage(peer, peer.getChannel().getStartTime());
    }

    public void processHelloMessage(PeerConnection peer, HelloMessage msg) {
        if (peer.getHelloMessageReceive() != null) {
            logger.warn("Peer {} receive dup hello message", (Object)peer.getInetSocketAddress());
            peer.disconnect(Protocol.ReasonCode.BAD_PROTOCOL);
            return;
        }
        TronNetService.getP2pService().updateNodeId(peer.getChannel(), msg.getFrom().getHexId());
        if (peer.isDisconnect()) {
            logger.info("Duplicate Peer {}", (Object)peer.getInetSocketAddress());
            peer.disconnect(Protocol.ReasonCode.DUPLICATE_PEER);
            return;
        }
        if (!msg.valid()) {
            logger.warn("Peer {} invalid hello message parameters, GenesisBlockId: {}, SolidBlockId: {}, HeadBlockId: {}", new Object[]{peer.getInetSocketAddress(), ByteArray.toHexString((byte[])msg.getInstance().getGenesisBlockId().getHash().toByteArray()), ByteArray.toHexString((byte[])msg.getInstance().getSolidBlockId().getHash().toByteArray()), ByteArray.toHexString((byte[])msg.getInstance().getHeadBlockId().getHash().toByteArray())});
            peer.disconnect(Protocol.ReasonCode.UNEXPECTED_IDENTITY);
            return;
        }
        peer.setAddress(msg.getHelloMessage().getAddress());
        if (!this.relayService.checkHelloMessage(msg, peer.getChannel())) {
            peer.disconnect(Protocol.ReasonCode.UNEXPECTED_IDENTITY);
            return;
        }
        long headBlockNum = this.chainBaseManager.getHeadBlockNum();
        long lowestBlockNum = msg.getLowestBlockNum();
        if (lowestBlockNum > headBlockNum) {
            logger.info("Peer {} miss block, lowestBlockNum:{}, headBlockNum:{}", new Object[]{peer.getInetSocketAddress(), lowestBlockNum, headBlockNum});
            peer.disconnect(Protocol.ReasonCode.LIGHT_NODE_SYNC_FAIL);
            return;
        }
        if (msg.getVersion() != Args.getInstance().getNodeP2pVersion()) {
            logger.info("Peer {} different p2p version, peer->{}, me->{}", new Object[]{peer.getInetSocketAddress(), msg.getVersion(), Args.getInstance().getNodeP2pVersion()});
            peer.disconnect(Protocol.ReasonCode.INCOMPATIBLE_VERSION);
            return;
        }
        if (!Arrays.equals(this.chainBaseManager.getGenesisBlockId().getBytes(), msg.getGenesisBlockId().getBytes())) {
            logger.info("Peer {} different genesis block, peer->{}, me->{}", new Object[]{peer.getInetSocketAddress(), msg.getGenesisBlockId().getString(), this.chainBaseManager.getGenesisBlockId().getString()});
            peer.disconnect(Protocol.ReasonCode.INCOMPATIBLE_CHAIN);
            return;
        }
        if (this.chainBaseManager.getSolidBlockId().getNum() >= msg.getSolidBlockId().getNum() && !this.chainBaseManager.containBlockInMainChain(msg.getSolidBlockId())) {
            logger.info("Peer {} different solid block, peer->{}, me->{}", new Object[]{peer.getInetSocketAddress(), msg.getSolidBlockId().getString(), this.chainBaseManager.getSolidBlockId().getString()});
            peer.disconnect(Protocol.ReasonCode.FORKED);
            return;
        }
        if (msg.getHeadBlockId().getNum() < this.chainBaseManager.getHeadBlockId().getNum() && peer.getInetSocketAddress().equals(this.effectiveCheckService.getCur())) {
            logger.info("Peer's head block {} is below than we, peer->{}, me->{}", new Object[]{peer.getInetSocketAddress(), msg.getHeadBlockId().getNum(), this.chainBaseManager.getHeadBlockId().getNum()});
            peer.disconnect(Protocol.ReasonCode.BELOW_THAN_ME);
            return;
        }
        peer.setHelloMessageReceive(msg);
        peer.getChannel().updateAvgLatency(System.currentTimeMillis() - peer.getChannel().getStartTime());
        PeerManager.sortPeers();
        peer.onConnect();
    }

    private void sendHelloMessage(PeerConnection peer, long time) {
        Node node = new Node(TronNetService.getP2pConfig().getNodeID(), TronNetService.getP2pConfig().getIp(), TronNetService.getP2pConfig().getIpv6(), TronNetService.getP2pConfig().getPort());
        HelloMessage message = new HelloMessage(node, time, ChainBaseManager.getChainBaseManager());
        this.relayService.fillHelloMessage(message, peer.getChannel());
        peer.sendMessage(message);
        peer.setHelloMessageSend(message);
    }
}

