/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.net.service.adv;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.overlay.message.Message;
import org.tron.common.utils.Sha256Hash;
import org.tron.common.utils.Time;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.config.args.Args;
import org.tron.core.net.TronNetDelegate;
import org.tron.core.net.message.adv.BlockMessage;
import org.tron.core.net.message.adv.FetchInvDataMessage;
import org.tron.core.net.message.adv.InventoryMessage;
import org.tron.core.net.message.adv.TransactionMessage;
import org.tron.core.net.peer.Item;
import org.tron.core.net.peer.PeerConnection;
import org.tron.core.net.service.fetchblock.FetchBlockService;
import org.tron.core.net.service.statistics.MessageCount;
import org.tron.protos.Protocol;

@Component
public class AdvService {
    private static final Logger logger = LoggerFactory.getLogger((String)"net");
    private final int MAX_INV_TO_FETCH_CACHE_SIZE = 100000;
    private final int MAX_TRX_CACHE_SIZE = 50000;
    private final int MAX_BLOCK_CACHE_SIZE = 10;
    private final int MAX_SPREAD_SIZE = 1000;
    @Autowired
    private TronNetDelegate tronNetDelegate;
    @Autowired
    private FetchBlockService fetchBlockService;
    private ConcurrentHashMap<Item, Long> invToFetch = new ConcurrentHashMap();
    private ConcurrentHashMap<Item, Long> invToSpread = new ConcurrentHashMap();
    private long blockCacheTimeout = Args.getInstance().getBlockCacheTimeout();
    private Cache<Item, Long> invToFetchCache = CacheBuilder.newBuilder().maximumSize(100000L).expireAfterWrite(this.blockCacheTimeout, TimeUnit.MINUTES).recordStats().build();
    private Cache<Item, Message> trxCache = CacheBuilder.newBuilder().maximumSize(50000L).expireAfterWrite(1L, TimeUnit.HOURS).recordStats().build();
    private Cache<Item, Message> blockCache = CacheBuilder.newBuilder().maximumSize(10L).expireAfterWrite(1L, TimeUnit.MINUTES).recordStats().build();
    private ScheduledExecutorService spreadExecutor = Executors.newSingleThreadScheduledExecutor();
    private ScheduledExecutorService fetchExecutor = Executors.newSingleThreadScheduledExecutor();
    private MessageCount trxCount = new MessageCount();
    private boolean fastForward = Args.getInstance().isFastForward();

    public void init() {
        this.spreadExecutor.scheduleWithFixedDelay(() -> {
            try {
                this.consumerInvToSpread();
            }
            catch (Exception exception) {
                logger.error("Spread thread error", (Throwable)exception);
            }
        }, 100L, 30L, TimeUnit.MILLISECONDS);
        this.fetchExecutor.scheduleWithFixedDelay(() -> {
            try {
                this.consumerInvToFetch();
            }
            catch (Exception exception) {
                logger.error("Fetch thread error", (Throwable)exception);
            }
        }, 100L, 30L, TimeUnit.MILLISECONDS);
    }

    public void close() {
        this.spreadExecutor.shutdown();
        this.fetchExecutor.shutdown();
    }

    public synchronized void addInvToCache(Item item) {
        this.invToFetchCache.put((Object)item, (Object)System.currentTimeMillis());
        this.invToFetch.remove(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addInv(Item item) {
        if (this.fastForward && item.getType().equals((Object)Protocol.Inventory.InventoryType.TRX)) {
            return false;
        }
        if (item.getType().equals((Object)Protocol.Inventory.InventoryType.TRX) && this.trxCache.getIfPresent((Object)item) != null) {
            return false;
        }
        if (item.getType().equals((Object)Protocol.Inventory.InventoryType.BLOCK) && this.blockCache.getIfPresent((Object)item) != null) {
            return false;
        }
        AdvService advService = this;
        synchronized (advService) {
            if (this.invToFetchCache.getIfPresent((Object)item) != null) {
                return false;
            }
            this.invToFetchCache.put((Object)item, (Object)System.currentTimeMillis());
            this.invToFetch.put(item, System.currentTimeMillis());
        }
        if (Protocol.Inventory.InventoryType.BLOCK.equals((Object)item.getType())) {
            this.consumerInvToFetch();
        }
        return true;
    }

    public Message getMessage(Item item) {
        if (item.getType() == Protocol.Inventory.InventoryType.TRX) {
            return (Message)this.trxCache.getIfPresent((Object)item);
        }
        return (Message)this.blockCache.getIfPresent((Object)item);
    }

    public int fastBroadcastTransaction(TransactionMessage msg) {
        List peers = this.tronNetDelegate.getActivePeer().stream().filter(peer -> !peer.isNeedSyncFromPeer() && !peer.isNeedSyncFromUs()).collect(Collectors.toList());
        if (peers.size() == 0) {
            logger.warn("Broadcast transaction {} failed, no connection", (Object)msg.getMessageId());
            return 0;
        }
        Item item = new Item(msg.getMessageId(), Protocol.Inventory.InventoryType.TRX);
        this.trxCount.add();
        this.trxCache.put((Object)item, (Object)new TransactionMessage(msg.getTransactionCapsule().getInstance()));
        ArrayList<Sha256Hash> list = new ArrayList<Sha256Hash>();
        list.add(msg.getMessageId());
        InventoryMessage inventoryMessage = new InventoryMessage(list, Protocol.Inventory.InventoryType.TRX);
        int peersCount = 0;
        for (PeerConnection peer2 : peers) {
            if (peer2.getAdvInvReceive().getIfPresent((Object)item) != null || peer2.getAdvInvSpread().getIfPresent((Object)item) != null) continue;
            ++peersCount;
            peer2.getAdvInvSpread().put((Object)item, (Object)Time.getCurrentMillis());
            peer2.sendMessage(inventoryMessage);
        }
        if (peersCount == 0) {
            logger.warn("Broadcast transaction {} failed, no peers", (Object)msg.getMessageId());
        }
        return peersCount;
    }

    public void broadcast(Message msg) {
        Item item;
        if (this.fastForward) {
            return;
        }
        if (this.invToSpread.size() > 1000) {
            logger.warn("Drop message, type: {}, ID: {}", (Object)msg.getType(), (Object)msg.getMessageId());
            return;
        }
        if (msg instanceof BlockMessage) {
            BlockMessage blockMsg = (BlockMessage)msg;
            item = new Item(blockMsg.getMessageId(), Protocol.Inventory.InventoryType.BLOCK);
            logger.info("Ready to broadcast block {}", (Object)blockMsg.getBlockId().getString());
            blockMsg.getBlockCapsule().getTransactions().forEach(transactionCapsule -> {
                Sha256Hash tid = transactionCapsule.getTransactionId();
                this.invToSpread.remove(tid);
                this.trxCache.put((Object)new Item(tid, Protocol.Inventory.InventoryType.TRX), (Object)new TransactionMessage(transactionCapsule.getInstance()));
            });
            this.blockCache.put((Object)item, (Object)msg);
        } else if (msg instanceof TransactionMessage) {
            TransactionMessage trxMsg = (TransactionMessage)msg;
            item = new Item(trxMsg.getMessageId(), Protocol.Inventory.InventoryType.TRX);
            this.trxCount.add();
            this.trxCache.put((Object)item, (Object)new TransactionMessage(trxMsg.getTransactionCapsule().getInstance()));
        } else {
            logger.error("Adv item is neither block nor trx, type: {}", (Object)msg.getType());
            return;
        }
        this.invToSpread.put(item, System.currentTimeMillis());
        if (Protocol.Inventory.InventoryType.BLOCK.equals((Object)item.getType())) {
            this.consumerInvToSpread();
        }
    }

    public void onDisconnect(PeerConnection peer) {
        if (!peer.getAdvInvRequest().isEmpty()) {
            peer.getAdvInvRequest().keySet().forEach(item -> {
                if (this.tronNetDelegate.getActivePeer().stream().anyMatch(p -> !p.equals(peer) && p.getAdvInvReceive().getIfPresent(item) != null)) {
                    this.invToFetch.put((Item)item, System.currentTimeMillis());
                } else {
                    this.invToFetchCache.invalidate(item);
                }
            });
        }
        if (this.invToFetch.size() > 0) {
            this.consumerInvToFetch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consumerInvToFetch() {
        Collection peers = this.tronNetDelegate.getActivePeer().stream().filter(peer -> peer.isIdle()).collect(Collectors.toList());
        InvSender invSender = new InvSender();
        long now = System.currentTimeMillis();
        AdvService advService = this;
        synchronized (advService) {
            if (this.invToFetch.isEmpty() || peers.isEmpty()) {
                return;
            }
            this.invToFetch.forEach((item, time) -> {
                if (time < now - 15000L) {
                    logger.info("This obj is too late to fetch, type: {} hash: {}", (Object)item.getType(), (Object)item.getHash());
                    this.invToFetch.remove(item);
                    this.invToFetchCache.invalidate(item);
                    return;
                }
                peers.stream().filter(peer -> peer.getAdvInvReceive().getIfPresent(item) != null && invSender.getSize((PeerConnection)peer) < 1000).sorted(Comparator.comparingInt(peer -> invSender.getSize((PeerConnection)peer))).findFirst().ifPresent(peer -> {
                    if (peer.checkAndPutAdvInvRequest((Item)item, now)) {
                        invSender.add((Item)item, (PeerConnection)peer);
                    }
                    this.invToFetch.remove(item);
                });
            });
        }
        invSender.sendFetch();
    }

    private synchronized void consumerInvToSpread() {
        List peers = this.tronNetDelegate.getActivePeer().stream().filter(peer -> !peer.isNeedSyncFromPeer() && !peer.isNeedSyncFromUs()).collect(Collectors.toList());
        if (this.invToSpread.isEmpty() || peers.isEmpty()) {
            return;
        }
        InvSender invSender = new InvSender();
        this.invToSpread.forEach((item, time) -> peers.forEach(peer -> {
            if (!(peer.getAdvInvReceive().getIfPresent(item) != null || peer.getAdvInvSpread().getIfPresent(item) != null || item.getType().equals((Object)Protocol.Inventory.InventoryType.BLOCK) && System.currentTimeMillis() - time > 3000L)) {
                peer.getAdvInvSpread().put(item, (Object)Time.getCurrentMillis());
                invSender.add((Item)item, (PeerConnection)peer);
            }
            this.invToSpread.remove(item);
        }));
        invSender.sendInv();
    }

    public MessageCount getTrxCount() {
        return this.trxCount;
    }

    class InvSender {
        private HashMap<PeerConnection, HashMap<Protocol.Inventory.InventoryType, LinkedList<Sha256Hash>>> send = new HashMap();

        InvSender() {
        }

        public void clear() {
            this.send.clear();
        }

        public void add(Map.Entry<Sha256Hash, Protocol.Inventory.InventoryType> id, PeerConnection peer) {
            if (this.send.containsKey(peer) && !this.send.get(peer).containsKey(id.getValue())) {
                this.send.get(peer).put(id.getValue(), new LinkedList());
            } else if (!this.send.containsKey(peer)) {
                this.send.put(peer, new HashMap());
                this.send.get(peer).put(id.getValue(), new LinkedList());
            }
            this.send.get(peer).get(id.getValue()).offer(id.getKey());
        }

        public void add(Item id, PeerConnection peer) {
            LinkedList<Object> list;
            HashMap<Object, LinkedList<Object>> map = this.send.get(peer);
            if (map == null) {
                map = new HashMap();
                this.send.put(peer, map);
            }
            if ((list = map.get(id.getType())) == null) {
                list = new LinkedList();
                map.put(id.getType(), list);
            }
            list.offer(id.getHash());
        }

        public int getSize(PeerConnection peer) {
            if (this.send.containsKey(peer)) {
                return this.send.get(peer).values().stream().mapToInt(LinkedList::size).sum();
            }
            return 0;
        }

        public void sendInv() {
            this.send.forEach((peer, ids) -> ids.forEach((key, value) -> {
                if (peer.isRelayPeer() && key.equals((Object)Protocol.Inventory.InventoryType.TRX)) {
                    return;
                }
                if (key.equals((Object)Protocol.Inventory.InventoryType.BLOCK)) {
                    value.sort(Comparator.comparingLong(value1 -> new BlockCapsule.BlockId(value1).getNum()));
                    peer.sendMessage(new InventoryMessage((List<Sha256Hash>)value, (Protocol.Inventory.InventoryType)key));
                } else {
                    peer.sendMessage(new InventoryMessage((List<Sha256Hash>)value, (Protocol.Inventory.InventoryType)key));
                }
            }));
        }

        void sendFetch() {
            this.send.forEach((peer, ids) -> ids.forEach((key, value) -> {
                if (key.equals((Object)Protocol.Inventory.InventoryType.BLOCK)) {
                    value.sort(Comparator.comparingLong(value1 -> new BlockCapsule.BlockId(value1).getNum()));
                    peer.sendMessage(new FetchInvDataMessage((List<Sha256Hash>)value, (Protocol.Inventory.InventoryType)key));
                    AdvService.this.fetchBlockService.fetchBlock((List<Sha256Hash>)value, (PeerConnection)peer);
                } else {
                    peer.sendMessage(new FetchInvDataMessage((List<Sha256Hash>)value, (Protocol.Inventory.InventoryType)key));
                }
            }));
        }
    }
}

