/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.net.messagehandler;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.core.config.args.Args;
import org.tron.core.exception.P2pException;
import org.tron.core.net.TronNetDelegate;
import org.tron.core.net.message.TronMessage;
import org.tron.core.net.message.adv.TransactionMessage;
import org.tron.core.net.message.adv.TransactionsMessage;
import org.tron.core.net.messagehandler.TronMsgHandler;
import org.tron.core.net.peer.Item;
import org.tron.core.net.peer.PeerConnection;
import org.tron.core.net.service.adv.AdvService;
import org.tron.protos.Protocol;

@Component
public class TransactionsMsgHandler
implements TronMsgHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"net");
    private static int MAX_TRX_SIZE = 50000;
    private static int MAX_SMART_CONTRACT_SUBMIT_SIZE = 100;
    @Autowired
    private TronNetDelegate tronNetDelegate;
    @Autowired
    private AdvService advService;
    private BlockingQueue<TrxEvent> smartContractQueue = new LinkedBlockingQueue<TrxEvent>(MAX_TRX_SIZE);
    private BlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
    private int threadNum = Args.getInstance().getValidateSignThreadNum();
    private ExecutorService trxHandlePool = new ThreadPoolExecutor(this.threadNum, this.threadNum, 0L, TimeUnit.MILLISECONDS, this.queue);
    private ScheduledExecutorService smartContractExecutor = Executors.newSingleThreadScheduledExecutor();

    public void init() {
        this.handleSmartContract();
    }

    public void close() {
        this.trxHandlePool.shutdown();
        this.smartContractExecutor.shutdown();
    }

    public boolean isBusy() {
        return this.queue.size() + this.smartContractQueue.size() > MAX_TRX_SIZE;
    }

    @Override
    public void processMessage(PeerConnection peer, TronMessage msg) throws P2pException {
        TransactionsMessage transactionsMessage = (TransactionsMessage)msg;
        this.check(peer, transactionsMessage);
        int smartContractQueueSize = 0;
        int trxHandlePoolQueueSize = 0;
        int dropSmartContractCount = 0;
        for (Protocol.Transaction trx : transactionsMessage.getTransactions().getTransactionsList()) {
            int type = trx.getRawData().getContract(0).getType().getNumber();
            if (type == 31 || type == 30) {
                if (this.smartContractQueue.offer(new TrxEvent(peer, new TransactionMessage(trx)))) continue;
                smartContractQueueSize = this.smartContractQueue.size();
                trxHandlePoolQueueSize = this.queue.size();
                ++dropSmartContractCount;
                continue;
            }
            this.trxHandlePool.submit(() -> this.handleTransaction(peer, new TransactionMessage(trx)));
        }
        if (dropSmartContractCount > 0) {
            logger.warn("Add smart contract failed, drop count: {}, queueSize {}:{}", new Object[]{dropSmartContractCount, smartContractQueueSize, trxHandlePoolQueueSize});
        }
    }

    private void check(PeerConnection peer, TransactionsMessage msg) throws P2pException {
        for (Protocol.Transaction trx : msg.getTransactions().getTransactionsList()) {
            Item item = new Item(new TransactionMessage(trx).getMessageId(), Protocol.Inventory.InventoryType.TRX);
            if (!peer.getAdvInvRequest().containsKey(item)) {
                throw new P2pException(P2pException.TypeEnum.BAD_MESSAGE, "trx: " + msg.getMessageId() + " without request.");
            }
            peer.getAdvInvRequest().remove(item);
        }
    }

    private void handleSmartContract() {
        this.smartContractExecutor.scheduleWithFixedDelay(() -> {
            try {
                while (this.queue.size() < MAX_SMART_CONTRACT_SUBMIT_SIZE) {
                    TrxEvent event = this.smartContractQueue.take();
                    this.trxHandlePool.submit(() -> this.handleTransaction(event.getPeer(), event.getMsg()));
                }
            }
            catch (InterruptedException e) {
                logger.warn("Handle smart server interrupted");
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                logger.error("Handle smart contract exception", (Throwable)e);
            }
        }, 1000L, 20L, TimeUnit.MILLISECONDS);
    }

    private void handleTransaction(PeerConnection peer, TransactionMessage trx) {
        if (peer.isDisconnect()) {
            logger.warn("Drop trx {} from {}, peer is disconnect", (Object)trx.getMessageId(), (Object)peer.getInetAddress());
            return;
        }
        if (this.advService.getMessage(new Item(trx.getMessageId(), Protocol.Inventory.InventoryType.TRX)) != null) {
            return;
        }
        try {
            this.tronNetDelegate.pushTransaction(trx.getTransactionCapsule());
            this.advService.broadcast(trx);
        }
        catch (P2pException e) {
            logger.warn("Trx {} from peer {} process failed. type: {}, reason: {}", new Object[]{trx.getMessageId(), peer.getInetAddress(), e.getType(), e.getMessage()});
            if (e.getType().equals((Object)P2pException.TypeEnum.BAD_TRX)) {
                peer.disconnect(Protocol.ReasonCode.BAD_TX);
            }
        }
        catch (Exception e) {
            logger.error("Trx {} from peer {} process failed", new Object[]{trx.getMessageId(), peer.getInetAddress(), e});
        }
    }

    class TrxEvent {
        private PeerConnection peer;
        private TransactionMessage msg;
        private long time;

        public TrxEvent(PeerConnection peer, TransactionMessage msg) {
            this.peer = peer;
            this.msg = msg;
            this.time = System.currentTimeMillis();
        }

        public PeerConnection getPeer() {
            return this.peer;
        }

        public TransactionMessage getMsg() {
            return this.msg;
        }

        public long getTime() {
            return this.time;
        }
    }
}

