/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.net.message.sync;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.net.message.MessageTypes;
import org.tron.core.net.message.TronMessage;
import org.tron.protos.Protocol;

public class BlockInventoryMessage
extends TronMessage {
    protected Protocol.BlockInventory blockInventory;

    public BlockInventoryMessage(byte[] data) throws Exception {
        super(data);
        this.type = MessageTypes.BLOCK_INVENTORY.asByte();
        this.blockInventory = Protocol.BlockInventory.parseFrom((byte[])data);
    }

    public BlockInventoryMessage(List<BlockCapsule.BlockId> blockIds, Protocol.BlockInventory.Type type) {
        Protocol.BlockInventory.Builder invBuilder = Protocol.BlockInventory.newBuilder();
        blockIds.forEach(blockId -> {
            Protocol.BlockInventory.BlockId.Builder b = Protocol.BlockInventory.BlockId.newBuilder();
            b.setHash(blockId.getByteString());
            b.setNumber(blockId.getNum());
            invBuilder.addIds(b);
        });
        invBuilder.setType(type);
        this.blockInventory = invBuilder.build();
        this.type = MessageTypes.BLOCK_INVENTORY.asByte();
        this.data = this.blockInventory.toByteArray();
    }

    public Class<?> getAnswerMessage() {
        return null;
    }

    private Protocol.BlockInventory getBlockInventory() {
        return this.blockInventory;
    }

    public List<BlockCapsule.BlockId> getBlockIds() {
        return this.getBlockInventory().getIdsList().stream().map(blockId -> new BlockCapsule.BlockId(blockId.getHash(), blockId.getNumber())).collect(Collectors.toCollection(ArrayList::new));
    }
}

