/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.net.message.adv;

import com.google.protobuf.CodedInputStream;
import java.util.List;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.net.message.MessageTypes;
import org.tron.core.net.message.TronMessage;
import org.tron.protos.Protocol;

public class TransactionsMessage
extends TronMessage {
    private Protocol.Transactions transactions;

    public TransactionsMessage(List<Protocol.Transaction> trxs) {
        Protocol.Transactions.Builder builder = Protocol.Transactions.newBuilder();
        trxs.forEach(trx -> builder.addTransactions(trx));
        this.transactions = builder.build();
        this.type = MessageTypes.TRXS.asByte();
        this.data = this.transactions.toByteArray();
    }

    public TransactionsMessage(byte[] data) throws Exception {
        super(data);
        this.type = MessageTypes.TRXS.asByte();
        this.transactions = Protocol.Transactions.parseFrom((CodedInputStream)TransactionsMessage.getCodedInputStream((byte[])data));
        if (TransactionsMessage.isFilter()) {
            TransactionsMessage.compareBytes((byte[])data, (byte[])this.transactions.toByteArray());
            TransactionCapsule.validContractProto((List)this.transactions.getTransactionsList());
        }
    }

    public Protocol.Transactions getTransactions() {
        return this.transactions;
    }

    public String toString() {
        return super.toString() + "trx size: " + this.transactions.getTransactionsList().size();
    }

    public Class<?> getAnswerMessage() {
        return null;
    }
}

