/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.net.message.adv;

import org.tron.common.overlay.message.Message;
import org.tron.common.utils.Sha256Hash;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.net.message.MessageTypes;
import org.tron.core.net.message.TronMessage;
import org.tron.protos.Protocol;

public class TransactionMessage
extends TronMessage {
    private TransactionCapsule transactionCapsule;

    public TransactionMessage(byte[] data) throws Exception {
        super(data);
        this.transactionCapsule = new TransactionCapsule(TransactionMessage.getCodedInputStream((byte[])data));
        this.type = MessageTypes.TRX.asByte();
        if (Message.isFilter()) {
            TransactionMessage.compareBytes((byte[])data, (byte[])this.transactionCapsule.getInstance().toByteArray());
            TransactionCapsule.validContractProto((Protocol.Transaction.Contract)this.transactionCapsule.getInstance().getRawData().getContract(0));
        }
    }

    public TransactionMessage(Protocol.Transaction trx) {
        this.transactionCapsule = new TransactionCapsule(trx);
        this.type = MessageTypes.TRX.asByte();
        this.data = trx.toByteArray();
    }

    public String toString() {
        return super.toString() + "messageId: " + super.getMessageId();
    }

    public Sha256Hash getMessageId() {
        return this.transactionCapsule.getTransactionId();
    }

    public Class<?> getAnswerMessage() {
        return null;
    }

    public TransactionCapsule getTransactionCapsule() {
        return this.transactionCapsule;
    }
}

