/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.net.message;

import org.apache.commons.lang3.ArrayUtils;
import org.tron.consensus.pbft.message.PbftBaseMessage;
import org.tron.consensus.pbft.message.PbftMessage;
import org.tron.core.exception.P2pException;
import org.tron.core.net.message.MessageTypes;

public class PbftMessageFactory {
    private static String LEN = ", len=";
    private static String TYPE = "type=";

    public static PbftBaseMessage create(byte[] data) throws Exception {
        try {
            byte type = data[0];
            byte[] rawData = ArrayUtils.subarray((byte[])data, (int)1, (int)data.length);
            return PbftMessageFactory.create(type, rawData);
        }
        catch (P2pException e) {
            throw e;
        }
        catch (Exception e) {
            throw new P2pException(P2pException.TypeEnum.PARSE_MESSAGE_FAILED, TYPE + data[0] + LEN + data.length + ", error msg: " + e.getMessage());
        }
    }

    private static PbftBaseMessage create(byte type, byte[] packed) throws Exception {
        MessageTypes receivedTypes = MessageTypes.fromByte((byte)type);
        if (receivedTypes == null) {
            throw new P2pException(P2pException.TypeEnum.NO_SUCH_MESSAGE, TYPE + type + LEN + packed.length);
        }
        switch (receivedTypes) {
            case PBFT_MSG: {
                return new PbftMessage(packed);
            }
        }
        throw new P2pException(P2pException.TypeEnum.NO_SUCH_MESSAGE, receivedTypes.toString() + LEN + packed.length);
    }
}

