/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.net;

import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.tron.common.prometheus.Metrics;
import org.tron.consensus.pbft.message.PbftMessage;
import org.tron.core.config.args.Args;
import org.tron.core.exception.P2pException;
import org.tron.core.net.message.MessageTypes;
import org.tron.core.net.message.PbftMessageFactory;
import org.tron.core.net.message.TronMessage;
import org.tron.core.net.message.TronMessageFactory;
import org.tron.core.net.message.adv.InventoryMessage;
import org.tron.core.net.message.base.DisconnectMessage;
import org.tron.core.net.message.handshake.HelloMessage;
import org.tron.core.net.messagehandler.BlockMsgHandler;
import org.tron.core.net.messagehandler.ChainInventoryMsgHandler;
import org.tron.core.net.messagehandler.FetchInvDataMsgHandler;
import org.tron.core.net.messagehandler.InventoryMsgHandler;
import org.tron.core.net.messagehandler.PbftDataSyncHandler;
import org.tron.core.net.messagehandler.PbftMsgHandler;
import org.tron.core.net.messagehandler.SyncBlockChainMsgHandler;
import org.tron.core.net.messagehandler.TransactionsMsgHandler;
import org.tron.core.net.peer.PeerConnection;
import org.tron.core.net.peer.PeerManager;
import org.tron.core.net.service.effective.EffectiveCheckService;
import org.tron.core.net.service.handshake.HandshakeService;
import org.tron.core.net.service.keepalive.KeepAliveService;
import org.tron.p2p.P2pEventHandler;
import org.tron.p2p.connection.Channel;
import org.tron.protos.Protocol;

@Component
public class P2pEventHandlerImpl
extends P2pEventHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"net");
    private static final String TAG = "~";
    private static final int DURATION_STEP = 50;
    private static AtomicInteger passivePeersCount = new AtomicInteger(0);
    private final AtomicInteger activePeersCount = new AtomicInteger(0);
    @Autowired
    private ApplicationContext ctx;
    @Autowired
    private SyncBlockChainMsgHandler syncBlockChainMsgHandler;
    @Autowired
    private ChainInventoryMsgHandler chainInventoryMsgHandler;
    @Autowired
    private InventoryMsgHandler inventoryMsgHandler;
    @Autowired
    private FetchInvDataMsgHandler fetchInvDataMsgHandler;
    @Autowired
    private BlockMsgHandler blockMsgHandler;
    @Autowired
    private TransactionsMsgHandler transactionsMsgHandler;
    @Autowired
    private PbftDataSyncHandler pbftDataSyncHandler;
    @Autowired
    private HandshakeService handshakeService;
    @Autowired
    private PbftMsgHandler pbftMsgHandler;
    @Autowired
    private KeepAliveService keepAliveService;
    @Autowired
    private EffectiveCheckService effectiveCheckService;
    private byte MESSAGE_MAX_TYPE = (byte)127;
    private int maxCountIn10s = Args.getInstance().getMaxTps() * 10;

    public P2pEventHandlerImpl() {
        HashSet<Byte> set = new HashSet<Byte>();
        for (byte i = 0; i < this.MESSAGE_MAX_TYPE; i = (byte)(i + 1)) {
            set.add(i);
        }
        this.messageTypes = set;
    }

    public synchronized void onConnect(Channel channel) {
        PeerConnection peerConnection = PeerManager.add(this.ctx, channel);
        if (peerConnection != null) {
            this.handshakeService.startHandshake(peerConnection);
        }
    }

    public synchronized void onDisconnect(Channel channel) {
        PeerConnection peerConnection = PeerManager.remove(channel);
        if (peerConnection != null) {
            peerConnection.onDisconnect();
        }
        this.effectiveCheckService.onDisconnect(channel.getInetSocketAddress());
    }

    public void onMessage(Channel c, byte[] data) {
        PeerConnection peerConnection = PeerManager.getPeerConnection(c);
        if (peerConnection == null) {
            logger.warn("Receive msg from unknown peer {}", (Object)c.getInetSocketAddress());
            return;
        }
        if (MessageTypes.PBFT_MSG.asByte() == data[0]) {
            PbftMessage message = null;
            try {
                message = (PbftMessage)PbftMessageFactory.create(data);
                this.pbftMsgHandler.processMessage(peerConnection, message);
            }
            catch (Exception e) {
                logger.warn("PBFT Message from {} process failed, {}", new Object[]{peerConnection.getInetSocketAddress(), message, e.getMessage()});
                peerConnection.disconnect(Protocol.ReasonCode.BAD_PROTOCOL);
            }
            return;
        }
        this.processMessage(peerConnection, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void processMessage(PeerConnection peer, byte[] data) {
        block26: {
            block27: {
                startTime = System.currentTimeMillis();
                msg = null;
                type = null;
                msg = TronMessageFactory.create(data);
                type = msg.getType();
                if (!MessageTypes.INVENTORY.equals((Object)type)) break block26;
                message = (InventoryMessage)msg;
                inventoryType = message.getInventoryType();
                count = peer.getPeerStatistics().messageStatistics.tronInTrxInventoryElement.getCount(10);
                if (!inventoryType.equals((Object)Protocol.Inventory.InventoryType.TRX) || count <= this.maxCountIn10s) break block26;
                P2pEventHandlerImpl.logger.warn("Drop inventory from Peer {}, cur:{}, max:{}", new Object[]{peer.getInetAddress(), count, this.maxCountIn10s});
                if (!Args.getInstance().isOpenPrintLog()) break block27;
                P2pEventHandlerImpl.logger.warn("[overload]Drop tx list is: {}", ((InventoryMessage)msg).getHashList());
            }
            if ((costs = System.currentTimeMillis() - startTime) > 50L) {
                P2pEventHandlerImpl.logger.info("Message processing costs {} ms, peer: {}, type: {}, time tag: {}", new Object[]{costs, peer.getInetSocketAddress(), type, this.getTimeTag(costs)});
                if (type != null) {
                    Metrics.histogramObserve((String)"tron:message_process_latency_seconds", (double)((double)costs / 1000.0), (String[])new String[]{type.name()});
                }
            }
            return;
        }
        try {
            peer.getPeerStatistics().messageStatistics.addTcpInMessage(msg);
            if (PeerConnection.needToLog(msg)) {
                P2pEventHandlerImpl.logger.info("Receive message from  peer: {}, {}", (Object)peer.getInetSocketAddress(), (Object)msg);
            }
            switch (1.$SwitchMap$org$tron$core$net$message$MessageTypes[type.ordinal()]) {
                case 1: 
                case 2: {
                    this.keepAliveService.processMessage(peer, msg);
                    ** break;
                }
                case 3: {
                    this.handshakeService.processHelloMessage(peer, (HelloMessage)msg);
                    ** break;
                }
                case 4: {
                    peer.getChannel().close();
                    peer.getNodeStatistics().nodeDisconnectedRemote(((DisconnectMessage)msg).getReason());
                    ** break;
                }
                case 5: {
                    this.syncBlockChainMsgHandler.processMessage(peer, msg);
                    ** break;
                }
                case 6: {
                    this.chainInventoryMsgHandler.processMessage(peer, msg);
                    ** break;
                }
                case 7: {
                    this.inventoryMsgHandler.processMessage(peer, msg);
                    ** break;
                }
                case 8: {
                    this.fetchInvDataMsgHandler.processMessage(peer, msg);
                    ** break;
                }
                case 9: {
                    this.blockMsgHandler.processMessage(peer, msg);
                    ** break;
                }
                case 10: {
                    this.transactionsMsgHandler.processMessage(peer, msg);
                    ** break;
                }
                case 11: {
                    this.pbftDataSyncHandler.processMessage(peer, msg);
                    ** break;
                }
                default: {
                    throw new P2pException(P2pException.TypeEnum.NO_SUCH_MESSAGE, msg.getType().toString());
lbl60:
                    // 10 sources

                    break;
                }
            }
        }
        catch (Exception e) {
            try {
                this.processException(peer, msg, e);
            }
            catch (Throwable var12_13) {
                costs = System.currentTimeMillis() - startTime;
                if (costs > 50L) {
                    P2pEventHandlerImpl.logger.info("Message processing costs {} ms, peer: {}, type: {}, time tag: {}", new Object[]{costs, peer.getInetSocketAddress(), type, this.getTimeTag(costs)});
                    if (type != null) {
                        Metrics.histogramObserve((String)"tron:message_process_latency_seconds", (double)((double)costs / 1000.0), (String[])new String[]{type.name()});
                    }
                }
                throw var12_13;
            }
            costs = System.currentTimeMillis() - startTime;
            if (costs > 50L) {
                P2pEventHandlerImpl.logger.info("Message processing costs {} ms, peer: {}, type: {}, time tag: {}", new Object[]{costs, peer.getInetSocketAddress(), type, this.getTimeTag(costs)});
                if (type != null) {
                    Metrics.histogramObserve((String)"tron:message_process_latency_seconds", (double)((double)costs / 1000.0), (String[])new String[]{type.name()});
                } else {
                    ** GOTO lbl83
                }
            } else {
                ** GOTO lbl83
            }
        }
        costs = System.currentTimeMillis() - startTime;
        if (costs > 50L) {
            P2pEventHandlerImpl.logger.info("Message processing costs {} ms, peer: {}, type: {}, time tag: {}", new Object[]{costs, peer.getInetSocketAddress(), type, this.getTimeTag(costs)});
            if (type != null) {
                Metrics.histogramObserve((String)"tron:message_process_latency_seconds", (double)((double)costs / 1000.0), (String[])new String[]{type.name()});
            }
        }
    }

    private void processException(PeerConnection peer, TronMessage msg, Exception ex) {
        Protocol.ReasonCode code2;
        if (ex instanceof P2pException) {
            P2pException.TypeEnum type = ((P2pException)ex).getType();
            switch (type) {
                case BAD_TRX: {
                    code2 = Protocol.ReasonCode.BAD_TX;
                    break;
                }
                case BAD_BLOCK: {
                    code2 = Protocol.ReasonCode.BAD_BLOCK;
                    break;
                }
                case NO_SUCH_MESSAGE: 
                case MESSAGE_WITH_WRONG_LENGTH: 
                case BAD_MESSAGE: {
                    code2 = Protocol.ReasonCode.BAD_PROTOCOL;
                    break;
                }
                case SYNC_FAILED: {
                    code2 = Protocol.ReasonCode.SYNC_FAIL;
                    break;
                }
                case UNLINK_BLOCK: {
                    code2 = Protocol.ReasonCode.UNLINKABLE;
                    break;
                }
                case DB_ITEM_NOT_FOUND: {
                    code2 = Protocol.ReasonCode.FETCH_FAIL;
                    break;
                }
                default: {
                    code2 = Protocol.ReasonCode.UNKNOWN;
                }
            }
            if (type.equals((Object)P2pException.TypeEnum.BAD_MESSAGE)) {
                logger.error("Message from {} process failed, {} \n type: ({})", new Object[]{peer.getInetSocketAddress(), msg, type, ex});
            } else {
                logger.warn("Message from {} process failed, {} \n type: ({}), detail: {}", new Object[]{peer.getInetSocketAddress(), msg, type, ex.getMessage()});
            }
        } else {
            code2 = Protocol.ReasonCode.UNKNOWN;
            logger.warn("Message from {} process failed, {}", new Object[]{peer.getInetSocketAddress(), msg, ex});
        }
        peer.disconnect(code2);
    }

    private String getTimeTag(long duration) {
        StringBuilder tag = new StringBuilder(TAG);
        for (long tagCount = duration / 50L; tagCount > 0L; --tagCount) {
            tag.append(TAG);
        }
        return tag.toString();
    }

    public static AtomicInteger getPassivePeersCount() {
        return passivePeersCount;
    }

    public AtomicInteger getActivePeersCount() {
        return this.activePeersCount;
    }
}

