/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.metrics.node;

import com.google.protobuf.ByteString;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.backup.BackupManager;
import org.tron.common.parameter.CommonParameter;
import org.tron.core.ChainBaseManager;
import org.tron.core.config.args.Args;
import org.tron.core.metrics.node.NodeInfo;
import org.tron.program.Version;
import org.tron.protos.Protocol;

@Component
public class NodeMetricManager {
    @Autowired
    private ChainBaseManager chainBaseManager;
    @Autowired
    private BackupManager backupManager;

    public NodeInfo getNodeInfo() {
        NodeInfo nodeInfo = new NodeInfo();
        this.setNodeInfo(nodeInfo);
        return nodeInfo;
    }

    private void setNodeInfo(NodeInfo nodeInfo) {
        nodeInfo.setIp(Args.getInstance().getNodeExternalIp());
        ByteString witnessAddress = ByteString.copyFrom((byte[])Args.getLocalWitnesses().getWitnessAccountAddress(CommonParameter.getInstance().isECKeyCryptoEngine()));
        if (this.chainBaseManager.getWitnessScheduleStore().getActiveWitnesses().contains(witnessAddress)) {
            nodeInfo.setNodeType(1);
        } else {
            nodeInfo.setNodeType(0);
        }
        nodeInfo.setVersion(Version.getVersion());
        if (this.backupManager.getStatus() == BackupManager.BackupStatusEnum.MASTER) {
            nodeInfo.setBackupStatus(1);
        } else {
            nodeInfo.setBackupStatus(0);
        }
    }

    public Protocol.MetricsInfo.NodeInfo getNodeProtoInfo() {
        Protocol.MetricsInfo.NodeInfo.Builder nodeInfo = Protocol.MetricsInfo.NodeInfo.newBuilder();
        NodeInfo node = this.getNodeInfo();
        nodeInfo.setIp(node.getIp());
        nodeInfo.setNodeType(node.getNodeType());
        nodeInfo.setVersion(node.getVersion());
        nodeInfo.setBackupStatus(node.getBackupStatus());
        return nodeInfo.build();
    }
}

