/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.metrics.net;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import java.util.ArrayList;
import java.util.Map;
import java.util.SortedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.core.metrics.MetricsUtil;
import org.tron.core.metrics.net.ApiDetailInfo;
import org.tron.core.metrics.net.ApiInfo;
import org.tron.core.metrics.net.DisconnectionDetailInfo;
import org.tron.core.metrics.net.LatencyDetailInfo;
import org.tron.core.metrics.net.LatencyInfo;
import org.tron.core.metrics.net.NetInfo;
import org.tron.core.metrics.net.RateInfo;
import org.tron.core.net.TronNetDelegate;
import org.tron.core.net.peer.PeerConnection;
import org.tron.protos.Protocol;

@Component
public class NetMetricManager {
    @Autowired
    private TronNetDelegate tronNetDelegate;

    public NetInfo getNetInfo() {
        NetInfo netInfo = new NetInfo();
        this.setNetInfo(netInfo);
        return netInfo;
    }

    private void setNetInfo(NetInfo netInfo) {
        netInfo.setConnectionCount(this.tronNetDelegate.getActivePeer().size());
        int validConnectionCount = 0;
        for (PeerConnection peerConnection : this.tronNetDelegate.getActivePeer()) {
            if (peerConnection.isNeedSyncFromUs() || peerConnection.isNeedSyncFromPeer()) continue;
            ++validConnectionCount;
        }
        netInfo.setValidConnectionCount(validConnectionCount);
        long errorProtoCount = MetricsUtil.getCounter("net.errorProtoCount").getCount();
        netInfo.setErrorProtoCount((int)errorProtoCount);
        RateInfo tcpInTraffic = MetricsUtil.getRateInfo("net.tcpInTraffic");
        netInfo.setTcpInTraffic(tcpInTraffic);
        RateInfo tcpOutTraffic = MetricsUtil.getRateInfo("net.tcpOutTraffic");
        netInfo.setTcpOutTraffic(tcpOutTraffic);
        RateInfo udpInTraffic = MetricsUtil.getRateInfo("net.udpInTraffic");
        netInfo.setUdpInTraffic(udpInTraffic);
        RateInfo udpOutTraffic = MetricsUtil.getRateInfo("net.udpOutTraffic");
        netInfo.setUdpOutTraffic(udpOutTraffic);
        ApiInfo apiInfo = new ApiInfo();
        RateInfo APIQPS = MetricsUtil.getRateInfo("net.api.qps");
        apiInfo.setQps(APIQPS);
        RateInfo FailQPS = MetricsUtil.getRateInfo("net.api.failQps");
        apiInfo.setFailQps(FailQPS);
        RateInfo totalOutTraffic = MetricsUtil.getRateInfo("net.api.outTraffic");
        apiInfo.setOutTraffic(totalOutTraffic);
        ArrayList<ApiDetailInfo> apiDetails = new ArrayList<ApiDetailInfo>();
        SortedMap<String, Meter> endpointQPSMap = MetricsUtil.getMeters("net.api.detail.qps.");
        SortedMap<String, Meter> endpointFailQPSMap = MetricsUtil.getMeters("net.api.detail.failQps.");
        SortedMap<String, Meter> endpointOutTrafficMap = MetricsUtil.getMeters("net.api.detail.outTraffic.");
        for (Map.Entry<String, Meter> entry : endpointQPSMap.entrySet()) {
            ApiDetailInfo apiDetail = new ApiDetailInfo();
            String endpointName = entry.getKey().substring("net.api.detail.qps.".length());
            apiDetail.setName(endpointName);
            RateInfo APIDetailQPS = MetricsUtil.getRateInfo(entry.getKey());
            apiDetail.setQps(APIDetailQPS);
            if (endpointOutTrafficMap.containsKey("net.api.detail.outTraffic." + endpointName)) {
                RateInfo rateInfo = MetricsUtil.getRateInfo("net.api.detail.outTraffic." + endpointName);
                apiDetail.setOutTraffic(rateInfo);
            }
            if (endpointFailQPSMap.containsKey("net.api.detail.failQps." + endpointName)) {
                RateInfo rateInfo = MetricsUtil.getRateInfo("net.api.detail.failQps." + endpointName);
                apiDetail.setFailQps(rateInfo);
            }
            apiDetails.add(apiDetail);
        }
        apiInfo.setDetail(apiDetails);
        netInfo.setApi(apiInfo);
        long disconnectionCount = MetricsUtil.getCounter("net.disconnectionCount").getCount();
        netInfo.setDisconnectionCount((int)disconnectionCount);
        ArrayList<DisconnectionDetailInfo> disconnectionDetails = new ArrayList<DisconnectionDetailInfo>();
        SortedMap<String, Counter> disconnectionReason = MetricsUtil.getCounters("net.disconnectionDetail.");
        for (Map.Entry entry : disconnectionReason.entrySet()) {
            DisconnectionDetailInfo detail = new DisconnectionDetailInfo();
            String reason = ((String)entry.getKey()).substring("net.disconnectionDetail.".length());
            detail.setReason(reason);
            detail.setCount((int)((Counter)entry.getValue()).getCount());
            disconnectionDetails.add(detail);
        }
        netInfo.setDisconnectionDetail(disconnectionDetails);
        LatencyInfo latencyInfo = this.getBlockLatencyInfo();
        netInfo.setLatency(latencyInfo);
    }

    public Protocol.MetricsInfo.NetInfo getNetProtoInfo() {
        Protocol.MetricsInfo.NetInfo.Builder netInfo = Protocol.MetricsInfo.NetInfo.newBuilder();
        NetInfo net = this.getNetInfo();
        netInfo.setErrorProtoCount(net.getErrorProtoCount());
        Protocol.MetricsInfo.NetInfo.ApiInfo.Builder apiInfo = Protocol.MetricsInfo.NetInfo.ApiInfo.newBuilder();
        RateInfo qps = net.getApi().getQps();
        Protocol.MetricsInfo.RateInfo qpsInfo = qps.toProtoEntity();
        apiInfo.setQps(qpsInfo);
        RateInfo failQps = net.getApi().getFailQps();
        Protocol.MetricsInfo.RateInfo failQpsInfo = failQps.toProtoEntity();
        apiInfo.setFailQps(failQpsInfo);
        RateInfo outTraffic = net.getApi().getOutTraffic();
        Protocol.MetricsInfo.RateInfo outTrafficInfo = outTraffic.toProtoEntity();
        apiInfo.setOutTraffic(outTrafficInfo);
        for (ApiDetailInfo apiDetail : net.getApi().getDetail()) {
            RateInfo DetailOutTraffic;
            Protocol.MetricsInfo.NetInfo.ApiInfo.ApiDetailInfo.Builder detailInfo = Protocol.MetricsInfo.NetInfo.ApiInfo.ApiDetailInfo.newBuilder();
            detailInfo.setName(apiDetail.getName());
            RateInfo detailQps = apiDetail.getQps();
            Protocol.MetricsInfo.RateInfo detailQpsInfo = detailQps.toProtoEntity();
            detailInfo.setQps(detailQpsInfo);
            RateInfo detailFailQps = apiDetail.getFailQps();
            if (detailFailQps != null) {
                Protocol.MetricsInfo.RateInfo detailFailQpsInfo = detailFailQps.toProtoEntity();
                detailInfo.setFailQps(detailFailQpsInfo);
            }
            if ((DetailOutTraffic = apiDetail.getOutTraffic()) != null) {
                Protocol.MetricsInfo.RateInfo DetailOutTrafficInfo = DetailOutTraffic.toProtoEntity();
                detailInfo.setOutTraffic(DetailOutTrafficInfo);
            }
            apiInfo.addDetail(detailInfo);
        }
        netInfo.setApi(apiInfo.build());
        netInfo.setConnectionCount(net.getConnectionCount());
        netInfo.setValidConnectionCount(net.getValidConnectionCount());
        netInfo.setDisconnectionCount(net.getDisconnectionCount());
        for (DisconnectionDetailInfo disconnectionDetail : net.getDisconnectionDetail()) {
            Protocol.MetricsInfo.NetInfo.DisconnectionDetailInfo.Builder disconnectionDetailInfo = Protocol.MetricsInfo.NetInfo.DisconnectionDetailInfo.newBuilder();
            disconnectionDetailInfo.setCount(disconnectionDetail.getCount());
            disconnectionDetailInfo.setReason(disconnectionDetail.getReason());
            netInfo.addDisconnectionDetail(disconnectionDetailInfo.build());
        }
        RateInfo tcpInTraffic = net.getTcpInTraffic();
        Protocol.MetricsInfo.RateInfo tcpInTrafficInfo = tcpInTraffic.toProtoEntity();
        netInfo.setTcpInTraffic(tcpInTrafficInfo);
        RateInfo tcpOutTraffic = net.getTcpOutTraffic();
        Protocol.MetricsInfo.RateInfo tcpOUTrafficInfo = tcpOutTraffic.toProtoEntity();
        netInfo.setTcpOutTraffic(tcpOUTrafficInfo);
        RateInfo udpInTraffic = net.getUdpInTraffic();
        Protocol.MetricsInfo.RateInfo udpInTrafficInfo = udpInTraffic.toProtoEntity();
        netInfo.setTcpOutTraffic(udpInTrafficInfo);
        RateInfo udpOutTraffic = net.getUdpOutTraffic();
        Protocol.MetricsInfo.RateInfo udpOutTrafficInfo = udpOutTraffic.toProtoEntity();
        netInfo.setUdpOutTraffic(udpOutTrafficInfo);
        Protocol.MetricsInfo.NetInfo.LatencyInfo.Builder latencyInfo = Protocol.MetricsInfo.NetInfo.LatencyInfo.newBuilder();
        latencyInfo.setTop99(net.getLatency().getTop99());
        latencyInfo.setTop95(net.getLatency().getTop95());
        latencyInfo.setTop75(net.getLatency().getTop75());
        latencyInfo.setTotalCount(net.getLatency().getTotalCount());
        latencyInfo.setDelay1S(net.getLatency().getDelay1S());
        latencyInfo.setDelay2S(net.getLatency().getDelay2S());
        latencyInfo.setDelay3S(net.getLatency().getDelay3S());
        for (LatencyDetailInfo detail : net.getLatency().getDetail()) {
            Protocol.MetricsInfo.NetInfo.LatencyInfo.LatencyDetailInfo.Builder detailInfo = Protocol.MetricsInfo.NetInfo.LatencyInfo.LatencyDetailInfo.newBuilder();
            detailInfo.setTop99(detail.getTop99());
            detailInfo.setTop95(detail.getTop95());
            detailInfo.setTop75(detail.getTop75());
            detailInfo.setCount(detail.getCount());
            detailInfo.setDelay1S(detail.getDelay1S());
            detailInfo.setDelay2S(detail.getDelay2S());
            detailInfo.setDelay3S(detail.getDelay3S());
            latencyInfo.addDetail(detailInfo.build());
        }
        netInfo.setLatency(latencyInfo.build());
        return netInfo.build();
    }

    private LatencyInfo getBlockLatencyInfo() {
        LatencyInfo latencyInfo = new LatencyInfo();
        long delay1SCount = MetricsUtil.getCounter("net.latency.1S").getCount();
        latencyInfo.setDelay1S((int)delay1SCount);
        long delay2SCount = MetricsUtil.getCounter("net.latency.2S").getCount();
        latencyInfo.setDelay2S((int)delay2SCount);
        long delay3SCount = MetricsUtil.getCounter("net.latency.3S").getCount();
        latencyInfo.setDelay3S((int)delay3SCount);
        Histogram blockLatency = MetricsUtil.getHistogram("net.latency");
        latencyInfo.setTop99((int)blockLatency.getSnapshot().get99thPercentile());
        latencyInfo.setTop95((int)blockLatency.getSnapshot().get95thPercentile());
        latencyInfo.setTop75((int)blockLatency.getSnapshot().get75thPercentile());
        latencyInfo.setTotalCount((int)blockLatency.getCount());
        ArrayList<LatencyDetailInfo> latencyDetailInfos = new ArrayList<LatencyDetailInfo>();
        SortedMap<String, Histogram> witnessLatencyMap = MetricsUtil.getHistograms("net.latency.witness.");
        for (Map.Entry<String, Histogram> entry : witnessLatencyMap.entrySet()) {
            LatencyDetailInfo latencyDetailTemp = new LatencyDetailInfo();
            String address = entry.getKey().substring("net.latency.witness.".length());
            latencyDetailTemp.setCount((int)entry.getValue().getCount());
            latencyDetailTemp.setWitness(address);
            latencyDetailTemp.setTop99((int)entry.getValue().getSnapshot().get99thPercentile());
            latencyDetailTemp.setTop95((int)entry.getValue().getSnapshot().get95thPercentile());
            latencyDetailTemp.setTop75((int)entry.getValue().getSnapshot().get75thPercentile());
            long witnessDelay1S = MetricsUtil.getCounter("net.latency.witness." + address + ".1S").getCount();
            latencyDetailTemp.setDelay1S((int)witnessDelay1S);
            long witnessDelay2S = MetricsUtil.getCounter("net.latency.witness." + address + ".2S").getCount();
            latencyDetailTemp.setDelay2S((int)witnessDelay2S);
            long witnessDelay3S = MetricsUtil.getCounter("net.latency.witness." + address + ".3S").getCount();
            latencyDetailTemp.setDelay3S((int)witnessDelay3S);
            latencyDetailInfos.add(latencyDetailTemp);
        }
        latencyInfo.setDetail(latencyDetailInfos);
        return latencyInfo;
    }
}

