/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.metrics;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.core.metrics.MetricsInfo;
import org.tron.core.metrics.blockchain.BlockChainInfo;
import org.tron.core.metrics.blockchain.BlockChainMetricManager;
import org.tron.core.metrics.net.NetInfo;
import org.tron.core.metrics.net.NetMetricManager;
import org.tron.core.metrics.node.NodeInfo;
import org.tron.core.metrics.node.NodeMetricManager;
import org.tron.protos.Protocol;

@Component
public class MetricsApiService {
    private static final Logger logger = LoggerFactory.getLogger((String)"metrics");
    private static final long time = System.currentTimeMillis();
    @Autowired
    private BlockChainMetricManager blockChainMetricManager;
    @Autowired
    private NetMetricManager netMetricManager;
    @Autowired
    private NodeMetricManager nodeMetricManager;

    public MetricsInfo getMetricsInfo() {
        MetricsInfo metricsInfo = new MetricsInfo();
        metricsInfo.setInterval((System.currentTimeMillis() - time) / 1000L);
        NodeInfo nodeInfo = this.nodeMetricManager.getNodeInfo();
        metricsInfo.setNode(nodeInfo);
        BlockChainInfo blockChainInfo = this.blockChainMetricManager.getBlockChainInfo();
        metricsInfo.setBlockchain(blockChainInfo);
        NetInfo netInfo = this.netMetricManager.getNetInfo();
        metricsInfo.setNet(netInfo);
        return metricsInfo;
    }

    public Protocol.MetricsInfo getMetricProtoInfo() {
        Protocol.MetricsInfo.Builder builder = Protocol.MetricsInfo.newBuilder();
        builder.setInterval((System.currentTimeMillis() - time) / 1000L);
        Protocol.MetricsInfo.NodeInfo nodeInfo = this.nodeMetricManager.getNodeProtoInfo();
        builder.setNode(nodeInfo);
        Protocol.MetricsInfo.BlockChainInfo blockChainInfo = this.blockChainMetricManager.getBlockChainProtoInfo();
        builder.setBlockchain(blockChainInfo);
        Protocol.MetricsInfo.NetInfo netInfo = this.netMetricManager.getNetProtoInfo();
        builder.setNet(netInfo);
        return builder.build();
    }
}

