/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db.backup;

import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.tron.common.backup.BackupManager;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.config.args.Args;
import org.tron.core.db.backup.BackupDbUtil;

@Aspect
public class BackupRocksDBAspect {
    private static final Logger logger = LoggerFactory.getLogger(BackupRocksDBAspect.class);
    @Autowired
    private BackupDbUtil util;
    @Autowired
    private BackupManager backupManager;

    @Pointcut(value="execution(** org.tron.core.db.Manager.pushBlock(..)) && args(block)")
    public void pointPushBlock(BlockCapsule block) {
    }

    @Before(value="pointPushBlock(block)")
    public void backupDb(BlockCapsule block) {
        if (Args.getInstance().isWitness() && this.backupManager.getStatus() != BackupManager.BackupStatusEnum.SLAVER) {
            return;
        }
        if (block.getNum() % (long)Args.getInstance().getDbBackupConfig().getFrequency() == 0L) {
            try {
                this.util.doBackup(block);
            }
            catch (Exception e) {
                logger.error("backup db failed:", (Throwable)e);
            }
        }
    }

    @AfterThrowing(value="pointPushBlock(block)")
    public void logErrorPushBlock(BlockCapsule block) {
        logger.info("AfterThrowing pushBlock");
    }
}

