/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db.backup;

import java.util.List;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.utils.PropUtil;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.config.args.Args;
import org.tron.core.db.RevokingDatabase;
import org.tron.core.db2.common.RocksDB;
import org.tron.core.db2.core.Chainbase;
import org.tron.core.db2.core.SnapshotManager;
import org.tron.core.db2.core.SnapshotRoot;

@Component
public class BackupDbUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)"DB");
    private static final String DB_BACKUP_STATE = "DB";
    private static final int DB_BACKUP_INDEX1 = 1;
    private static final int DB_BACKUP_INDEX2 = 2;
    private static final int DB_BACKUP_STATE_DEFAULT = 11;
    @Autowired
    private RevokingDatabase db;
    private CommonParameter parameter = Args.getInstance();

    private int getBackupState() {
        try {
            return Integer.valueOf(PropUtil.readProperty((String)this.parameter.getDbBackupConfig().getPropPath(), (String)DB_BACKUP_STATE));
        }
        catch (NumberFormatException ignore) {
            return 11;
        }
    }

    private void setBackupState(int status) {
        PropUtil.writeProperty((String)this.parameter.getDbBackupConfig().getPropPath(), (String)DB_BACKUP_STATE, (String)String.valueOf(status));
    }

    private void switchBackupState() {
        switch (State.valueOf(this.getBackupState())) {
            case BAKINGONE: {
                this.setBackupState(State.BAKEDONE.getStatus());
                break;
            }
            case BAKEDONE: {
                this.setBackupState(State.BAKEDTWO.getStatus());
                break;
            }
            case BAKINGTWO: {
                this.setBackupState(State.BAKEDTWO.getStatus());
                break;
            }
            case BAKEDTWO: {
                this.setBackupState(State.BAKEDONE.getStatus());
                break;
            }
        }
    }

    public void doBackup(BlockCapsule block) {
        long t1 = System.currentTimeMillis();
        try {
            switch (State.valueOf(this.getBackupState())) {
                case BAKINGONE: {
                    this.deleteBackup(1);
                    this.backup(1);
                    this.switchBackupState();
                    this.deleteBackup(2);
                    break;
                }
                case BAKEDONE: {
                    this.deleteBackup(2);
                    this.backup(2);
                    this.switchBackupState();
                    this.deleteBackup(1);
                    break;
                }
                case BAKINGTWO: {
                    this.deleteBackup(2);
                    this.backup(2);
                    this.switchBackupState();
                    this.deleteBackup(1);
                    break;
                }
                case BAKEDTWO: {
                    this.deleteBackup(1);
                    this.backup(1);
                    this.switchBackupState();
                    this.deleteBackup(2);
                    break;
                }
                default: {
                    logger.warn("invalid backup state {}.", (Object)this.getBackupState());
                    break;
                }
            }
        }
        catch (SecurityException | RocksDBException e) {
            logger.warn("Backup db error.", e);
        }
        long timeUsed = System.currentTimeMillis() - t1;
        logger.info("Current block number is {}, backup all store use {} ms!", (Object)block.getNum(), (Object)timeUsed);
        if (timeUsed >= 3000L) {
            logger.warn("Backing up db uses too much time. {} ms.", (Object)timeUsed);
        }
    }

    private void backup(int i) throws RocksDBException {
        String path = "";
        if (i == 1) {
            path = this.parameter.getDbBackupConfig().getBak1path();
        } else if (i == 2) {
            path = this.parameter.getDbBackupConfig().getBak2path();
        } else {
            throw new RuntimeException(String.format("error backup with undefined index %d", i));
        }
        List stores = ((SnapshotManager)this.db).getDbs();
        for (Chainbase store : stores) {
            if (((SnapshotRoot)store.getHead().getRoot()).getDb().getClass() != RocksDB.class) continue;
            ((RocksDB)((SnapshotRoot)store.getHead().getRoot()).getDb()).getDb().backup(path);
        }
    }

    private void deleteBackup(int i) {
        String path = "";
        if (i == 1) {
            path = this.parameter.getDbBackupConfig().getBak1path();
        } else if (i == 2) {
            path = this.parameter.getDbBackupConfig().getBak2path();
        } else {
            throw new RuntimeException(String.format("error deleteBackup with undefined index %d", i));
        }
        List stores = ((SnapshotManager)this.db).getDbs();
        for (Chainbase store : stores) {
            if (((SnapshotRoot)store.getHead().getRoot()).getDb().getClass() != RocksDB.class) continue;
            ((RocksDB)((SnapshotRoot)store.getHead().getRoot()).getDb()).getDb().deleteDbBakPath(path);
        }
    }

    public static String getDB_BACKUP_STATE() {
        return DB_BACKUP_STATE;
    }

    public static int getDB_BACKUP_STATE_DEFAULT() {
        return 11;
    }

    public RevokingDatabase getDb() {
        return this.db;
    }

    public static enum State {
        BAKINGONE(1),
        BAKEDONE(11),
        BAKINGTWO(2),
        BAKEDTWO(22);

        private int status;

        private State(int status) {
            this.status = status;
        }

        public static State valueOf(int value) {
            switch (value) {
                case 1: {
                    return BAKINGONE;
                }
                case 11: {
                    return BAKEDONE;
                }
                case 2: {
                    return BAKINGTWO;
                }
                case 22: {
                    return BAKEDTWO;
                }
            }
            return BAKEDONE;
        }

        public int getStatus() {
            return this.status;
        }
    }
}

